/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.internal;

import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.ObjectProcessor;
import org.mule.api.service.Service;
import org.mule.ibeans.internal.IBeansObjectFactory;
import org.mule.module.annotationx.jsr330.InjectAnnotationProcessor;
import org.mule.module.annotationx.jsr330.NamedAnnotationProcessor;
import org.mule.module.ibeans.config.IntegrationBeanAnnotatedObjectProcessor;
import org.mule.object.AbstractObjectFactory;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;

public class IBeansPrototypeObjectFactory
extends AbstractObjectFactory
implements IBeansObjectFactory {
    protected Set<ObjectProcessor> processors;
    protected SoftReference<Object> template;
    protected Service service;

    public void setService(Service service) {
        this.service = service;
    }

    public IBeansPrototypeObjectFactory(Object template) {
        super(template.getClass());
        this.template = new SoftReference<Object>(template);
    }

    public Object getInstance(MuleContext muleContext) throws Exception {
        this.initProcessors(muleContext);
        Object o = ClassUtils.instanciateClass((Class)this.getObjectClass(), (Object[])ClassUtils.NO_ARGS);
        for (ObjectProcessor processor : this.processors) {
            processor.process(o);
        }
        return o;
    }

    public void initProcessors(MuleContext muleContext) throws InitialisationException {
        if (this.processors == null) {
            this.processors = new HashSet<ObjectProcessor>();
            try {
                this.processors.add((ObjectProcessor)new AnnotatedPrototypeIntegrationBeanObjectProcessor());
                this.processors.add(this.initProcessor((ObjectProcessor)new InjectAnnotationProcessor(), muleContext));
                this.processors.add(this.initProcessor((ObjectProcessor)new NamedAnnotationProcessor(), muleContext));
            }
            catch (MuleException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    protected ObjectProcessor initProcessor(ObjectProcessor processor, MuleContext muleContext) throws MuleException {
        muleContext.getRegistry().applyProcessors((Object)processor);
        return processor;
    }

    public boolean isExternallyManagedLifecycle() {
        return false;
    }

    public boolean isAutoWireObject() {
        return false;
    }

    private class AnnotatedPrototypeIntegrationBeanObjectProcessor
    extends IntegrationBeanAnnotatedObjectProcessor {
        private AnnotatedPrototypeIntegrationBeanObjectProcessor() {
        }

        public Object process(Object object) {
            String key2 = null;
            try {
                Map props = BeanUtils.describe((Object)IBeansPrototypeObjectFactory.this.template.get());
                for (String key2 : props.keySet()) {
                    Field field;
                    Object value = props.get(key2);
                    if (value == null || Modifier.isFinal((field = object.getClass().getDeclaredField(key2)).getModifiers())) continue;
                    field.setAccessible(true);
                    field.set(object, value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set field '" + key2 + " on " + object);
            }
            return object;
        }
    }
}

