/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.registry.AbstractRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiRegistry
extends AbstractRegistry {
    protected final transient Log logger = LogFactory.getLog(JndiRegistry.class);
    private String contextLookup;
    protected Context context;

    public JndiRegistry(String id, String contextLookup, MuleContext muleContext) {
        super(id, muleContext);
        this.contextLookup = contextLookup;
    }

    protected void doInitialise() throws InitialisationException {
        try {
            this.context = new InitialContext();
            if (this.contextLookup != null) {
                this.context = (Context)this.context.lookup(this.contextLookup);
            }
        }
        catch (NamingException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected void doDispose() {
        try {
            this.context.close();
        }
        catch (NamingException e) {
            this.logger.error((Object)e.getMessage());
        }
    }

    public Object lookupObject(String key) {
        try {
            return this.context.lookup(key);
        }
        catch (NamingException e) {
            this.logger.debug((Object)("Object '" + key + "' not found in Registry: " + this.getRegistryId()));
            return null;
        }
    }

    public <T> Map<String, T> lookupByType(Class<T> tClass) {
        throw new UnsupportedOperationException("lookupByType");
    }

    public Collection lookupObjects(Class type) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Looking up objects by class type is not supported by JNDI registries");
        }
        return Collections.emptyList();
    }

    public final void registerObject(String key, Object value) throws RegistrationException {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public final void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public final void registerObjects(Map objects) throws RegistrationException {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public final void unregisterObject(String key) {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public final void unregisterObject(String key, Object metadata) throws RegistrationException {
        throw new UnsupportedOperationException("Registry is read-only so objects cannot be registered or unregistered.");
    }

    public final boolean isReadOnly() {
        return true;
    }

    public boolean isRemote() {
        return true;
    }
}

