/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.internal;

import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.annotations.meta.Channel;
import org.mule.api.model.Model;
import org.mule.api.service.Service;
import org.mule.ibeans.internal.MuleiBeansAnnotatedServiceBuilder;
import org.mule.module.annotationx.config.AnnotatedServiceBuilder;
import org.mule.module.annotationx.parsers.AnnotatedServiceObjectProcessor;
import org.mule.util.annotation.AnnotationMetaData;
import org.mule.util.annotation.AnnotationUtils;

public class MuleiBeansAnnotatedObjectProcessor
extends AnnotatedServiceObjectProcessor {
    public MuleiBeansAnnotatedObjectProcessor() {
    }

    public MuleiBeansAnnotatedObjectProcessor(MuleContext muleContext) {
        this();
        this.setMuleContext(muleContext);
    }

    public Object process(Object object) {
        List annos = AnnotationUtils.getAllMethodAnnotations(object.getClass());
        if (annos.size() > 0) {
            for (AnnotationMetaData data : annos) {
                if (!data.getAnnotation().annotationType().isAnnotationPresent(Channel.class)) continue;
                String serviceName = object.getClass().getName() + ".service";
                if (this.context.getRegistry().lookupService(serviceName) != null) {
                    return object;
                }
                try {
                    AnnotatedServiceBuilder builder = this.createServiceBuilder(this.context);
                    builder.setModel(this.getOrCreateModel());
                    Service service = builder.createService(object);
                    this.context.getRegistry().registerService(service);
                    break;
                }
                catch (MuleException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return object;
    }

    protected AnnotatedServiceBuilder createServiceBuilder(MuleContext muleContext) throws MuleException {
        return new MuleiBeansAnnotatedServiceBuilder(muleContext);
    }

    protected Model createModel() {
        Model m = super.createModel();
        return m;
    }
}

