/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.internal.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.mule.api.MuleContext;
import org.mule.config.StartupContext;
import org.mule.ibeans.i18n.IBeansMessages;
import org.mule.ibeans.internal.config.IBeansInfo;
import org.mule.util.SplashScreen;
import org.mule.util.StringUtils;

public class StartupSplash
extends SplashScreen {
    protected void doHeader(MuleContext context) {
        String notset = IBeansMessages.notSet().getMessage();
        Manifest mf = IBeansInfo.getManifest();
        Attributes att = mf.getMainAttributes();
        if (att.values().size() > 0) {
            this.header.add(StringUtils.defaultString((String)IBeansInfo.getProductDescription(), (String)notset));
            this.header.add(IBeansMessages.version().getMessage() + " Build: " + StringUtils.defaultString((String)IBeansInfo.getBuildNumber(), (String)notset));
            this.header.add(StringUtils.defaultString((String)IBeansInfo.getVendorName(), (String)notset));
            this.header.add(StringUtils.defaultString((String)IBeansInfo.getProductMoreInfo(), (String)notset));
        } else {
            this.header.add(IBeansMessages.versionNotSet().getMessage());
        }
        this.header.add(" ");
        if (context.getStartDate() > 0L) {
            this.header.add(IBeansMessages.serverStartedAt(context.getStartDate()).getMessage());
        }
        this.header.add("Server ID: " + context.getConfiguration().getId());
        this.header.add("JDK: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.info") + ")");
        this.header.add("OS encoding: " + System.getProperty("file.encoding") + ", iBeans encoding: " + context.getConfiguration().getDefaultEncoding());
        String patch = System.getProperty("sun.os.patch.level", null);
        this.header.add("OS: " + System.getProperty("os.name") + (patch != null && !"unknown".equalsIgnoreCase(patch) ? " - " + patch : "") + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")");
        try {
            InetAddress host = InetAddress.getLocalHost();
            this.header.add("Host: " + host.getHostName() + " (" + host.getHostAddress() + ")");
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        boolean productionMode = StartupContext.get().getStartupOptions().containsKey("production");
        this.header.add("Mode: " + (productionMode ? "Production" : "Development"));
        this.header.add(" ");
    }
}

