/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.junit.Assert;
import org.mule.ibeans.test.IBeansRITestSupport;

public class ExternalPropsIBeansTestSupport
extends IBeansRITestSupport {
    public static final String IBEANS_TEST_PROPERTIES = "ibeans.test.properties";
    public static final String DEFAULT_PROPERTIES_FILENAME = ".ibeans.properties";

    protected void addStartUpProperties(Properties properties) {
        File f;
        String path = System.getProperty(IBEANS_TEST_PROPERTIES, null);
        if (path == null) {
            path = System.getProperty("user.home") + File.separator + DEFAULT_PROPERTIES_FILENAME;
        }
        if (!(f = new File(path)).exists()) {
            Assert.fail((String)("Test properties not found at: " + f.getAbsolutePath() + ". " + IBEANS_TEST_PROPERTIES + " set to: " + path));
        }
        try {
            properties.load(new FileInputStream(f));
        }
        catch (IOException e) {
            Assert.fail((String)("could not load properties for test: " + f.getAbsolutePath() + ", " + e.getMessage()));
        }
    }

    protected String get(String key) {
        Object result = this.iBeansContext.getConfig().get(key);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        Assert.fail((String)("Property with key: " + key + " returned a value that is not a String. Value is: " + result));
        return null;
    }
}

