/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.MimeTypeParseException;
import javax.resource.spi.work.WorkListener;
import org.ibeans.annotation.Return;
import org.ibeans.api.DataType;
import org.ibeans.api.IBeansException;
import org.ibeans.api.Response;
import org.ibeans.api.channel.MimeType;
import org.ibeans.api.channel.MimeTypes;
import org.ibeans.impl.support.datatype.DataTypeFactory;
import org.ibeans.impl.support.datatype.SimpleDataType;
import org.ibeans.impl.test.MockIBean;
import org.ibeans.impl.test.MockMessageCallback;
import org.ibeans.spi.IBeansPlugin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NamedObject;
import org.mule.api.annotations.meta.Channel;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.TransformerException;
import org.mule.config.builders.DefaultsConfigurationBuilder;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.ibeans.IBeansContext;
import org.mule.ibeans.config.PropertiesConfigurationBuilder;
import org.mule.ibeans.internal.config.IBeansMuleContextBuilder;
import org.mule.ibeans.internal.config.IBeansMuleContextFactory;
import org.mule.ibeans.test.TestSupportConfigurationBuilder;
import org.mule.ibeans.transformers.CommonTransformers;
import org.mule.module.annotationx.config.ChannelConfigBuilder;
import org.mule.module.ibeans.config.MockIntegrationBeansAnnotationProcessor;
import org.mule.module.ibeans.spi.MuleIBeansPlugin;
import org.mule.tck.TestingWorkListener;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.annotation.AnnotationMetaData;
import org.mule.util.annotation.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IBeansRITestSupport {
    public static final String[] IGNORED_DOT_MULE_DIRS = new String[]{"transaction-log"};
    protected MuleContext muleContext;
    protected IBeansContext iBeansContext;
    protected boolean startContext = true;
    protected IBeansPlugin plugin;

    protected IBeansPlugin createPlugin() {
        return new MuleIBeansPlugin(this.muleContext);
    }

    protected IBeansRITestSupport() {
        this.validateTestClass();
    }

    public boolean isStartContext() {
        return this.startContext;
    }

    protected void setStartContext(boolean startContext) {
        this.startContext = startContext;
    }

    protected void startContext() throws Exception {
        if (this.isStartContext() && null != this.muleContext && !this.muleContext.isStarted()) {
            this.muleContext.start();
        }
    }

    protected void addStartUpProperties(Properties properties) {
    }

    public void registerBeans(Object ... beans) throws IBeansException {
        for (int i = 0; i < beans.length; ++i) {
            Object bean = beans[i];
            String name = bean.getClass().getSimpleName();
            if (bean instanceof NamedObject && ((NamedObject)bean).getName() != null) {
                name = ((NamedObject)bean).getName();
            }
            try {
                this.muleContext.getRegistry().registerObject(name, bean);
                continue;
            }
            catch (RegistrationException e) {
                throw new IBeansException("Failed to register bean for testing: " + bean, (Throwable)e);
            }
        }
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        contextBuilder.setWorkListener((WorkListener)new TestingWorkListener());
    }

    @Before
    public final void initialiseIBeans() throws Exception {
        System.out.println(StringMessageUtils.getBoilerPlate((String)("Testing: " + this.toString()), (char)'=', (int)80));
        this.createContexts();
        this.startContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public final void disposeIBeans() {
        try {
            if (this.muleContext != null && !this.muleContext.isDisposed() && !this.muleContext.isDisposing()) {
                this.muleContext.dispose();
                String workingDir = this.muleContext.getConfiguration().getWorkingDirectory();
                FileUtils.deleteTree((File)FileUtils.newFile((String)workingDir), (String[])IGNORED_DOT_MULE_DIRS);
            }
            FileUtils.deleteTree((File)FileUtils.newFile((String)"./ActiveMQ"));
        }
        finally {
            this.muleContext = null;
        }
    }

    protected void createContexts() throws Exception {
        this.setStartContext(true);
        this.muleContext = this.createMuleContext();
        this.iBeansContext = (IBeansContext)this.muleContext.getRegistry().lookupObject(IBeansContext.class);
        Assert.assertNotNull((String)"Integration context cannot be null", (Object)this.iBeansContext);
        this.muleContext.getRegistry().registerObject("_mockIntegrationBeanProcessor", (Object)new MockIntegrationBeansAnnotationProcessor());
        this.muleContext.getRegistry().registerObject(this.getClass().getName(), (Object)this);
        this.muleContext.getRegistry().registerObject("_commonTransformers", (Object)new CommonTransformers());
        this.plugin = this.createPlugin();
    }

    private MuleContext createMuleContext() throws Exception {
        IBeansMuleContextFactory muleContextFactory = new IBeansMuleContextFactory();
        ArrayList<ConfigurationBuilder> builders = new ArrayList<ConfigurationBuilder>();
        Properties p = new Properties();
        this.addStartUpProperties(p);
        builders.add((ConfigurationBuilder)new SimpleConfigurationBuilder((Map)p));
        builders.add((ConfigurationBuilder)new DefaultsConfigurationBuilder());
        builders.add((ConfigurationBuilder)new TestSupportConfigurationBuilder());
        PropertiesConfigurationBuilder pcb = new PropertiesConfigurationBuilder();
        pcb.setLoadFromUserHome(true);
        builders.add((ConfigurationBuilder)pcb);
        this.addBuilders(builders);
        IBeansMuleContextBuilder contextBuilder = new IBeansMuleContextBuilder();
        this.configureMuleContext((MuleContextBuilder)contextBuilder);
        MuleContext context = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)contextBuilder);
        return context;
    }

    protected void validateTestClass() {
        List annos = AnnotationUtils.getAllMethodAnnotations(this.getClass());
        if (annos.size() > 0) {
            for (AnnotationMetaData data : annos) {
                if (!data.getAnnotation().annotationType().isAnnotationPresent(Channel.class)) continue;
                throw new IllegalStateException("You cannot use verb annotations such as @Send or @Receive on a test class: " + data.toString());
            }
        }
    }

    protected ChannelConfigBuilder createChannelBuilder(String id, String uri) throws IBeansException {
        try {
            return new ChannelConfigBuilder(id, uri, this.muleContext);
        }
        catch (MuleException e) {
            throw new IBeansException((Throwable)e);
        }
    }

    protected <T> T loadData(String resource, DataType<T> type) throws IOException, TransformerException, MimeTypeParseException {
        InputStream in = IOUtils.getResourceAsStream((String)resource, this.getClass());
        Assert.assertNotNull((String)("Resource stream for: " + resource + " must not be null"), (Object)in);
        return this.getDataAs(in, type);
    }

    protected <T> T getDataAs(InputStream data, DataType<T> type) throws TransformerException, MimeTypeParseException {
        return this.iBeansContext.transform((Object)data, type);
    }

    protected String loadData(String resource) throws TransformerException, IOException, MimeTypeParseException {
        return (String)this.loadData(resource, (DataType)new SimpleDataType(String.class));
    }

    protected Answer withXmlData(String resource, MockMessageCallback callback, Object ibean) {
        return this.withData(resource, MimeTypes.XML.toString(), callback, ibean);
    }

    protected Answer withRssData(String resource, MockMessageCallback callback, Object ibean) {
        return this.withData(resource, MimeTypes.RSS.toString(), callback, ibean);
    }

    protected Answer withAtomData(String resource, MockMessageCallback callback, Object ibean) {
        return this.withData(resource, MimeTypes.ATOM.toString(), callback, ibean);
    }

    protected Answer withJsonData(String resource, MockMessageCallback callback, Object ibean) {
        return this.withData(resource, MimeTypes.JSON.toString(), callback, ibean);
    }

    protected Answer withTextData(String resource, MockMessageCallback callback, Object ibean) {
        return this.withData(resource, MimeTypes.TEXT.toString(), callback, ibean);
    }

    protected Answer withXmlData(String resource, Object ibean) {
        return this.withData(resource, MimeTypes.XML, null, ibean);
    }

    protected Answer withRssData(String resource, Object ibean) {
        return this.withData(resource, MimeTypes.RSS, null, ibean);
    }

    protected Answer withAtomData(String resource, Object ibean) {
        return this.withData(resource, MimeTypes.ATOM, null, ibean);
    }

    protected Answer withJsonData(String resource, Object ibean) {
        return this.withData(resource, MimeTypes.JSON, null, ibean);
    }

    protected Answer withTextData(String resource, Object ibean) {
        return this.withData(resource, MimeTypes.TEXT, null, ibean);
    }

    protected Answer withData(final String resource, final Class returnType) {
        return new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return IBeansRITestSupport.this.loadData(resource, DataTypeFactory.create((Class)returnType));
            }
        };
    }

    protected Answer withData(final String resource, final MimeType mimeType, final MockMessageCallback callback, final Object ibean) {
        return new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                MimeType mime = mimeType;
                DataType ret = ((MockIBean)ibean).ibeanReturnType();
                if (ret != null) {
                    ret.setMimeType(mime.toString());
                }
                if (ret == null || invocation.getMethod().isAnnotationPresent(Return.class) || !invocation.getMethod().getReturnType().isAssignableFrom(ret.getType())) {
                    ret = DataTypeFactory.createFromReturnType((Method)invocation.getMethod());
                    mime = null;
                }
                Object data = IBeansRITestSupport.this.loadData(resource, ret);
                ((MockIBean)ibean).ibeanSetMimeType(mime);
                ((MockIBean)ibean).ibeanSetMessageCallback(callback);
                HashMap<String, String> headers = null;
                if (mime != null) {
                    headers = new HashMap<String, String>();
                    headers.put("Content-Type", mime.toString());
                }
                Response response = IBeansRITestSupport.this.plugin.createResponse(data, headers, null);
                if (callback != null) {
                    callback.onMessage(response);
                }
                return data;
            }
        };
    }

    protected Answer withData(final String resource, final String mimeType, final MockMessageCallback callback, final Object ibean) {
        return new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                String mime = mimeType;
                DataType ret = ((MockIBean)ibean).ibeanReturnType();
                if (ret != null) {
                    ret.setMimeType(mime);
                }
                if (ret == null || invocation.getMethod().isAnnotationPresent(Return.class) || !invocation.getMethod().getReturnType().isAssignableFrom(ret.getType())) {
                    new DataTypeFactory();
                    ret = DataTypeFactory.createFromReturnType((Method)invocation.getMethod());
                    mime = null;
                }
                Object data = IBeansRITestSupport.this.loadData(resource, ret);
                if (mime != null) {
                    ((MockIBean)ibean).ibeanSetMimeType(new MimeType(mime));
                }
                ((MockIBean)ibean).ibeanSetMessageCallback(callback);
                return data;
            }
        };
    }

    protected MuleMessage createMuleMessage(Object payload, Map properties) {
        return new DefaultMuleMessage(payload, properties, null, null, this.muleContext);
    }

    protected MuleMessage createMuleMessage(Object payload) {
        return new DefaultMuleMessage(payload, this.muleContext);
    }

    public int generateId() {
        Double d = Math.random() * 1.0E7;
        return d.intValue();
    }
}

