/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.web;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.api.MuleContext;
import org.mule.module.ibeans.config.IBeanHolder;

public class IBeansUsageServlet
extends HttpServlet {
    private Collection<IBeanHolder> ibeansCache;

    public void init() throws ServletException {
        MuleContext muleContext = (MuleContext)this.getServletContext().getAttribute("mule.context");
        this.ibeansCache = muleContext.getRegistry().lookupObjects(IBeanHolder.class);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        int i = path.lastIndexOf("/");
        String ibeanId = path.substring(i + 1);
        i = ibeanId.indexOf(".");
        String format = "text";
        if (i != -1) {
            format = ibeanId.substring(i + 1);
            ibeanId = ibeanId.substring(0, i);
        }
        for (IBeanHolder holder : this.ibeansCache) {
            if (!ibeanId.equals(holder.getId())) continue;
            String usage = holder.getUsage();
            response.setContentType("text/plain");
            response.getOutputStream().print(usage);
            response.flushBuffer();
            return;
        }
        this.log("ibean not found: " + ibeanId);
        response.sendError(404, "ibean not found: " + ibeanId);
    }
}

