/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.operation;

import java.lang.reflect.Method;
import java.util.Map;
import javax.inject.Inject;
import org.mule.extensions.java.api.exception.ArgumentMismatchModuleException;
import org.mule.extensions.java.api.exception.ClassNotFoundModuleException;
import org.mule.extensions.java.api.exception.InvocationModuleException;
import org.mule.extensions.java.api.exception.NoSuchMethodModuleException;
import org.mule.extensions.java.api.exception.WrongTypeModuleException;
import org.mule.extensions.java.internal.JavaModuleUtils;
import org.mule.extensions.java.internal.cache.JavaModuleLoadingCache;
import org.mule.extensions.java.internal.error.JavaInvokeErrorProvider;
import org.mule.extensions.java.internal.metadata.InstanceMethodTypeResolver;
import org.mule.extensions.java.internal.metadata.StaticMethodTypeResolver;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.extensions.java.internal.parameters.MethodIdentifier;
import org.mule.extensions.java.internal.parameters.StaticMethodIdentifier;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;

public class JavaInvokeOperations {
    @Inject
    private JavaModuleLoadingCache cache;
    @Inject
    private TransformationService transformationService;
    @Inject
    private ExpressionManager expressionManager;

    @Throws(value={JavaInvokeErrorProvider.class})
    @OutputResolver(output=StaticMethodTypeResolver.class)
    public Object invokeStatic(@ParameterGroup(name="Method") @MetadataKeyId(value=StaticMethodTypeResolver.class) StaticMethodIdentifier identifier, @Optional @NullSafe @Content @TypeResolver(value=StaticMethodTypeResolver.class) Map<String, TypedValue<Object>> args) throws ClassNotFoundModuleException, ArgumentMismatchModuleException, InvocationModuleException, NoSuchMethodModuleException {
        Class<?> targetClass = this.cache.loadClass(identifier.getClazz());
        Method method = this.cache.getMethod(identifier, targetClass, args, true);
        return JavaModuleUtils.invokeMethod(method, args, null, () -> this.failureMsg(identifier, method), this.transformationService, this.expressionManager);
    }

    @Throws(value={JavaInvokeErrorProvider.class})
    @OutputResolver(output=InstanceMethodTypeResolver.class)
    public Object invoke(@ParameterGroup(name="Method") @MetadataKeyId(value=InstanceMethodTypeResolver.class) MethodIdentifier identifier, Object instance, @Optional @NullSafe @Content @TypeResolver(value=InstanceMethodTypeResolver.class) Map<String, TypedValue<Object>> args) throws ClassNotFoundModuleException, WrongTypeModuleException, ArgumentMismatchModuleException, InvocationModuleException, NoSuchMethodModuleException {
        JavaModuleUtils.validateType(identifier.getClazz(), instance, true, this.cache);
        Method method = this.cache.getMethod(identifier, instance.getClass(), args, false);
        return JavaModuleUtils.invokeMethod(method, args, instance, () -> this.failureMsg(identifier, method), this.transformationService, this.expressionManager);
    }

    private String failureMsg(ExecutableIdentifier identifier, Method method) {
        return String.format("Failed to invoke Method [%s] in Class [%s]", identifier.getElementId(), method.getDeclaringClass().getName());
    }
}

