/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.api.exception;

import java.lang.reflect.Executable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.extensions.java.api.error.JavaModuleError;
import org.mule.extensions.java.api.exception.JavaModuleException;
import org.mule.extensions.java.internal.JavaModuleUtils;
import org.mule.runtime.api.metadata.TypedValue;

public class InvocationModuleException
extends JavaModuleException {
    public InvocationModuleException(String componentDescription, Executable executable, Map<String, TypedValue<Object>> args, Throwable cause) {
        super(InvocationModuleException.buildMessage(componentDescription, executable, JavaModuleUtils.toHumanReadableArgs(args), JavaModuleUtils.getCauseMessage(cause)), JavaModuleError.INVOCATION, cause);
    }

    private static String buildMessage(String componentDescription, Executable executable, List<String> args, Optional<String> cause) {
        StringBuilder sb = new StringBuilder().append("Invocation of ").append(componentDescription).append(JavaModuleUtils.getArgumentsMessage(args)).append(" resulted in an error");
        if (executable.getParameters().length > 0) {
            sb.append(".\nExpected arguments are ").append(JavaModuleUtils.toHumanReadableArgs(executable));
        }
        cause.ifPresent(causeMessage -> sb.append(".\nCause: ").append((String)causeMessage));
        return sb.toString();
    }
}

