/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.operation;

import java.lang.reflect.Method;
import java.util.Map;
import javax.inject.Inject;
import org.mule.extensions.java.api.exception.ArgumentMismatchModuleException;
import org.mule.extensions.java.api.exception.ClassNotFoundModuleException;
import org.mule.extensions.java.api.exception.InvocationModuleException;
import org.mule.extensions.java.api.exception.NoSuchMethodModuleException;
import org.mule.extensions.java.api.exception.WrongTypeModuleException;
import org.mule.extensions.java.internal.JavaModuleUtils;
import org.mule.extensions.java.internal.cache.JavaModuleLoadingCache;
import org.mule.extensions.java.internal.error.JavaInvokeErrorProvider;
import org.mule.extensions.java.internal.error.JavaStaticInvokeErrorProvider;
import org.mule.extensions.java.internal.metadata.InstanceMethodTypeResolver;
import org.mule.extensions.java.internal.metadata.StaticMethodTypeResolver;
import org.mule.extensions.java.internal.parameters.MethodIdentifier;
import org.mule.extensions.java.internal.parameters.StaticMethodIdentifier;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.execution.Execution;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaInvokeOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaInvokeOperations.class);
    @Inject
    private JavaModuleLoadingCache cache;
    @Inject
    private TransformationService transformationService;
    @Inject
    private ExpressionManager expressionManager;

    @Throws(value={JavaStaticInvokeErrorProvider.class})
    @OutputResolver(output=StaticMethodTypeResolver.class)
    @Execution(value=ExecutionType.BLOCKING)
    public Object invokeStatic(@ParameterGroup(name="Method") @MetadataKeyId(value=StaticMethodTypeResolver.class) StaticMethodIdentifier identifier, @Optional @NullSafe @Content @TypeResolver(value=StaticMethodTypeResolver.class) Map<String, TypedValue<Object>> args) throws ClassNotFoundModuleException, ArgumentMismatchModuleException, InvocationModuleException, NoSuchMethodModuleException {
        Class<?> targetClass = this.cache.loadClass(identifier.getClazz());
        Method method = this.cache.getMethod(identifier, targetClass, args, true);
        return JavaModuleUtils.invokeMethod(method, args, null, identifier, this.transformationService, this.expressionManager, LOGGER);
    }

    @Throws(value={JavaInvokeErrorProvider.class})
    @OutputResolver(output=InstanceMethodTypeResolver.class)
    @Execution(value=ExecutionType.BLOCKING)
    public Object invoke(@ParameterGroup(name="Method") @MetadataKeyId(value=InstanceMethodTypeResolver.class) MethodIdentifier identifier, Object instance, @Optional @NullSafe @Content @TypeResolver(value=InstanceMethodTypeResolver.class) Map<String, TypedValue<Object>> args) throws ClassNotFoundModuleException, WrongTypeModuleException, ArgumentMismatchModuleException, InvocationModuleException, NoSuchMethodModuleException {
        JavaModuleUtils.validateType(identifier.getClazz(), instance, true, this.cache);
        Method method = this.cache.getMethod(identifier, instance.getClass(), args, false);
        return JavaModuleUtils.invokeMethod(method, args, instance, identifier, this.transformationService, this.expressionManager, LOGGER);
    }
}

