/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.operation;

import java.lang.reflect.Method;
import java.util.Map;
import javax.inject.Inject;
import org.mule.extensions.java.api.exception.ArgumentMismatchModuleException;
import org.mule.extensions.java.api.exception.ClassNotFoundModuleException;
import org.mule.extensions.java.api.exception.InvocationModuleException;
import org.mule.extensions.java.api.exception.NoSuchMethodModuleException;
import org.mule.extensions.java.api.exception.WrongTypeModuleException;
import org.mule.extensions.java.internal.cache.JavaModuleLoadingCache;
import org.mule.extensions.java.internal.error.JavaInvokeErrorProvider;
import org.mule.extensions.java.internal.error.JavaStaticInvokeErrorProvider;
import org.mule.extensions.java.internal.metadata.InstanceMethodTypeResolver;
import org.mule.extensions.java.internal.metadata.StaticMethodTypeResolver;
import org.mule.extensions.java.internal.parameters.MethodIdentifier;
import org.mule.extensions.java.internal.parameters.StaticMethodIdentifier;
import org.mule.extensions.java.internal.util.JavaModuleUtils;
import org.mule.extensions.java.internal.util.MethodInvoker;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaInvokeOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaInvokeOperations.class);
    private static final String MIME_TYPE_TAB = "MIME Type";
    @Inject
    private JavaModuleLoadingCache cache;
    @Inject
    private TransformationService transformationService;
    @Inject
    private ExpressionManager expressionManager;

    @Throws(value={JavaStaticInvokeErrorProvider.class})
    @OutputResolver(output=StaticMethodTypeResolver.class)
    public Result<Object, Void> invokeStatic(@ParameterGroup(name="Method") @MetadataKeyId(value=StaticMethodTypeResolver.class) StaticMethodIdentifier identifier, @Optional @NullSafe @Content @TypeResolver(value=StaticMethodTypeResolver.class) Map<String, TypedValue<Object>> args, @Optional @Placement(tab="MIME Type") @Summary(value="The mime type of the payload that this invocation will output") String outputMimeType, @Optional @Placement(tab="MIME Type") @Summary(value="The encoding of the payload that this invocation will output") String outputEncoding, @DefaultEncoding String defaultEncoding) throws ClassNotFoundModuleException, ArgumentMismatchModuleException, InvocationModuleException, NoSuchMethodModuleException {
        Class<?> targetClass = this.cache.loadClass(identifier.getClazz());
        Method method = this.cache.getMethod(identifier, targetClass, args, true);
        return MethodInvoker.invokeMethod(method, args, null, identifier, outputMimeType, outputEncoding, this.transformationService, this.expressionManager, LOGGER, defaultEncoding);
    }

    @Throws(value={JavaInvokeErrorProvider.class})
    @OutputResolver(output=InstanceMethodTypeResolver.class)
    public Result<Object, Void> invoke(@ParameterGroup(name="Method") @MetadataKeyId(value=InstanceMethodTypeResolver.class) MethodIdentifier identifier, Object instance, @Optional @NullSafe @Content @TypeResolver(value=InstanceMethodTypeResolver.class) Map<String, TypedValue<Object>> args, @Optional @Placement(tab="MIME Type") @Summary(value="The mime type of the payload that this invocation will output") String outputMimeType, @Optional @Placement(tab="MIME Type") @Summary(value="The encoding of the payload that this invocation will output") String outputEncoding, @DefaultEncoding String defaultEncoding) throws ClassNotFoundModuleException, WrongTypeModuleException, ArgumentMismatchModuleException, InvocationModuleException, NoSuchMethodModuleException {
        JavaModuleUtils.validateType(identifier.getClazz(), instance, true, this.cache);
        Method method = this.cache.getMethod(identifier, instance.getClass(), args, false);
        return MethodInvoker.invokeMethod(method, args, instance, identifier, outputMimeType, outputEncoding, this.transformationService, this.expressionManager, LOGGER, defaultEncoding);
    }
}

