/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.transformer;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;

public class ParameterTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterTransformer.class);
    private static String TRANSFORMATION_SERVICE_ERROR_MESSAGE = "Transformation from type %s to %s could not be done using the Transformation Service";
    private static String DATAWEAVE_TRANSFORMATION_ERROR_MESSAGE = "Transformation from type %s to %s could not be done using a DataWeave Transformation";
    private static Class<? extends Map> DEFAULT_MAP_IMPLEMENTATION = HashMap.class;
    private static Class<? extends Collection> DEFAULT_COLLECTION_IMPLEMENTATION = LinkedList.class;
    private Executable executable;
    private TransformationService transformationService;
    private ExpressionManager expressionManager;
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Character.TYPE, Character.class);
            this.put(Double.TYPE, Double.class);
            this.put(Float.TYPE, Float.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Short.TYPE, Short.class);
            this.put(Void.TYPE, Void.class);
        }
    };

    public ParameterTransformer(Executable executable, TransformationService transformationService, ExpressionManager expressionManager) {
        this.executable = executable;
        this.transformationService = transformationService;
        this.expressionManager = expressionManager;
    }

    private <T> Class<T> wrap(Class<T> c) {
        return c.isPrimitive() ? PRIMITIVES_TO_WRAPPERS.get(c) : c;
    }

    public boolean parameterNeedsTransformation(Object value, int parameterIndex) {
        ResolvableType parameterResolvableType = this.getResolvableType(parameterIndex);
        return this.parameterNeedsTransformation(value, parameterResolvableType);
    }

    private boolean parameterNeedsTransformation(Object value, ResolvableType parameterResolvableType) {
        Class<?> wrappedParameterType = this.wrap(this.resolveType(parameterResolvableType));
        if (value == null) {
            return Optional.class.isAssignableFrom(wrappedParameterType);
        }
        if (wrappedParameterType.isAssignableFrom(value.getClass())) {
            if (Map.class.isAssignableFrom(value.getClass())) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    if (!this.parameterNeedsTransformation(entry.getKey(), parameterResolvableType.getGeneric(new int[]{0})) && !this.parameterNeedsTransformation(entry.getValue(), parameterResolvableType.getGeneric(new int[]{1}))) continue;
                    return true;
                }
            } else if (Collection.class.isAssignableFrom(value.getClass())) {
                for (Object collectionItem : (Collection)value) {
                    if (!this.parameterNeedsTransformation(collectionItem, parameterResolvableType.getGeneric(new int[]{0}))) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public Optional<Object> transformParameter(Object value, int parameterIndex) {
        ResolvableType parameterResolvableType = this.getResolvableType(parameterIndex);
        return this.transformParameter(value, parameterResolvableType);
    }

    private Optional<Object> transformParameter(Object value, ResolvableType expectedType) {
        Class<?> wrappedParameterType = this.wrap(this.resolveType(expectedType));
        if (value == null) {
            return Optional.class.isAssignableFrom(wrappedParameterType) ? Optional.of(Optional.empty()) : Optional.empty();
        }
        if (this.mapResolutionNeeded(value, expectedType)) {
            return Optional.of(this.transformMap((Map)value, expectedType));
        }
        if (this.collectionResolutionNeeded(value, expectedType)) {
            return Optional.of(this.transformCollection((Collection)value, expectedType));
        }
        if (wrappedParameterType.isAssignableFrom(value.getClass())) {
            return Optional.of(value);
        }
        Optional<Object> transformedValue = this.doServiceTransform(value, wrappedParameterType);
        if (transformedValue.isPresent()) {
            return transformedValue;
        }
        transformedValue = this.doExpressionTransform(value, wrappedParameterType);
        if (transformedValue.isPresent()) {
            return transformedValue;
        }
        return this.hasGenerics(expectedType) ? Optional.of(value) : Optional.empty();
    }

    private boolean hasGenerics(ResolvableType parameterResolvableType) {
        return parameterResolvableType.hasGenerics() || parameterResolvableType.hasUnresolvableGenerics();
    }

    private Optional<Object> doServiceTransform(Object value, Class<?> wrappedParameterType) {
        block3: {
            try {
                Object transformedValue = this.transformationService.transform(value, DataType.fromType(value.getClass()), DataType.fromType(wrappedParameterType));
                if (wrappedParameterType.isAssignableFrom(transformedValue.getClass())) {
                    return Optional.ofNullable(transformedValue);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug(String.format(TRANSFORMATION_SERVICE_ERROR_MESSAGE, value.getClass(), wrappedParameterType));
            }
        }
        return Optional.empty();
    }

    private Optional<Object> doExpressionTransform(Object value, Class<?> wrappedParameterType) {
        block3: {
            try {
                BindingContext context = BindingContext.builder().addBinding("payload", TypedValue.of((Object)value)).build();
                Object expressionValue = this.expressionManager.evaluate("#[payload]", DataType.fromType(wrappedParameterType), context).getValue();
                if (wrappedParameterType.isAssignableFrom(expressionValue.getClass())) {
                    return Optional.ofNullable(expressionValue);
                }
            }
            catch (ExpressionExecutionException | ExpressionRuntimeException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug(DATAWEAVE_TRANSFORMATION_ERROR_MESSAGE, value.getClass(), wrappedParameterType);
            }
        }
        return Optional.empty();
    }

    private Object transformCollection(Collection values, ResolvableType parameterResolvableType) {
        Collection collection = this.getCollectionImplementation(values, parameterResolvableType);
        for (Object originalItem : values) {
            Optional<Object> transformedItem = this.transformParameter(originalItem, parameterResolvableType.getGeneric(new int[]{0}));
            collection.add(transformedItem.orElse(originalItem));
        }
        return collection;
    }

    private Collection getCollectionImplementation(Collection value, ResolvableType parameterResolvableType) {
        Collection result;
        Class<?> valueClass = value.getClass();
        Class parameterClass = parameterResolvableType.resolve();
        if (parameterClass.isAssignableFrom(valueClass) && (result = (Collection)this.tryToCreateInstanse(valueClass)) != null) {
            return result;
        }
        result = (Collection)this.tryToCreateInstanse(parameterClass);
        if (result != null) {
            return result;
        }
        return this.tryToCreateInstanse(DEFAULT_COLLECTION_IMPLEMENTATION);
    }

    private Object transformMap(Map<Object, Object> value, ResolvableType parameterResolvableType) {
        Map map = this.getMapImplementation(value, parameterResolvableType);
        for (Map.Entry<Object, Object> entry : value.entrySet()) {
            Optional<Object> transformedKey = this.transformParameter(entry.getKey(), parameterResolvableType.getGeneric(new int[]{0}));
            Optional<Object> transformedValue = this.transformParameter(entry.getValue(), parameterResolvableType.getGeneric(new int[]{1}));
            map.put(transformedKey.orElse(entry.getKey()), transformedValue.orElse(entry.getValue()));
        }
        return map;
    }

    private Map getMapImplementation(Map value, ResolvableType parameterResolvableType) {
        Map result;
        Class<?> valueClass = value.getClass();
        Class parameterClass = parameterResolvableType.resolve();
        if (parameterClass.isAssignableFrom(valueClass) && (result = (Map)this.tryToCreateInstanse(valueClass)) != null) {
            return result;
        }
        result = (Map)this.tryToCreateInstanse(parameterClass);
        if (result != null) {
            return result;
        }
        return this.tryToCreateInstanse(DEFAULT_MAP_IMPLEMENTATION);
    }

    private boolean mapResolutionNeeded(Object value, ResolvableType parameterResolvableType) {
        return value instanceof Map && Map.class.isAssignableFrom(this.resolveType(parameterResolvableType));
    }

    private boolean collectionResolutionNeeded(Object value, ResolvableType parameterResolvableType) {
        return value instanceof Collection && Collection.class.isAssignableFrom(this.resolveType(parameterResolvableType));
    }

    private ResolvableType getResolvableType(int parameterIndex) {
        if (this.executable instanceof Method) {
            return ResolvableType.forMethodParameter((Method)((Method)this.executable), (int)parameterIndex);
        }
        if (this.executable instanceof Constructor) {
            return ResolvableType.forConstructorParameter((Constructor)((Constructor)this.executable), (int)parameterIndex);
        }
        throw new IllegalStateException("Failed when trying to retrieve Resolvable type from executable. A 'Method' or 'Contructor' was expected, executable was a " + this.executable.getClass().getName());
    }

    private <T> T tryToCreateInstanse(Class<T> clazz) {
        try {
            T result = clazz.newInstance();
            return result;
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    private Class<?> resolveType(ResolvableType resolvableType) {
        Class<Object> parameterTypeResolved = resolvableType.resolve();
        if (parameterTypeResolved == null) {
            parameterTypeResolved = Object.class;
        }
        return parameterTypeResolved;
    }
}

