/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.base;

import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.Factory;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.EdiSchemaVersion;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import com.mulesoft.flatfile.schema.yaml.YamlReader$;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.mule.api.MuleContext;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.modules.edi.base.TransmissionSupport;
import org.mule.util.lock.LockFactory;
import scala.collection.Map;
import scala.collection.convert.WrapAsJava$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;

public abstract class BaseEdiModule {
    public static List<String> CURRENT_DIR_LIST = List$.MODULE$.empty().$colon$colon((Object)"");
    private static final long LOCK_WAIT_SECONDS = 15L;
    protected B2BProvider b2bProvider;
    protected TransmissionSupport transmissionSupport;
    protected Factory<QueryObject> queryObjectFactory;
    private EdiSchema combinedSchema;
    private ObjectStore counterObjectStore;
    private LockFactory lockFactory;
    private java.util.Map<String, Structure> loadedSchemas = new ConcurrentHashMap<String, Structure>();

    public synchronized void setCounterObjectStore(ObjectStore<? extends Serializable> counterObjectStore) {
        this.counterObjectStore = counterObjectStore;
    }

    public abstract java.util.List<String> getSchemas();

    protected abstract MuleRegistry getRegistry();

    public EdiSchema getCombinedSchema() {
        return this.combinedSchema;
    }

    public static Object getOrDefault(java.util.Map<String, Object> map, String key, Object dflt) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return dflt;
    }

    protected void doStart() {
        MuleContext context = (MuleContext)this.getRegistry().lookupObject("_muleContext");
        this.lockFactory = context.getLockFactory();
        if (this.counterObjectStore == null) {
            this.counterObjectStore = (ObjectStore)this.getRegistry().lookupObject("_defaultUserObjectStore");
            if (this.counterObjectStore == null) {
                throw new IllegalArgumentException("Unable to acquire an object store.");
            }
        }
    }

    protected String nonnull(Serializable s1, String s2) {
        if (s1 != null) {
            return s1.toString();
        }
        return s2;
    }

    protected boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected void setNullDefault(String key, String dflt, java.util.Map<String, Object> map) {
        if (map.get(key) == null && !this.isEmpty(dflt)) {
            map.put(key, dflt);
        }
    }

    protected String validateIdProperty(String text, int minl, int maxl, String name) {
        int length = text.length();
        if (length < minl - 1) {
            throw new IllegalArgumentException("Value '" + text + "' too short for " + name);
        }
        if (length > maxl) {
            throw new IllegalArgumentException("Value '" + text + "' too long for " + name);
        }
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr >= 'A' && chr <= 'Z' || chr >= 'a' && chr <= 'z' || chr >= '0' && chr <= '9') continue;
            throw new IllegalArgumentException("Character '" + chr + "' not allowed in id value " + name);
        }
        return text;
    }

    protected Character validateSeparator(Character separator, String name) {
        char chr = separator.charValue();
        if (Character.isAlphabetic(chr) || Character.isDigit(chr)) {
            throw new IllegalArgumentException("Invalid separator or substitution character " + chr + " for " + name);
        }
        return separator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Integer getNextInteger(String key, int initial) {
        Lock lock = this.lockFactory.createLock(key);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to increment number " + key);
            try {
                Integer count;
                if (this.counterObjectStore.contains((Serializable)((Object)key))) {
                    count = (Integer)this.counterObjectStore.retrieve((Serializable)((Object)key));
                    count = count + 1;
                    this.counterObjectStore.remove((Serializable)((Object)key));
                } else {
                    count = initial;
                }
                this.counterObjectStore.store((Serializable)((Object)key), (Serializable)count);
                Integer n = count;
                return n;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Could not increment number " + key, e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to increment number " + key);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Long getNextLong(String key, long initial) {
        Lock lock = this.lockFactory.createLock(key);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to increment number " + key);
            try {
                Long count;
                if (this.counterObjectStore.contains((Serializable)((Object)key))) {
                    count = (Long)this.counterObjectStore.retrieve((Serializable)((Object)key));
                    count = count + 1L;
                    this.counterObjectStore.remove((Serializable)((Object)key));
                } else {
                    count = initial;
                }
                this.counterObjectStore.store((Serializable)((Object)key), (Serializable)count);
                Long l = count;
                return l;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Could not increment number " + key, e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to increment number " + key);
        }
    }

    protected String incrementString(String value, int maxlen) {
        char ch;
        int split;
        for (split = value.length(); split > 0 && (ch = value.charAt(split - 1)) >= '0' && ch <= '9'; --split) {
        }
        long seq = split < value.length() ? Long.parseLong(value.substring(split)) : 0L;
        String suffix = Long.toString(seq + 1L);
        int excess = split + suffix.length() - maxlen;
        if (excess > 0) {
            if (excess >= suffix.length()) {
                throw new RuntimeException("Unable to increment string already at maximum length");
            }
            suffix = suffix.substring(excess);
        }
        return value.substring(0, split) + suffix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getNextString(String key, String initial, int maxlen) {
        Lock lock = this.lockFactory.createLock(key);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to update identifier " + key);
            try {
                String value;
                if (this.counterObjectStore.contains((Serializable)((Object)key))) {
                    value = this.incrementString(this.counterObjectStore.retrieve((Serializable)((Object)key)).toString(), maxlen);
                    this.counterObjectStore.remove((Serializable)((Object)key));
                } else {
                    value = initial;
                }
                this.counterObjectStore.store((Serializable)((Object)key), (Serializable)((Object)value));
                String string = value;
                return string;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Could not update identifier " + key, e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to update identifier " + key);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cacheIdentifier(String ident) {
        Lock lock = this.lockFactory.createLock(ident);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to cache identifier " + ident);
            try {
                if (this.counterObjectStore.contains((Serializable)((Object)ident))) {
                    boolean bl = false;
                    return bl;
                }
                this.counterObjectStore.store((Serializable)((Object)ident), (Serializable)((Object)""));
                boolean bl = true;
                return bl;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Could not cache identifier " + ident, e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to cache identifier " + ident);
        }
    }

    private static String schemaPath(String type, String version, String ident) {
        return File.separator + type.toLowerCase() + File.separator + version.toLowerCase() + File.separator + ident + ".esl";
    }

    private static EdiSchema mergeAcks(java.util.List<Structure> acks, EdiSchema merged) {
        if (acks != null) {
            for (Structure struct : acks) {
                merged = merged.merge(struct);
            }
        }
        return merged;
    }

    public static EdiSchema loadSchema(String path, YamlReader yamlrdr, boolean identKeys) {
        YamlReader.InputSource source = YamlReader$.MODULE$.findSchema(path);
        return yamlrdr.loadYaml((Reader)new InputStreamReader(source.input()), source.prefixPaths(), identKeys);
    }

    public static EdiSchema loadSchema(String path, YamlReader yamlrdr) {
        return BaseEdiModule.loadSchema(path, yamlrdr, false);
    }

    protected java.util.List<EdiSchema> loadSchemas(boolean identKeys, boolean codeSets) {
        ArrayList<EdiSchema> schemas = new ArrayList<EdiSchema>();
        java.util.List<String> paths = this.getSchemas();
        if (paths != null) {
            YamlReader yamlrdr = new YamlReader();
            for (String path : paths) {
                try {
                    EdiSchema schema = BaseEdiModule.loadSchema(path, yamlrdr, identKeys);
                    if (codeSets) {
                        int split;
                        File file = new File(path);
                        String cspath = file.exists() ? file.getParent() : ((split = path.lastIndexOf(47)) < 0 ? "" : path.substring(0, split));
                        schema = yamlrdr.addCodeSets(schema, cspath, CURRENT_DIR_LIST);
                    }
                    schemas.add(schema);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not load schema " + path, e);
                }
            }
        }
        return schemas;
    }

    protected java.util.List<EdiSchema> loadSchemas() {
        return this.loadSchemas(false, false);
    }

    protected void buildCombinedSchema(java.util.List<Structure> acks, EdiSchemaVersion dfltVersion, boolean codeSets) {
        EdiSchema merged = null;
        java.util.List<EdiSchema> schemas = this.loadSchemas(false, codeSets);
        if (schemas.isEmpty()) {
            merged = new EdiSchema(dfltVersion);
        } else {
            for (EdiSchema schema : schemas) {
                java.util.Map map = WrapAsJava$.MODULE$.mapAsJavaMap((Map)schema.structures());
                for (String ident : map.keySet()) {
                    EdiSchemaVersion version = schema.ediVersion();
                    String key = BaseEdiModule.schemaPath(version.ediForm().text(), version.version(), ident);
                    this.loadedSchemas.put(key, (Structure)map.get(ident));
                }
                if (merged == null) {
                    merged = schema;
                } else if (merged.ediVersion().equals((Object)schema.ediVersion())) {
                    merged = merged.merge(schema);
                } else {
                    throw new IllegalArgumentException("Configured schema version conflict (" + merged.ediVersion().version() + " vs. " + schema.ediVersion().version() + ")");
                }
                merged = merged == null ? schema : merged.merge(schema);
            }
        }
        this.combinedSchema = merged = BaseEdiModule.mergeAcks(acks, merged);
    }

    protected Structure getSchema(String type, String version, String ident) {
        String path = BaseEdiModule.schemaPath(type, version, ident);
        Structure structure = this.loadedSchemas.get(path);
        if (structure == null) {
            try {
                YamlReader yamlrdr = new YamlReader();
                EdiSchema schema = BaseEdiModule.loadSchema(path, yamlrdr);
                structure = (Structure)schema.structures().apply((Object)ident);
                this.loadedSchemas.put(path, structure);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load schema " + ident + " from path " + path, e);
            }
        }
        return structure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadB2BProvider() throws Exception {
        if (this.b2bProvider == null) {
            BaseEdiModule baseEdiModule = this;
            synchronized (baseEdiModule) {
                block7: {
                    try {
                        this.b2bProvider = (B2BProvider)this.getRegistry().lookupObject(B2BProvider.class);
                    }
                    catch (Exception e) {
                        if (e instanceof ClassNotFoundException) break block7;
                        throw new Exception("An error occurred while trying to read from registered B2B Provider", e);
                    }
                }
                if (this.b2bProvider == null) {
                    throw new Exception("No B2B Provider found. Make sure Partner Manager Connector is set up.");
                }
                this.queryObjectFactory = this.b2bProvider.getFactoryResolver().getFactory(QueryObject.class);
                Factory factory = this.b2bProvider.getFactoryResolver().getFactory(Transmission.class);
                this.transmissionSupport = new TransmissionSupport(this, (Factory<Transmission>)factory);
            }
        }
    }

    public TransmissionSupport getTransmissionSupport() {
        return this.transmissionSupport;
    }
}

