/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.base;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;

public class CachedOutputStream
extends OutputStream {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final File tempFileDir;
    private static int defaultThreshold;
    private static String cipherTransformation;
    protected boolean outputLocked;
    protected OutputStream currentStream;
    private long threshold;
    private long totalLength;
    private boolean inmem;
    private boolean tempFileFailed;
    private File tempFile;
    private CipherPair ciphers;

    public CachedOutputStream() {
        this(defaultThreshold);
    }

    public CachedOutputStream(long threshold) {
        this.threshold = threshold;
        this.currentStream = new ByteArrayOutputStream(2048);
        this.inmem = true;
    }

    @Override
    public void flush() throws IOException {
        this.currentStream.flush();
    }

    public void lockOutputStream() throws IOException {
        if (this.outputLocked) {
            return;
        }
        this.currentStream.flush();
        this.outputLocked = true;
    }

    @Override
    public void close() throws IOException {
        this.currentStream.flush();
        this.outputLocked = true;
        this.currentStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int copyAndCloseInput(InputStream input, OutputStream output, int bufferSize) throws IOException {
        try {
            int n = CachedOutputStream.copy(input, output, bufferSize);
            return n;
        }
        finally {
            input.close();
        }
    }

    private static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int avail = input.available();
        if (avail > 262144) {
            avail = 262144;
        }
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            if (n == 0) {
                throw new IOException("0 bytes read in violation of InputStream.read(byte[])");
            }
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        return total;
    }

    public long size() {
        return this.totalLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCacheTo(OutputStream out) throws IOException {
        this.flush();
        if (this.inmem) {
            if (!(this.currentStream instanceof ByteArrayOutputStream)) throw new IOException("Unknown format of currentStream");
            ((ByteArrayOutputStream)this.currentStream).writeTo(out);
            return;
        } else {
            InputStream fin = this.createInputStream(this.tempFile);
            CachedOutputStream.copyAndCloseInput(fin, out, 4096);
            this.deleteTempFile();
        }
    }

    public void discard() {
        this.deleteTempFile();
    }

    private void enforceLimits() throws IOException {
        if (this.inmem && this.threshold > 0L && this.totalLength > this.threshold && this.currentStream instanceof ByteArrayOutputStream) {
            this.createFileOutputStream();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.outputLocked) {
            this.totalLength += (long)len;
            this.enforceLimits();
            this.currentStream.write(b, off, len);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!this.outputLocked) {
            this.totalLength += (long)b.length;
            this.enforceLimits();
            this.currentStream.write(b);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.outputLocked) {
            ++this.totalLength;
            this.enforceLimits();
            this.currentStream.write(b);
        }
    }

    private void createFileOutputStream() throws IOException {
        if (this.tempFileFailed) {
            return;
        }
        ByteArrayOutputStream bout = (ByteArrayOutputStream)this.currentStream;
        try {
            this.tempFile = tempFileDir == null ? File.createTempFile("cos", "tmp") : File.createTempFile("cos", "tmp", tempFileDir);
            this.currentStream = this.createOutputStream(this.tempFile);
            bout.writeTo(this.currentStream);
            this.inmem = false;
        }
        catch (Exception ex) {
            this.tempFileFailed = true;
            if (this.currentStream != bout) {
                this.currentStream.close();
            }
            this.deleteTempFile();
            this.inmem = true;
            this.currentStream = bout;
        }
    }

    private synchronized void deleteTempFile() {
        if (this.tempFile != null) {
            File file = this.tempFile;
            this.tempFile = null;
            file.delete();
        }
    }

    private OutputStream createOutputStream(File file) throws IOException {
        FilterOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        if (cipherTransformation != null) {
            try {
                if (this.ciphers == null) {
                    this.ciphers = new CipherPair(cipherTransformation);
                }
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e.getMessage(), e);
            }
            out = new CipherOutputStream(out, this.ciphers.getEncryptor()){
                boolean closed;

                @Override
                public void close() throws IOException {
                    if (!this.closed) {
                        super.close();
                        this.closed = true;
                    }
                }
            };
        }
        return out;
    }

    private InputStream createInputStream(File file) throws IOException {
        InputStream in = new FileInputStream(file);
        if (cipherTransformation != null) {
            in = new CipherInputStream(in, this.ciphers.getDecryptor()){
                boolean closed;

                @Override
                public void close() throws IOException {
                    if (!this.closed) {
                        super.close();
                        this.closed = true;
                    }
                }
            };
        }
        return in;
    }

    static {
        File f;
        defaultThreshold = -1;
        cipherTransformation = null;
        String s = System.getProperty("org.mule.modules.edi.base.CachedOutputStream.OutputDirectory");
        tempFileDir = s != null ? ((f = new File(s)).exists() && f.isDirectory() ? f : null) : null;
        String v = System.getProperty("org.mule.modules.edi.base.CachedOutputStream.Threshold");
        defaultThreshold = v == null ? -1 : Integer.parseInt(v);
        v = System.getProperty("org.mule.modules.edi.base.CachedOutputStream.CipherTransformation");
        cipherTransformation = v == null ? null : v;
    }

    private static class CipherPair {
        private String transformation;
        private Cipher enccipher;
        private Key key;
        private byte[] ivp;

        public CipherPair(String transformation) throws GeneralSecurityException {
            this.transformation = transformation;
            int d = transformation.indexOf(47);
            String a = d > 0 ? transformation.substring(0, d) : transformation;
            try {
                KeyGenerator keygen = KeyGenerator.getInstance(a);
                keygen.init(new SecureRandom());
                this.key = keygen.generateKey();
                this.enccipher = Cipher.getInstance(transformation);
                this.enccipher.init(1, this.key);
                this.ivp = this.enccipher.getIV();
            }
            catch (GeneralSecurityException e) {
                this.enccipher = null;
                throw e;
            }
        }

        public Cipher getEncryptor() {
            return this.enccipher;
        }

        public Cipher getDecryptor() {
            Cipher deccipher = null;
            try {
                deccipher = Cipher.getInstance(this.transformation);
                deccipher.init(2, this.key, this.ivp == null ? null : new IvParameterSpec(this.ivp));
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            return deccipher;
        }
    }
}

