/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.base;

import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.schema.SchemaJavaValues;
import com.mulesoft.flatfile.schema.model.Composite;
import com.mulesoft.flatfile.schema.model.DelimitedCompositeComponent;
import com.mulesoft.flatfile.schema.model.DelimitedElementComponent;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.Element;
import com.mulesoft.flatfile.schema.model.GroupComponent;
import com.mulesoft.flatfile.schema.model.LoopWrapperComponent;
import com.mulesoft.flatfile.schema.model.ReferenceComponent;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.SegmentComponent;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.model.StructureComponent;
import com.mulesoft.flatfile.schema.model.StructureSequence;
import com.mulesoft.flatfile.schema.model.Usage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.common.metadata.builder.DynamicObjectBuilder;
import org.mule.common.metadata.builder.DynamicObjectFieldBuilder;
import org.mule.common.metadata.datatype.DataType;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.convert.WrapAsJava$;

public abstract class EdiMetaDataBuilder {
    private static final Map<TypeFormatConstants.GenericType, DataType> typeConvert = new HashMap<TypeFormatConstants.GenericType, DataType>();
    protected final EdiForm schemaForm;

    public EdiMetaDataBuilder(EdiForm form) {
        this.schemaForm = form;
    }

    public void buildStructures(DynamicObjectBuilder<?> root, String structKey, boolean read, EdiSchema schema) {
        DynamicObjectFieldBuilder structuresMap = root.addDynamicObjectField(structKey);
        Iterator keys = schema.structures().keysIterator();
        while (!keys.isEmpty()) {
            Structure structure = (Structure)schema.structures().apply(keys.next());
            DynamicObjectBuilder tranMap = structuresMap.addList(structure.ident()).ofDynamicObject(structure.ident());
            this.buildStructure(structure, read, tranMap);
        }
    }

    protected abstract void buildStructure(Structure var1, boolean var2, DynamicObjectBuilder<?> var3);

    protected void buildStructureDetails(Structure structure, DynamicObjectBuilder<?> container) {
        container.addSimpleField(SchemaJavaValues.structureId(), DataType.STRING);
        container.addSimpleField(SchemaJavaValues.structureName(), DataType.STRING);
        List comps = Collections.EMPTY_LIST;
        if (structure.heading().isDefined()) {
            comps = WrapAsJava$.MODULE$.seqAsJavaList((Seq)((StructureSequence)structure.heading().get()).items());
        }
        this.buildComps(comps, SchemaJavaValues.structureHeading(), false, container);
        comps = Collections.EMPTY_LIST;
        if (structure.detail().isDefined()) {
            comps = WrapAsJava$.MODULE$.seqAsJavaList((Seq)((StructureSequence)structure.detail().get()).items());
        }
        this.buildComps(comps, SchemaJavaValues.structureDetail(), false, container);
        comps = Collections.EMPTY_LIST;
        if (structure.summary().isDefined()) {
            comps = WrapAsJava$.MODULE$.seqAsJavaList((Seq)((StructureSequence)structure.summary().get()).items());
        }
        this.buildComps(comps, SchemaJavaValues.structureSummary(), false, container);
    }

    protected void buildComps(List<StructureComponent> comps, String key, boolean repeat, DynamicObjectBuilder<?> parent) {
        Object wrapper = repeat ? parent.addList(key).ofDynamicObject(key) : parent.addDynamicObjectField(key);
        for (StructureComponent comp : comps) {
            Usage usage = comp.usage();
            if (!usage.userValue()) continue;
            if (comp instanceof ReferenceComponent) {
                if (this.schemaForm.isEnvelopeSegment(((ReferenceComponent)comp).segment().tag())) continue;
                this.buildSegment((ReferenceComponent)comp, (DynamicObjectBuilder<?>)wrapper);
                continue;
            }
            if (comp instanceof LoopWrapperComponent) {
                LoopWrapperComponent wrapComp = (LoopWrapperComponent)comp;
                this.buildComps(WrapAsJava$.MODULE$.seqAsJavaList((Seq)wrapComp.wrapped().seq().items()), wrapComp.wrapped().key(), wrapComp.count() != 1, (DynamicObjectBuilder<?>)wrapper);
                continue;
            }
            if (comp instanceof GroupComponent) {
                GroupComponent groupComp = (GroupComponent)comp;
                this.buildComps(WrapAsJava$.MODULE$.seqAsJavaList((Seq)groupComp.seq().items()), groupComp.key(), groupComp.count() != 1, (DynamicObjectBuilder<?>)wrapper);
                continue;
            }
            throw new IllegalStateException("Structure component of unknown type");
        }
    }

    protected void buildSegment(ReferenceComponent ref, DynamicObjectBuilder<?> parent) {
        Segment segment = ref.segment();
        Object container = ref.count() != 1 ? parent.addList(ref.key()).ofDynamicObject(segment.name()) : parent.addDynamicObjectField(ref.key());
        this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList((Seq)segment.components()), (DynamicObjectBuilder<?>)container);
    }

    protected void buildSegmentComps(List<SegmentComponent> comps, DynamicObjectBuilder<?> parent) {
        for (SegmentComponent comp : comps) {
            if (!comp.usage().userValue()) continue;
            if (comp instanceof DelimitedElementComponent) {
                Element element = ((DelimitedElementComponent)comp).element();
                DataType dataType = typeConvert.get(element.typeFormat().genericType());
                if (dataType == DataType.LIST) {
                    parent.addList(comp.key()).ofDynamicObject("varies");
                    continue;
                }
                parent.addSimpleField(comp.key(), dataType).setLabel(comp.key() + " - " + comp.name());
                continue;
            }
            if (comp instanceof DelimitedCompositeComponent) {
                Composite composite = ((DelimitedCompositeComponent)comp).composite();
                if (comp.count() == 1) {
                    this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList((Seq)composite.components()), parent);
                    continue;
                }
                DynamicObjectBuilder wrapper = parent.addList(comp.key()).ofDynamicObject(comp.name() + " : " + composite.ident());
                this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList((Seq)composite.components()), wrapper);
                continue;
            }
            throw new IllegalStateException("Segment component of unknown type");
        }
    }

    static {
        typeConvert.put(TypeFormatConstants.GenericType.STRING, DataType.STRING);
        typeConvert.put(TypeFormatConstants.GenericType.INTEGER, DataType.INTEGER);
        typeConvert.put(TypeFormatConstants.GenericType.REAL, DataType.DECIMAL);
        typeConvert.put(TypeFormatConstants.GenericType.DATE, DataType.DATE);
        typeConvert.put(TypeFormatConstants.GenericType.DATETIME, DataType.DATE_TIME);
        typeConvert.put(TypeFormatConstants.GenericType.BOOLEAN, DataType.BOOLEAN);
        typeConvert.put(TypeFormatConstants.GenericType.LIST, DataType.LIST);
    }
}

