/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.EdiConstants;
import com.anypoint.df.edi.lexical.LexerBase;
import com.anypoint.df.edi.lexical.LexicalException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

public class HL7Lexer
extends LexerBase {
    public HL7Lexer(InputStream is, int subst2) {
        super(is);
        this.substitutionChar = subst2;
        this.segmentTerminator = (char)13;
    }

    @Override
    public String init(Map<String, Object> props) throws LexicalException {
        try {
            byte[] byts = this.readBytes(3);
            String tag = new String(byts, EdiConstants.ASCII_CHARSET);
            if (!"MSH".equals(tag)) {
                throw new RuntimeException("Message does not start with 'MSH'");
            }
            byts = this.readBytes(5);
            this.dataSeparator = (char)byts[0];
            this.componentSeparator = (char)byts[1];
            this.repetitionSeparator = (char)byts[2];
            this.releaseIndicator = (char)byts[3];
            this.subCompSeparator = (char)byts[4];
            if (this.stream.read() != this.dataSeparator) {
                throw new RuntimeException("Field separator not present following MSH-2");
            }
            this.reader = new ByteReader();
            this.advance(EdiConstants.ItemType.DATA_ELEMENT);
            this.elementNumber = 2;
            return new String(byts, EdiConstants.ASCII_CHARSET);
        }
        catch (IOException e) {
            throw new LexicalException("Message aborted due to error reading header", e);
        }
    }

    public void term(Map<String, Object> props) throws IOException {
    }

    private class ByteReader
    extends Reader {
        private ByteReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int chr;
            int actual = -1;
            while (actual < len - 1 && (chr = HL7Lexer.this.stream.read()) >= 0) {
                cbuf[off + ++actual] = (char)chr;
            }
            return actual;
        }

        @Override
        public void close() throws IOException {
            HL7Lexer.this.stream.close();
        }
    }

    public static enum InterchangeEndStatus {
        VALID,
        GROUP_COUNT_ERROR,
        CONTROL_NUMBER_ERROR;

    }
}

