/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi;

import com.anypoint.df.edi.lexical.EdiConstants;
import com.anypoint.df.edi.schema.EdiSchema;
import com.anypoint.df.edi.schema.EdiSchema$UnusedUsage$;
import com.anypoint.df.edi.schema.SchemaJavaValues;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.common.metadata.builder.DynamicObjectBuilder;
import org.mule.common.metadata.builder.DynamicObjectFieldBuilder;
import org.mule.common.metadata.datatype.DataType;
import scala.collection.Iterator;
import scala.collection.convert.WrapAsJava$;

public abstract class EdiMetaDataBuilder {
    private static final Map<EdiConstants.DataType, DataType> typeConvert = new HashMap<EdiConstants.DataType, DataType>();
    protected final EdiSchema schema;

    private static void addTypes(EdiConstants.DataType[] types2, DataType asType) {
        for (EdiConstants.DataType type : types2) {
            typeConvert.put(type, asType);
        }
    }

    public EdiMetaDataBuilder(EdiSchema schema) {
        this.schema = schema;
    }

    public void buildStructures(DynamicObjectBuilder<?> root2, String structKey, boolean read) {
        DynamicObjectFieldBuilder structuresMap = root2.addDynamicObjectField(structKey);
        Iterator keys = this.schema.structures().keysIterator();
        while (!keys.isEmpty()) {
            EdiSchema.Structure structure = (EdiSchema.Structure)this.schema.structures().apply((String)keys.next());
            DynamicObjectBuilder tranMap = structuresMap.addList(structure.ident()).ofDynamicObject(structure.ident());
            this.buildStructure(structure, read, tranMap);
        }
    }

    protected abstract void buildStructure(EdiSchema.Structure var1, boolean var2, DynamicObjectBuilder<?> var3);

    protected void buildStructureDetails(EdiSchema.Structure structure, DynamicObjectBuilder<?> container) {
        container.addSimpleField(SchemaJavaValues.structureId(), DataType.STRING);
        container.addSimpleField(SchemaJavaValues.structureName(), DataType.STRING);
        List<EdiSchema.StructureComponent> comps = Collections.EMPTY_LIST;
        if (structure.heading().isDefined()) {
            comps = WrapAsJava$.MODULE$.seqAsJavaList(structure.heading().get().items());
        }
        this.buildComps(comps, SchemaJavaValues.structureHeading(), false, container);
        comps = Collections.EMPTY_LIST;
        if (structure.detail().isDefined()) {
            comps = WrapAsJava$.MODULE$.seqAsJavaList(structure.detail().get().items());
        }
        this.buildComps(comps, SchemaJavaValues.structureDetail(), false, container);
        comps = Collections.EMPTY_LIST;
        if (structure.summary().isDefined()) {
            comps = WrapAsJava$.MODULE$.seqAsJavaList(structure.summary().get().items());
        }
        this.buildComps(comps, SchemaJavaValues.structureSummary(), false, container);
    }

    protected void buildComps(List<EdiSchema.StructureComponent> comps, String key, boolean repeat, DynamicObjectBuilder<?> parent) {
        Object wrapper = repeat ? parent.addList(key).ofDynamicObject(key) : parent.addDynamicObjectField(key);
        for (EdiSchema.StructureComponent comp : comps) {
            if (comp.usage() == EdiSchema$UnusedUsage$.MODULE$) continue;
            if (comp instanceof EdiSchema.ReferenceComponent) {
                if (this.schema.ediVersion().ediForm().isEnvelopeSegment(((EdiSchema.ReferenceComponent)comp).segment().ident())) continue;
                this.buildSegment((EdiSchema.ReferenceComponent)comp, (DynamicObjectBuilder<?>)wrapper);
                continue;
            }
            if (comp instanceof EdiSchema.LoopWrapperComponent) {
                EdiSchema.LoopWrapperComponent wrapComp = (EdiSchema.LoopWrapperComponent)comp;
                this.buildComps(WrapAsJava$.MODULE$.seqAsJavaList(wrapComp.wrapped().seq().items()), wrapComp.wrapped().key(), wrapComp.count() != 1, (DynamicObjectBuilder<?>)wrapper);
                continue;
            }
            if (comp instanceof EdiSchema.GroupComponent) {
                EdiSchema.GroupComponent groupComp = (EdiSchema.GroupComponent)comp;
                this.buildComps(WrapAsJava$.MODULE$.seqAsJavaList(groupComp.seq().items()), groupComp.key(), groupComp.count() != 1, (DynamicObjectBuilder<?>)wrapper);
                continue;
            }
            throw new IllegalStateException("Structure component of unknown type");
        }
    }

    protected void buildSegment(EdiSchema.ReferenceComponent ref2, DynamicObjectBuilder<?> parent) {
        EdiSchema.Segment segment = ref2.segment();
        Object container = ref2.count() != 1 ? parent.addList(ref2.key()).ofDynamicObject(segment.name()) : parent.addDynamicObjectField(ref2.key());
        this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(segment.components()), (DynamicObjectBuilder<?>)container);
    }

    protected void buildSegmentComps(List<EdiSchema.SegmentComponent> comps, DynamicObjectBuilder<?> parent) {
        for (EdiSchema.SegmentComponent comp : comps) {
            if (comp instanceof EdiSchema.ElementComponent) {
                EdiSchema.Element element = ((EdiSchema.ElementComponent)comp).element();
                parent.addSimpleField(comp.key(), typeConvert.get((Object)element.dataType())).setLabel(comp.key() + " - " + comp.name());
                continue;
            }
            if (comp instanceof EdiSchema.CompositeComponent) {
                EdiSchema.Composite composite = ((EdiSchema.CompositeComponent)comp).composite();
                if (comp.count() == 1) {
                    this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(composite.components()), parent);
                    continue;
                }
                DynamicObjectFieldBuilder wrapper = parent.addDynamicObjectField(composite.name());
                this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(composite.components()), (DynamicObjectBuilder<?>)wrapper);
                continue;
            }
            throw new IllegalStateException("Segment component of unknown type");
        }
    }

    static {
        EdiMetaDataBuilder.addTypes(EdiConstants.REAL_TYPES, DataType.DECIMAL);
        EdiMetaDataBuilder.addTypes(EdiConstants.INTEGER_TYPES, DataType.INTEGER);
        EdiMetaDataBuilder.addTypes(EdiConstants.DATE_TYPES, DataType.DATE);
        EdiMetaDataBuilder.addTypes(EdiConstants.STRING_TYPES, DataType.STRING);
        typeConvert.put(EdiConstants.DataType.VARIES, DataType.STRING);
    }
}

