/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.x12;

import com.anypoint.df.edi.lexical.LexicalException;
import com.anypoint.df.edi.lexical.X12Constants;
import com.anypoint.df.edi.schema.X12Acknowledgment;
import com.anypoint.df.edi.schema.X12InterchangeException;
import com.anypoint.df.edi.schema.X12ParserConfig;
import com.anypoint.df.edi.schema.X12SchemaDefs;
import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.ConfigType;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.Factory;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import org.mule.modules.edi.x12.DirectEnvelopeHandler;
import org.mule.modules.edi.x12.X12EdiModule;

class B2BProviderEnvelopeHandler
extends DirectEnvelopeHandler {
    private B2BProvider b2bProvider;
    private Factory<QueryObject> queryObjectFactory;

    public B2BProviderEnvelopeHandler(B2BProvider b2bProvider, X12EdiModule x12EdiModule) throws Exception {
        super(x12EdiModule);
        this.b2bProvider = b2bProvider;
        this.queryObjectFactory = this.b2bProvider.getFactoryResolver().getFactory(QueryObject.class);
    }

    @Override
    public Object handleIsa(Map<String, Object> map2) throws LexicalException {
        Config ediB2BProviderConfig;
        String interchangeIdQualifierPartner;
        String groupIdSelf = this.x12EdiModule.getGroupIdSelf();
        String interchangeIdSelf = this.x12EdiModule.getInterchangeIdSelf() != null ? this.x12EdiModule.getInterchangeIdSelf() : B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interReceiverInfoKey(), map2);
        String interchangeIdQualifierSelf = this.x12EdiModule.getInterchangeIdQualifierSelf() != null ? this.x12EdiModule.getInterchangeIdQualifierSelf() : B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interReceiverQualKey(), map2);
        String groupIdPartner = this.x12EdiModule.getGroupIdPartner();
        String interchangeIdPartner = this.x12EdiModule.getInterchangeIdPartner() != null ? this.x12EdiModule.getInterchangeIdPartner() : B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interSenderInfoKey(), map2);
        String string2 = interchangeIdQualifierPartner = this.x12EdiModule.getInterchangeIdQualifierPartner() != null ? this.x12EdiModule.getInterchangeIdQualifierPartner() : B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interSenderQualKey(), map2);
        if (!(B2BProviderEnvelopeHandler.verifySetting(interchangeIdQualifierPartner, X12SchemaDefs.interSenderQualKey(), map2) && B2BProviderEnvelopeHandler.verifySetting(interchangeIdPartner, X12SchemaDefs.interSenderInfoKey(), map2) && B2BProviderEnvelopeHandler.verifySetting(interchangeIdQualifierSelf, X12SchemaDefs.interReceiverQualKey(), map2) && B2BProviderEnvelopeHandler.verifySetting(interchangeIdSelf, X12SchemaDefs.interReceiverInfoKey(), map2))) {
            throw new LexicalException("Interchange sender/receiver information does not match configuration");
        }
        QueryObject configQueryObject = this.queryObjectFactory.create();
        configQueryObject.put("applicationReceiverCode", groupIdSelf);
        configQueryObject.put("interchangeReceiverId", interchangeIdSelf);
        configQueryObject.put("interchangeReceiverQualifierId", interchangeIdQualifierSelf);
        configQueryObject.put("applicationSenderCode", groupIdPartner);
        configQueryObject.put("interchangeSenderId", interchangeIdPartner);
        configQueryObject.put("interchangeSenderQualifierId", interchangeIdQualifierPartner);
        configQueryObject.put("interchangeControlVersionNumber", B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interControlVersionKey(), map2));
        try {
            ediB2BProviderConfig = this.b2bProvider.getConfig(ConfigType.X12, Direction.INBOUND, configQueryObject);
        }
        catch (B2BProviderException e) {
            throw new X12InterchangeException(null, e.getMessage(), (Throwable)((Object)e));
        }
        if (ediB2BProviderConfig != null) {
            if (Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("requireUniqueInterchangeNumbers")).toString()).booleanValue()) {
                int controlNum = B2BProviderEnvelopeHandler.requiredInt(X12SchemaDefs.interControlNumberHeaderKey(), map2);
                QueryObject transmissionQueryObject = this.queryObjectFactory.create();
                transmissionQueryObject.put("applicationSenderCode", groupIdPartner);
                transmissionQueryObject.put("interchangeSenderId", interchangeIdPartner);
                transmissionQueryObject.put("interchangeSenderQualifierId", interchangeIdQualifierPartner);
                transmissionQueryObject.put("applicationReceiverCode", groupIdSelf);
                transmissionQueryObject.put("interchangeReceiverId", interchangeIdSelf);
                transmissionQueryObject.put("interchangeReceiverQualifierId", interchangeIdQualifierSelf);
                transmissionQueryObject.put("interchangeControlNumber", String.valueOf(controlNum));
                try {
                    if (this.b2bProvider.readTransmission(Direction.INBOUND, TransmissionType.X12, transmissionQueryObject) != null) {
                        String text2 = "Duplicate interchange control number " + controlNum;
                        logger.error(text2);
                        throw new X12InterchangeException(X12Acknowledgment.InterchangeDuplicateNumber(), text2, null);
                    }
                }
                catch (B2BProviderException e) {
                    logger.error(e.getMessage(), (Throwable)((Object)e));
                }
            }
            this.requireUniqueGroupNumbers = Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("requireUniqueGroupNumbers")).toString());
            this.requireUniqueTransactionNumbers = Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("requireUniqueTransactionNumbers")).toString());
            if (!this.requireUniqueGroupNumbers) {
                this.groupCache = new HashSet();
            }
            return new X12ParserConfig(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("valueLengthErrorFail")).toString()), Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("invalidCharacterInValueFail")).toString()), Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("wrongValuesRepeatsFail")).toString()), Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("unknownsSegmentFail")).toString()), Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("segmentOutOfOrderFail")).toString()), Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("unusedSegmentPresentFail")).toString()), Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("wrongSegmentsRepeatsFail")).toString()), this.x12EdiModule.getReportSegmentErrors(), this.x12EdiModule.isGenerate999Acks(), -1, Enum.valueOf(X12Constants.CharacterRestriction.class, ((Serializable)ediB2BProviderConfig.get("stringCharacterSet")).toString()));
        }
        throw new X12InterchangeException(null, "Queried registered B2B Provider for X12 read config but none was found. Check your configuration. Lookup key used was: " + configQueryObject.toString(), null);
    }
}

