/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.x12;

import com.anypoint.df.edi.schema.EdiSchema;
import com.anypoint.df.edi.schema.SchemaJavaValues;
import com.anypoint.df.edi.schema.X12Acknowledgment;
import com.anypoint.df.edi.schema.X12Error;
import com.anypoint.df.edi.schema.X12SchemaDefs;
import org.mule.common.metadata.builder.DynamicObjectBuilder;
import org.mule.common.metadata.builder.DynamicObjectFieldBuilder;
import org.mule.common.metadata.datatype.DataType;
import org.mule.modules.edi.EdiMetaDataBuilder;
import scala.collection.convert.WrapAsJava$;

public class X12MetaDataBuilder
extends EdiMetaDataBuilder {
    public X12MetaDataBuilder(EdiSchema schema) {
        super(schema);
    }

    private void addErrors(DynamicObjectBuilder<?> container) {
        container.addList(SchemaJavaValues.errorListKey()).ofPojo(X12Error.class);
    }

    private void addInterchangeHeader(DynamicObjectBuilder<?> container, boolean errors) {
        DynamicObjectFieldBuilder inter = container.addDynamicObjectField(SchemaJavaValues.interchangeKey());
        this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(X12SchemaDefs.ISASegment().components()), (DynamicObjectBuilder<?>)inter);
        if (errors) {
            this.addErrors((DynamicObjectBuilder<?>)inter);
        }
    }

    private void addGroupHeader(DynamicObjectBuilder<?> container, boolean errors) {
        DynamicObjectFieldBuilder group2 = container.addDynamicObjectField(SchemaJavaValues.groupKey());
        this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(X12SchemaDefs.GSSegment().components()), (DynamicObjectBuilder<?>)group2);
        if (errors) {
            this.addErrors((DynamicObjectBuilder<?>)group2);
        }
    }

    public void build(DynamicObjectBuilder<?> root2, boolean read, boolean use999) {
        if (read) {
            root2.addSimpleField(SchemaJavaValues.delimiterCharacters(), DataType.STRING);
            EdiSchema.Structure ackTrans = use999 ? X12Acknowledgment.trans999() : X12Acknowledgment.trans997();
            DynamicObjectBuilder ackMap = root2.addList(SchemaJavaValues.functionalAcksGenerated()).ofDynamicObject(ackTrans.ident());
            this.buildStructure(ackTrans, false, ackMap);
            DynamicObjectBuilder ta1Map1 = root2.addList(SchemaJavaValues.interchangeAcksGenerated()).ofDynamicObject(X12Acknowledgment.segTA1().ident());
            this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(X12Acknowledgment.segTA1().components()), ta1Map1);
            DynamicObjectBuilder ta1Map2 = root2.addList(SchemaJavaValues.interchangeAcksReceived()).ofDynamicObject(X12Acknowledgment.segTA1().ident());
            this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(X12Acknowledgment.segTA1().components()), ta1Map2);
            this.addErrors(root2);
        } else {
            DynamicObjectBuilder ta1Map = root2.addList(SchemaJavaValues.interchangeAcksToSend()).ofDynamicObject(X12Acknowledgment.segTA1().ident());
            this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(X12Acknowledgment.segTA1().components()), ta1Map);
            this.addInterchangeHeader(root2, false);
            this.addGroupHeader(root2, false);
        }
        DynamicObjectFieldBuilder verMap = root2.addDynamicObjectField(X12SchemaDefs.transactionsMap());
        this.buildStructures((DynamicObjectBuilder<?>)verMap, "v" + this.schema.ediVersion().version(), read);
    }

    @Override
    protected void buildStructure(EdiSchema.Structure structure, boolean addErrors, DynamicObjectBuilder<?> container) {
        this.addInterchangeHeader(container, addErrors);
        this.addGroupHeader(container, addErrors);
        if (addErrors) {
            this.addErrors(container);
        }
        DynamicObjectFieldBuilder set = container.addDynamicObjectField(X12SchemaDefs.setKey());
        this.buildSegmentComps(WrapAsJava$.MODULE$.seqAsJavaList(X12SchemaDefs.STSegment().components()), (DynamicObjectBuilder<?>)set);
        this.buildStructureDetails(structure, container);
    }
}

