/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.EdiConstants;
import com.anypoint.df.edi.lexical.ErrorHandler;
import com.anypoint.df.edi.lexical.LexerBase;
import com.anypoint.df.edi.lexical.LexicalDataException;
import com.anypoint.df.edi.lexical.LexicalException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public abstract class DelimiterLexer
extends LexerBase {
    protected final Logger logger = Logger.getLogger(this.getClass());
    boolean[] allowedChars;
    char dataSeparator;
    int repetitionSeparator = -1;
    char componentSeparator;
    int subCompSeparator = -1;
    int releaseIndicator = -1;
    char segmentTerminator;
    int substitutionChar = -1;
    StringBuilder peekToken = new StringBuilder();
    private int repetitionNumber;
    private int componentNumber;
    private int subCompNumber;
    private EdiConstants.ItemType nextType;
    private EdiConstants.ItemType peekType;

    public DelimiterLexer(InputStream is) {
        super(is);
    }

    public char getDataSeparator() {
        return this.dataSeparator;
    }

    public int getRepetitionSeparator() {
        return this.repetitionSeparator;
    }

    public char getComponentSeparator() {
        return this.componentSeparator;
    }

    public int getReleaseIndicator() {
        return this.releaseIndicator;
    }

    public char getSegmentTerminator() {
        return this.segmentTerminator;
    }

    public int getRepetitionNumber() {
        return this.repetitionNumber;
    }

    public int getComponentNumber() {
        return this.componentNumber;
    }

    public int getSubComponentNumber() {
        return this.subCompNumber;
    }

    public boolean hasData() {
        return this.tokenBuilder.length() > 0;
    }

    public EdiConstants.ItemType nextType() {
        return this.nextType;
    }

    @Override
    void handleError(EdiConstants.DataType typ2, ErrorHandler.ErrorCondition err2, String explain2) throws LexicalException {
        boolean abort = false;
        String position2 = "element " + Integer.toString(this.elementNumber + 1);
        if (this.repetitionNumber > 0) {
            position2 = "repetition " + Integer.toString(this.repetitionNumber + 1) + " of " + position2;
        }
        switch (this.currentType) {
            case SUB_COMPONENT: 
            case COMPONENT: {
                position2 = "component " + Integer.toString(this.componentNumber + 1) + " of " + position2;
                if (this.currentType != EdiConstants.ItemType.SUB_COMPONENT) break;
                position2 = "subcomponent " + Integer.toString(this.subCompNumber + 1) + " of " + position2;
            }
        }
        String text2 = err2.text() + " for data type " + typ2.code() + " at " + position2 + ": '" + this.tokenBuilder + "'";
        if (explain2 != null) {
            text2 = text2 + " (" + explain2 + ")";
        }
        try {
            if (this.errorHandler == null) {
                throw new LexicalDataException(typ2, err2, text2);
            }
            this.errorHandler.error(this, typ2, err2, explain2);
        }
        catch (LexicalException e) {
            abort = true;
            throw e;
        }
        finally {
            if (abort) {
                this.logger.error("Unrecoverable lexer error " + text2);
            } else {
                this.logger.info("Recoverable lexer error " + text2);
            }
        }
    }

    abstract void handleEscape() throws IOException;

    public void peek() throws IOException {
        if (this.peekType == null) {
            int value2 = this.reader.read();
            if (this.nextType == EdiConstants.ItemType.SEGMENT) {
                while (value2 == 10 || value2 == 13 || value2 == 32) {
                    value2 = this.reader.read();
                }
            }
            this.peekToken.setLength(0);
            if (value2 < 0) {
                this.peekType = EdiConstants.ItemType.END;
            } else {
                char chr = (char)value2;
                while (true) {
                    if (chr == this.subCompSeparator) {
                        this.peekType = EdiConstants.ItemType.SUB_COMPONENT;
                        break;
                    }
                    if (chr == this.componentSeparator) {
                        this.peekType = EdiConstants.ItemType.COMPONENT;
                        break;
                    }
                    if (chr == this.dataSeparator) {
                        this.peekType = EdiConstants.ItemType.DATA_ELEMENT;
                        break;
                    }
                    if (chr == this.segmentTerminator) {
                        this.peekType = EdiConstants.ItemType.SEGMENT;
                        break;
                    }
                    if (chr == this.repetitionSeparator) {
                        this.peekType = EdiConstants.ItemType.REPETITION;
                        break;
                    }
                    if (chr == this.releaseIndicator) {
                        this.handleEscape();
                    } else {
                        if (value2 == -1) {
                            this.peekType = EdiConstants.ItemType.END;
                            break;
                        }
                        this.peekToken.append(chr);
                    }
                    value2 = this.reader.read();
                    chr = (char)value2;
                }
            }
        }
    }

    public void advance() throws IOException {
        this.peek();
        this.currentType = this.nextType;
        switch (this.currentType) {
            case DATA_ELEMENT: {
                ++this.elementNumber;
                this.componentNumber = 0;
                this.repetitionNumber = 0;
                break;
            }
            case SEGMENT: {
                ++this.segmentNumber;
                this.segmentTag = this.peekToken.toString();
            }
            case END: {
                this.elementNumber = 0;
                this.componentNumber = 0;
                this.repetitionNumber = 0;
                break;
            }
            case SUB_COMPONENT: {
                ++this.subCompNumber;
                break;
            }
            case COMPONENT: {
                ++this.componentNumber;
                break;
            }
            case REPETITION: {
                ++this.repetitionNumber;
                this.componentNumber = 0;
            }
        }
        StringBuilder hold = this.tokenBuilder;
        this.tokenBuilder = this.peekToken;
        hold.setLength(0);
        this.peekToken = hold;
        this.nextType = this.peekType;
        this.peekType = null;
    }

    public String peekToken() throws IOException {
        this.peek();
        return this.peekType == EdiConstants.ItemType.END ? null : this.peekToken.toString();
    }

    void advance(EdiConstants.ItemType type) throws IOException {
        this.nextType = type;
        this.advance();
    }

    @Override
    public void discardTo(EdiConstants.ItemType typ2) throws IOException {
        this.advance();
        while (this.currentType != typ2 && this.currentType != EdiConstants.ItemType.END) {
            this.advance();
        }
    }

    public String parseAny(int minl, int maxl) throws IOException {
        this.checkLength(EdiConstants.DataType.ALPHA, minl, maxl);
        return this.tokenBuilder.toString();
    }

    public String parseAlphaNumeric(int minl, int maxl) throws IOException {
        int length = this.tokenBuilder.length();
        this.checkLength(EdiConstants.DataType.ALPHA, length, minl, maxl);
        int lastns = -1;
        for (int i = 0; i < length; ++i) {
            char chr = this.tokenBuilder.charAt(i);
            if (!(this.allowedChars == null || chr <= this.allowedChars.length && this.allowedChars[chr])) {
                this.handleError(EdiConstants.DataType.ALPHANUMERIC, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
                if (this.substitutionChar >= 0) {
                    this.tokenBuilder.setCharAt(i, (char)this.substitutionChar);
                }
            }
            if (chr == ' ') continue;
            lastns = i;
        }
        return this.tokenBuilder.substring(0, lastns + 1);
    }

    public String parseId(int minl, int maxl) throws IOException {
        int length = this.tokenBuilder.length();
        this.checkLength(EdiConstants.DataType.ID, length, minl, maxl);
        int lastns = -1;
        boolean space = false;
        for (int i = 0; i < length; ++i) {
            char chr = this.tokenBuilder.charAt(i);
            if (Character.isAlphabetic(chr) || chr >= '0' && chr <= '9') {
                if (space) {
                    this.handleError(EdiConstants.DataType.ID, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "embedded space not allowed");
                }
                lastns = i;
                continue;
            }
            if (chr == ' ') {
                space = true;
                continue;
            }
            this.handleError(EdiConstants.DataType.ID, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed");
        }
        return this.tokenBuilder.substring(0, lastns + 1);
    }
}

