/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.EdiConstants;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public final class EdifactConstants
extends EdiConstants {
    public static final String SYNTAX_IDENTIFIER = "UNB0101";
    public static final String SYNTAX_VERSION_NUMBER = "UNB0102";
    public static final String SERVICE_CODE_LIST = "UNB0103";
    public static final String CHARACTER_ENCODING = "UNB0104";
    public static final String FORCE_UNA = "forceUNA";
    public static final String INTER_CONTROL_COUNT = "UNZ01";
    public static final String INTER_CONTROL_REF = "UNZ02";
    public static final boolean[] levelACharacterSet = new boolean[128];
    public static final boolean[] levelBCharacterSet;
    public static final Charset UTF8;
    public static final SyntaxIdentifier LEVELA;
    public static final SyntaxIdentifier LEVELB;
    public static final SyntaxIdentifier LEVELC;
    public static final SyntaxIdentifier LEVELY;
    public static final Map<String, SyntaxIdentifier> EDIFACT_CHARSETS;
    private static final String basicDelimiters = "+: '?";
    private static final String alternateDelimiters = "\u001d\u001f \u001c ";
    private static final String version4Delimiters = "+:*'?";
    public static final Map<String, SyntaxVersion> EDIFACT_VERSIONS;

    private EdifactConstants() {
    }

    public static void addSyntax(String code2, String chname) {
        try {
            Charset chset = Charset.forName(chname);
            SyntaxIdentifier synid = new SyntaxIdentifier(code2, chset, null);
            EDIFACT_CHARSETS.put(code2, synid);
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static int charNonBlank(char chr) {
        return chr == ' ' ? -1 : (int)chr;
    }

    static {
        EdifactConstants.fillChars('A', 'Z', levelACharacterSet);
        EdifactConstants.fillChars('0', '9', levelACharacterSet);
        EdifactConstants.setChars(" .,-()/=,+:?!\"%&*;<>".toCharArray(), levelACharacterSet);
        levelBCharacterSet = new boolean[128];
        System.arraycopy(levelACharacterSet, 0, levelBCharacterSet, 0, levelACharacterSet.length);
        EdifactConstants.fillChars('a', 'z', levelBCharacterSet);
        EdifactConstants.setChars(" .,-()/'+:=?!\"%&*;<>\f\r\u000f".toCharArray(), levelBCharacterSet);
        UTF8 = Charset.forName("UTF-8");
        LEVELA = new SyntaxIdentifier("UNOA", ASCII_CHARSET, levelACharacterSet);
        LEVELB = new SyntaxIdentifier("UNOB", ASCII_CHARSET, levelBCharacterSet);
        LEVELC = new SyntaxIdentifier("UNOC", Charset.forName("ISO8859_1"), null);
        LEVELY = new SyntaxIdentifier("UNOY", ASCII_CHARSET, null);
        EDIFACT_CHARSETS = new HashMap<String, SyntaxIdentifier>();
        EDIFACT_CHARSETS.put(LEVELA.syntaxCode, LEVELA);
        EDIFACT_CHARSETS.put(LEVELB.syntaxCode, LEVELB);
        EDIFACT_CHARSETS.put(LEVELC.syntaxCode, LEVELC);
        EDIFACT_CHARSETS.put(LEVELY.syntaxCode, LEVELY);
        EdifactConstants.addSyntax("UNOD", "ISO8859_2");
        EdifactConstants.addSyntax("UNOE", "ISO8859_5");
        EdifactConstants.addSyntax("UNOF", "ISO8859_7");
        EdifactConstants.addSyntax("UNOG", "ISO8859_3");
        EdifactConstants.addSyntax("UNOH", "ISO8859_4");
        EdifactConstants.addSyntax("UNOI", "ISO8859_6");
        EdifactConstants.addSyntax("UNOJ", "ISO8859_8");
        EdifactConstants.addSyntax("UNOK", "ISO8859_9");
        EdifactConstants.addSyntax("UNOX", "ISO2375");
        EDIFACT_VERSIONS = new HashMap<String, SyntaxVersion>();
        for (SyntaxVersion version : SyntaxVersion.values()) {
            EDIFACT_VERSIONS.put(version.code(), version);
        }
        EDIFACT_VERSIONS.put("1", SyntaxVersion.VERSION2);
    }

    public static enum SyntaxVersion {
        VERSION2("2"),
        VERSION3("3"),
        VERSION4("4");

        private final String codeValue;

        private SyntaxVersion(String code2) {
            this.codeValue = code2;
        }

        public String code() {
            return this.codeValue;
        }

        public String defaultDelimiters(SyntaxIdentifier sid) {
            if (this == VERSION4) {
                return EdifactConstants.version4Delimiters;
            }
            if (sid == LEVELA) {
                return EdifactConstants.basicDelimiters;
            }
            return EdifactConstants.alternateDelimiters;
        }
    }

    public static class SyntaxIdentifier {
        private final String syntaxCode;
        private final Charset defaultCharset;
        private final boolean[] characterFlags;

        SyntaxIdentifier(String code2, Charset chset, boolean[] flags) {
            this.syntaxCode = code2;
            this.defaultCharset = chset;
            this.characterFlags = flags;
        }

        public String code() {
            return this.syntaxCode;
        }

        public Charset defaultCharSet() {
            return this.defaultCharset;
        }

        public boolean[] flags() {
            return this.characterFlags;
        }
    }
}

