/*
 * Decompiled with CFR 0.152.
 */
package com.anypoint.df.edi.lexical;

import com.anypoint.df.edi.lexical.WriteException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;

public abstract class WriterBase {
    protected static final String SPACES = "                                        ";
    protected static final String ZEROES = "00000000000000000000";
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MILLIS_PER_HOUR = 3600000;
    protected final OutputStream stream;
    protected final Writer writer;
    protected final char decimalMark;
    protected int segmentCount;

    protected WriterBase(OutputStream os, Charset encoding, char mark2) {
        this.stream = os;
        this.writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), encoding);
        this.decimalMark = mark2;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public abstract void init(Map<String, Object> var1) throws IOException;

    public abstract void term(Map<String, Object> var1) throws IOException;

    public abstract void writeToken(String var1) throws IOException;

    public abstract void writeSegmentTerminator() throws IOException;

    public abstract void writeSpacePadded(String var1, int var2, int var3) throws IOException;

    public abstract void writeZeroPadded(String var1, int var2, int var3, int var4) throws IOException;

    protected static Object getRequired(String key, Map<String, Object> props) throws WriteException {
        Object value2 = props.get(key);
        if (value2 == null) {
            throw new WriteException("missing required property value '" + key + "'");
        }
        return value2;
    }

    public void writeAlpha(String text2, int minl, int maxl) throws IOException {
        for (int i = 0; i < text2.length(); ++i) {
            char chr = text2.charAt(i);
            if (chr < '0' || chr > '9') continue;
            throw new WriteException("alpha value type cannot contain digit");
        }
        this.writeSpacePadded(text2, minl, maxl);
    }

    public void writeInt(int value2, int minl, int maxl) throws IOException {
        this.writeZeroPadded(Integer.toString(value2), minl, maxl, 0);
    }

    public void writeLong(long value2, int minl, int maxl) throws IOException {
        this.writeZeroPadded(Long.toString(value2), minl, maxl, 0);
    }

    public void writeBigInteger(BigInteger value2, int minl, int maxl) throws IOException {
        this.writeZeroPadded(value2.toString(), minl, maxl, 0);
    }

    public void writeImplicitDecimal(BigDecimal value2, int scale, int minl, int maxl) throws IOException {
        this.writeBigInteger(value2.movePointRight(scale).setScale(scale, RoundingMode.HALF_UP).toBigIntegerExact(), minl, maxl);
    }

    public void writeDecimal(BigDecimal value2, int minl, int maxl) throws IOException {
        int adj;
        int precision = value2.precision();
        int scale = value2.scale();
        if (scale <= 0 && precision - scale <= maxl) {
            this.writeBigInteger(value2.toBigIntegerExact(), minl, maxl);
            return;
        }
        if (scale >= 0 && Math.max(precision, scale) <= maxl) {
            String text2 = value2.toPlainString();
            if (text2.startsWith("0")) {
                text2 = text2.substring(1);
            }
            this.writeZeroPadded(text2, minl, maxl, 1);
            return;
        }
        BigDecimal adjusted = value2.movePointRight(scale);
        String text3 = adjusted.toBigIntegerExact().toString() + "E" + Integer.toString(-scale);
        int n = adj = value2.signum() < 0 ? 2 : 1;
        if (scale > 0) {
            ++adj;
        }
        this.writeZeroPadded(text3, minl, maxl, adj);
    }

    public void writeNumeric(Number number2, int minl, int maxl) throws IOException {
        if (!(number2 instanceof BigInteger)) {
            BigDecimal value2 = (BigDecimal)number2;
            if (value2.scale() <= 0) {
                this.writeBigInteger(value2.toBigIntegerExact(), minl, maxl);
                return;
            }
            this.writeZeroPadded(value2.toPlainString(), minl, maxl, 1);
            return;
        }
        this.writeBigInteger((BigInteger)number2, minl, maxl);
    }

    protected void appendTwoDigit(int num, StringBuilder builder) {
        if (num < 10) {
            builder.append('0');
        }
        builder.append(num);
    }

    protected void appendFourDigit(int num, StringBuilder builder) {
        if (num < 1000) {
            builder.append('0');
            if (num < 100) {
                builder.append('0');
                if (num < 10) {
                    builder.append('0');
                }
            }
        }
        builder.append(num);
    }

    public void writeDate(Calendar calendar, int minl, int maxl) throws IOException {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        StringBuilder builder = new StringBuilder();
        builder.append(year);
        if (maxl == 6) {
            if (year > 2070 || year <= 1970) {
                throw new WriteException("year out of range for short form date");
            }
            builder.delete(0, 2);
        } else {
            if (builder.length() > 4) {
                throw new WriteException("year outside of allowed range");
            }
            while (builder.length() < 4) {
                builder.insert(0, '0');
            }
        }
        this.appendTwoDigit(month, builder);
        this.appendTwoDigit(day, builder);
        this.writeToken(builder.toString());
    }

    public void writeDate(Date date, int minl, int maxl) throws IOException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        this.writeDate(calendar, minl, maxl);
    }

    public void writeTime(int time, int minl, int maxl) throws IOException {
        int remain = time;
        StringBuilder builder = new StringBuilder();
        int hour = remain / 3600000;
        remain = time % 3600000;
        this.appendTwoDigit(hour, builder);
        int minute = remain / 60000;
        remain = time % 60000;
        this.appendTwoDigit(minute, builder);
        if (maxl > 4 && remain > 0) {
            int second = remain / 1000;
            remain = time % 1000;
            this.appendTwoDigit(second, builder);
            if (maxl > 7 && remain > 10) {
                this.appendTwoDigit(remain / 10, builder);
            } else if (maxl == 7 && remain > 100) {
                builder.append(remain / 100);
            } else if (minl > 7) {
                builder.append("00");
            } else if (minl > 6) {
                builder.append('0');
            }
        }
        while (builder.length() < minl) {
            builder.append('0');
        }
        this.writeToken(builder.toString());
    }

    public void writeDateTime(XMLGregorianCalendar dt, int minl, int maxl, boolean zone) throws IOException {
        int offset;
        int value2 = dt.getYear();
        if (value2 == Integer.MIN_VALUE) {
            throw new WriteException("missing required year value for date/time");
        }
        StringBuilder builder = new StringBuilder();
        this.appendFourDigit(value2, builder);
        value2 = dt.getMonth();
        if (value2 != Integer.MIN_VALUE) {
            this.appendTwoDigit(value2, builder);
            value2 = dt.getDay();
            if (value2 != Integer.MIN_VALUE) {
                this.appendTwoDigit(value2, builder);
                value2 = dt.getHour();
                if (value2 != Integer.MIN_VALUE) {
                    this.appendTwoDigit(value2, builder);
                    value2 = dt.getMinute();
                    if (value2 != Integer.MIN_VALUE) {
                        this.appendTwoDigit(value2, builder);
                        value2 = dt.getSecond();
                        if (value2 != Integer.MIN_VALUE) {
                            this.appendTwoDigit(value2, builder);
                            BigDecimal fract = dt.getFractionalSecond();
                            if (fract != null) {
                                builder.append(fract.toPlainString());
                            }
                        }
                    }
                }
            }
        }
        if (builder.length() < minl) {
            throw new WriteException("date/time value missing required components: " + builder.toString());
        }
        if (builder.length() > maxl) {
            builder.setLength(maxl);
        }
        if (zone && (offset = dt.getTimezone()) != Integer.MIN_VALUE) {
            builder.append(offset < 0 ? (char)'-' : '+');
            offset = Math.abs(offset);
            this.appendTwoDigit(offset / 60, builder);
            this.appendTwoDigit(offset % 60, builder);
        }
        this.writeToken(builder.toString());
    }
}

