/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rewrite;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.log4j.rewrite.RewritePolicy;
import org.apache.log4j.spi.LoggingEvent;

public class PropertyRewritePolicy
implements RewritePolicy {
    private Map properties = Collections.EMPTY_MAP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(String props) {
        HashMap<String, String> hashTable = new HashMap<String, String>();
        StringTokenizer pairs2 = new StringTokenizer(props, ",");
        while (pairs2.hasMoreTokens()) {
            StringTokenizer entry2 = new StringTokenizer(pairs2.nextToken(), "=");
            hashTable.put(entry2.nextElement().toString().trim(), entry2.nextElement().toString().trim());
        }
        PropertyRewritePolicy propertyRewritePolicy = this;
        synchronized (propertyRewritePolicy) {
            this.properties = hashTable;
        }
    }

    public LoggingEvent rewrite(LoggingEvent source) {
        if (!this.properties.isEmpty()) {
            HashMap rewriteProps = new HashMap(source.getProperties());
            Iterator iter2 = this.properties.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry2 = iter2.next();
                if (rewriteProps.containsKey(entry2.getKey())) continue;
                rewriteProps.put(entry2.getKey(), entry2.getValue());
            }
            return new LoggingEvent(source.getFQNOfLoggerClass(), source.getLogger() != null ? source.getLogger() : Logger.getLogger(source.getLoggerName()), source.getTimeStamp(), source.getLevel(), source.getMessage(), source.getThreadName(), source.getThrowableInformation(), source.getNDC(), source.getLocationInformation(), rewriteProps);
        }
        return source;
    }
}

