/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi;

import com.anypoint.df.edi.schema.EdiSchema;
import com.anypoint.df.edi.schema.EdiSchemaVersion;
import com.anypoint.df.edi.schema.YamlReader;
import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.Factory;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionContext;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.util.lock.LockFactory;
import scala.collection.convert.WrapAsJava$;

public abstract class BaseEdiModule {
    protected static final String B2B_TRANSMISSION_SESSION_FLOW_VARIABLE_KEY = "b2bTransmissionSession";
    private static final long LOCK_WAIT_SECONDS = 15L;
    protected B2BProvider b2bProvider;
    protected Factory<QueryObject> queryObjectFactory;
    protected Factory<Transmission> transmissionFactory;
    private EdiSchema combinedSchema;
    private ObjectStore counterObjectStore;
    private LockFactory lockFactory;
    private Map<String, EdiSchema.Structure> loadedSchemas = new ConcurrentHashMap<String, EdiSchema.Structure>();

    public synchronized void setCounterObjectStore(ObjectStore<? extends Serializable> counterObjectStore) {
        this.counterObjectStore = counterObjectStore;
    }

    public abstract List<String> getSchemas();

    protected abstract MuleRegistry getRegistry();

    public EdiSchema getCombinedSchema() {
        return this.combinedSchema;
    }

    protected void doStart() {
        MuleContext context = (MuleContext)this.getRegistry().lookupObject("_muleContext");
        this.lockFactory = context.getLockFactory();
        if (this.counterObjectStore == null) {
            this.counterObjectStore = (ObjectStore)this.getRegistry().lookupObject("_defaultUserObjectStore");
            if (this.counterObjectStore == null) {
                throw new IllegalArgumentException("Unable to acquire an object store.");
            }
        }
    }

    protected String nonnull(Serializable s1, String s2) {
        if (s1 != null) {
            return s1.toString();
        }
        return s2;
    }

    protected boolean isEmpty(String s2) {
        return s2 == null || s2.length() == 0;
    }

    protected void setNullDefault(String key, String dflt, Map<String, Object> map2) {
        if (map2.get(key) == null && !this.isEmpty(dflt)) {
            map2.put(key, dflt);
        }
    }

    protected String validateIdProperty(String text2, int minl, int maxl, String name) {
        int length = text2.length();
        if (length < minl - 1) {
            throw new IllegalArgumentException("Value '" + text2 + "' too short for " + name);
        }
        if (length > maxl) {
            throw new IllegalArgumentException("Value '" + text2 + "' too long for " + name);
        }
        for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(i);
            if (chr >= 'A' && chr <= 'Z' || chr >= 'a' && chr <= 'z' || chr >= '0' && chr <= '9') continue;
            throw new IllegalArgumentException("Character '" + chr + "' not allowed in id value " + name);
        }
        return text2;
    }

    protected Character validateSeparator(Character separator, String name) {
        char chr = separator.charValue();
        if (Character.isAlphabetic(chr) || Character.isDigit(chr)) {
            throw new IllegalArgumentException("Invalid separator or substitution character " + chr + " for " + name);
        }
        return separator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Integer getNextInteger(String key, int initial) {
        Lock lock = this.lockFactory.createLock(key);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to increment number " + key);
            try {
                Integer count2;
                if (this.counterObjectStore.contains((Serializable)((Object)key))) {
                    Integer count3 = (Integer)this.counterObjectStore.retrieve((Serializable)((Object)key));
                    count3 = count3 + 1;
                    this.counterObjectStore.remove((Serializable)((Object)key));
                } else {
                    count2 = initial;
                }
                this.counterObjectStore.store((Serializable)((Object)key), (Serializable)count2);
                Integer n = count2;
                return n;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Could not increment number " + key, e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to increment number " + key);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Long getNextLong(String key, long initial) {
        Lock lock = this.lockFactory.createLock(key);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to increment number " + key);
            try {
                Long count2;
                if (this.counterObjectStore.contains((Serializable)((Object)key))) {
                    Long count3 = (Long)this.counterObjectStore.retrieve((Serializable)((Object)key));
                    count3 = count3 + 1L;
                    this.counterObjectStore.remove((Serializable)((Object)key));
                } else {
                    count2 = initial;
                }
                this.counterObjectStore.store((Serializable)((Object)key), (Serializable)count2);
                Long l = count2;
                return l;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Could not increment number " + key, e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to increment number " + key);
        }
    }

    protected String incrementString(String value2, int maxlen) {
        char ch;
        int split2;
        for (split2 = value2.length(); split2 > 0 && (ch = value2.charAt(split2 - 1)) >= '0' && ch <= '9'; --split2) {
        }
        long seq = split2 < value2.length() ? Long.parseLong(value2.substring(split2)) : 0L;
        String suffix = Long.toString(seq + 1L);
        int excess = split2 + suffix.length() - maxlen;
        if (excess > 0) {
            if (excess >= suffix.length()) {
                throw new RuntimeException("Unable to increment string already at maximum length");
            }
            suffix = suffix.substring(excess);
        }
        return value2.substring(0, split2) + suffix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getNextString(String key, String initial, int maxlen) {
        Lock lock = this.lockFactory.createLock(key);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to update identifier " + key);
            try {
                String value2;
                if (this.counterObjectStore.contains((Serializable)((Object)key))) {
                    String value3 = this.incrementString(this.counterObjectStore.retrieve((Serializable)((Object)key)).toString(), maxlen);
                    this.counterObjectStore.remove((Serializable)((Object)key));
                } else {
                    value2 = initial;
                }
                this.counterObjectStore.store((Serializable)((Object)key), (Serializable)((Object)value2));
                String string2 = value2;
                return string2;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Could not update identifier " + key, e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to update identifier " + key);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cacheIdentifier(String ident2) {
        Lock lock = this.lockFactory.createLock(ident2);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to cache identifier " + ident2);
            try {
                if (this.counterObjectStore.contains((Serializable)((Object)ident2))) {
                    boolean bl = false;
                    return bl;
                }
                this.counterObjectStore.store((Serializable)((Object)ident2), (Serializable)((Object)""));
                boolean bl = true;
                return bl;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Could not cache identifier " + ident2, e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to cache identifier " + ident2);
        }
    }

    private static String schemaPath(String type, String version, String ident2) {
        return File.separator + type.toLowerCase() + File.separator + version.toLowerCase() + File.separator + ident2 + ".esl";
    }

    private static EdiSchema mergeAcks(List<EdiSchema.Structure> acks, EdiSchema merged) {
        if (acks != null) {
            for (EdiSchema.Structure struct : acks) {
                merged = merged.merge(struct);
            }
        }
        return merged;
    }

    protected void loadSchemas(List<EdiSchema.Structure> acks, EdiSchemaVersion dfltVersion) {
        EdiSchema merged = null;
        List<String> schemas = this.getSchemas();
        if (schemas == null || schemas.isEmpty()) {
            merged = new EdiSchema(dfltVersion);
        } else {
            YamlReader yamlrdr = new YamlReader();
            for (String path2 : schemas) {
                try {
                    InputStream is = yamlrdr.findSchema(path2, new String[]{""});
                    EdiSchema schema = yamlrdr.loadYaml(new InputStreamReader(is), new String[0]);
                    Map<String, EdiSchema.Structure> map2 = WrapAsJava$.MODULE$.mapAsJavaMap(schema.structures());
                    for (String ident2 : map2.keySet()) {
                        EdiSchemaVersion version = schema.ediVersion();
                        String key = BaseEdiModule.schemaPath(version.ediForm().text(), version.version(), ident2);
                        this.loadedSchemas.put(key, map2.get(ident2));
                    }
                    if (merged == null) {
                        merged = schema;
                    } else if (merged.ediVersion().equals(schema.ediVersion())) {
                        merged = merged.merge(schema);
                    } else {
                        throw new IllegalArgumentException("Configured schema version conflict (" + merged.ediVersion().version() + " vs. " + schema.ediVersion().version() + ")");
                    }
                    merged = merged == null ? schema : merged.merge(schema);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not load schema " + path2, e);
                }
            }
        }
        this.combinedSchema = merged = BaseEdiModule.mergeAcks(acks, merged);
    }

    protected EdiSchema.Structure getSchema(String type, String version, String ident2) {
        String path2 = File.separator + type.toLowerCase() + File.separator + version.toLowerCase() + File.separator + ident2 + ".esl";
        EdiSchema.Structure structure = this.loadedSchemas.get(path2);
        if (structure == null) {
            try {
                YamlReader yamlrdr = new YamlReader();
                InputStream is = yamlrdr.findSchema(path2, new String[]{""});
                EdiSchema schema = yamlrdr.loadYaml(new InputStreamReader(is), new String[0]);
                structure = (EdiSchema.Structure)schema.structures().apply(ident2);
                this.loadedSchemas.put(path2, structure);
                return structure;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load schema " + ident2 + " from path " + path2, e);
            }
        }
        return structure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadB2BProvider() throws Exception {
        if (this.b2bProvider == null) {
            BaseEdiModule baseEdiModule = this;
            synchronized (baseEdiModule) {
                try {
                    this.b2bProvider = (B2BProvider)this.getRegistry().lookupObject(B2BProvider.class);
                    if (this.b2bProvider == null) {
                        throw new Exception("Could not find B2B Provider. Configure B2B Connector to register an implementation of B2B Provider.");
                    }
                    this.queryObjectFactory = this.b2bProvider.getFactoryResolver().getFactory(QueryObject.class);
                    this.transmissionFactory = this.b2bProvider.getFactoryResolver().getFactory(Transmission.class);
                }
                catch (Exception e) {
                    throw new Exception("An error occurred while trying to read from registered B2B Provider", e);
                }
            }
        }
    }

    protected TransmissionSession trackTransmission(B2BProvider b2bProvider, MuleEvent muleEvent, Direction direction, Transmission transmission, TransmissionType transmissionType) throws B2BProviderException {
        TransmissionSession transmissionSession = (TransmissionSession)muleEvent.getMessage().getInvocationProperty(B2B_TRANSMISSION_SESSION_FLOW_VARIABLE_KEY);
        Object transmissionContextFactory = b2bProvider.getFactoryResolver().getFactory(TransmissionContext.class);
        TransmissionContext transmissionContext = (TransmissionContext)transmissionContextFactory.create();
        transmissionContext.setMuleEventId(muleEvent.getId());
        transmissionContext.setTransmissionSession(transmissionSession);
        return b2bProvider.writeTransmission(direction, transmission, transmissionContext, transmissionType);
    }

    protected TransmissionSession trackInboundTransmission(MuleEvent muleEvent, byte[] payload, Map<String, Object> parsedContent, TransmissionType transmissionType) throws B2BProviderException {
        Transmission transmission = this.transmissionFactory.create();
        String filename = (String)muleEvent.getMessage().getInboundProperty("originalFilename");
        if (filename != null) {
            transmission.put("filename", filename);
        }
        transmission.put("content", payload);
        transmission.put("edi", parsedContent);
        return this.trackTransmission(this.b2bProvider, muleEvent, Direction.INBOUND, transmission, transmissionType);
    }

    public static enum SegmentWhitespace {
        NONE(""),
        LF("\n"),
        LFCR("\r\n"),
        CR("\r");

        public final String whitespace;

        private SegmentWhitespace(String ws) {
            this.whitespace = ws;
        }
    }
}

