/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.x12;

import com.anypoint.df.edi.lexical.LexicalException;
import com.anypoint.df.edi.lexical.X12Constants;
import com.anypoint.df.edi.schema.X12Acknowledgment;
import com.anypoint.df.edi.schema.X12InterchangeException;
import com.anypoint.df.edi.schema.X12ParserConfig;
import com.anypoint.df.edi.schema.X12SchemaDefs;
import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.ConfigType;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.Factory;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import org.mule.modules.edi.x12.DirectEnvelopeHandler;
import org.mule.modules.edi.x12.X12EdiModule;

class B2BProviderEnvelopeHandler
extends DirectEnvelopeHandler {
    private B2BProvider b2bProvider;
    private Factory<QueryObject> queryObjectFactory;
    private String interchangeControlVersionNo;
    private String groupIdSelf;
    private String interchangeIdSelf;
    private String interchangeIdQualifierSelf;
    private String groupIdPartner;
    private String interchangeIdPartner;
    private String interchangeIdQualifierPartner;

    public B2BProviderEnvelopeHandler(B2BProvider b2bProvider, X12EdiModule x12EdiModule) throws Exception {
        super(x12EdiModule);
        this.b2bProvider = b2bProvider;
        this.queryObjectFactory = this.b2bProvider.getFactoryResolver().getFactory(QueryObject.class);
    }

    @Override
    public Object handleIsa(Map<String, Object> map2) throws LexicalException {
        Config ediB2BProviderConfig;
        this.groupIdSelf = this.x12EdiModule.getGroupIdSelf();
        this.interchangeIdSelf = this.x12EdiModule.getInterchangeIdSelf() != null ? this.x12EdiModule.getInterchangeIdSelf() : B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interReceiverInfoKey(), map2);
        this.interchangeIdQualifierSelf = this.x12EdiModule.getInterchangeIdQualifierSelf() != null ? this.x12EdiModule.getInterchangeIdQualifierSelf() : B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interReceiverQualKey(), map2);
        this.groupIdPartner = this.x12EdiModule.getGroupIdPartner();
        this.interchangeIdPartner = this.x12EdiModule.getInterchangeIdPartner() != null ? this.x12EdiModule.getInterchangeIdPartner() : B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interSenderInfoKey(), map2);
        String string2 = this.interchangeIdQualifierPartner = this.x12EdiModule.getInterchangeIdQualifierPartner() != null ? this.x12EdiModule.getInterchangeIdQualifierPartner() : B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interSenderQualKey(), map2);
        if (!(B2BProviderEnvelopeHandler.verifySetting(this.interchangeIdQualifierPartner, X12SchemaDefs.interSenderQualKey(), map2) && B2BProviderEnvelopeHandler.verifySetting(this.interchangeIdPartner, X12SchemaDefs.interSenderInfoKey(), map2) && B2BProviderEnvelopeHandler.verifySetting(this.interchangeIdQualifierSelf, X12SchemaDefs.interReceiverQualKey(), map2) && B2BProviderEnvelopeHandler.verifySetting(this.interchangeIdSelf, X12SchemaDefs.interReceiverInfoKey(), map2))) {
            throw new LexicalException("Interchange sender/receiver information does not match configuration");
        }
        QueryObject configQueryObject = this.queryObjectFactory.create();
        configQueryObject.put("applicationReceiverCode", this.groupIdSelf);
        configQueryObject.put("interchangeReceiverId", this.interchangeIdSelf);
        configQueryObject.put("interchangeReceiverQualifierId", this.interchangeIdQualifierSelf);
        configQueryObject.put("applicationSenderCode", this.groupIdPartner);
        configQueryObject.put("interchangeSenderId", this.interchangeIdPartner);
        configQueryObject.put("interchangeSenderQualifierId", this.interchangeIdQualifierPartner);
        this.interchangeControlVersionNo = B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.interControlVersionKey(), map2);
        configQueryObject.put("version", this.interchangeControlVersionNo);
        try {
            ediB2BProviderConfig = this.b2bProvider.getConfig(ConfigType.X12, Direction.INBOUND, configQueryObject);
        }
        catch (B2BProviderException e) {
            throw new X12InterchangeException(null, e.getMessage(), (Throwable)((Object)e));
        }
        if (ediB2BProviderConfig != null) {
            if (Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("requireUniqueInterchangeNumbers")).toString()).booleanValue()) {
                int controlNum = B2BProviderEnvelopeHandler.requiredInt(X12SchemaDefs.interControlNumberHeaderKey(), map2);
                QueryObject transmissionQueryObject = this.queryObjectFactory.create();
                transmissionQueryObject.put("applicationSenderCode", this.groupIdPartner);
                transmissionQueryObject.put("interchangeSenderId", this.interchangeIdPartner);
                transmissionQueryObject.put("interchangeSenderQualifierId", this.interchangeIdQualifierPartner);
                transmissionQueryObject.put("applicationReceiverCode", this.groupIdSelf);
                transmissionQueryObject.put("interchangeReceiverId", this.interchangeIdSelf);
                transmissionQueryObject.put("interchangeReceiverQualifierId", this.interchangeIdQualifierSelf);
                transmissionQueryObject.put("interchangeControlNumber", String.valueOf(controlNum));
                try {
                    if (this.b2bProvider.readTransmission(Direction.INBOUND, TransmissionType.X12, transmissionQueryObject) != null) {
                        String text2 = "Duplicate interchange control number " + controlNum;
                        logger.error(text2);
                        throw new X12InterchangeException(X12Acknowledgment.InterchangeDuplicateNumber(), text2, null);
                    }
                }
                catch (B2BProviderException e) {
                    logger.error(e.getMessage(), (Throwable)((Object)e));
                }
            }
            this.requireUniqueTransactionNumbers = Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("requireUniqueTransactionNumbers")).toString());
            if (!Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("requireUniqueGroupNumbers")).toString()).booleanValue()) {
                this.groupCache = new HashSet();
            }
            return this.createX12ParserConfig(ediB2BProviderConfig);
        }
        throw new LexicalException("Queried registered B2B Provider for X12 read config but none was found. Check your configuration. Lookup key used was: " + configQueryObject.toString());
    }

    @Override
    public Object handleGs(Map<String, Object> map2) throws LexicalException {
        Config ediB2BProviderConfig;
        QueryObject configQueryObject = this.queryObjectFactory.create();
        configQueryObject.put("applicationReceiverCode", this.groupIdSelf);
        configQueryObject.put("interchangeReceiverId", this.interchangeIdSelf);
        configQueryObject.put("interchangeReceiverQualifierId", this.interchangeIdQualifierSelf);
        configQueryObject.put("applicationSenderCode", this.groupIdPartner);
        configQueryObject.put("interchangeSenderId", this.interchangeIdPartner);
        configQueryObject.put("interchangeSenderQualifierId", this.interchangeIdQualifierPartner);
        configQueryObject.put("version", this.interchangeControlVersionNo);
        configQueryObject.put("messageType", B2BProviderEnvelopeHandler.requiredString(X12SchemaDefs.groupFunctionalIdentifierKey(), map2));
        try {
            ediB2BProviderConfig = this.b2bProvider.getConfig(ConfigType.X12, Direction.INBOUND, configQueryObject);
        }
        catch (B2BProviderException e) {
            throw new X12InterchangeException(null, e.getMessage(), (Throwable)((Object)e));
        }
        this.requireUniqueTransactionNumbers = Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("requireUniqueTransactionNumbers")).toString());
        Object x12Ack = this.doHandleGs(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("requireUniqueGroupNumbers")).toString()), map2);
        if (x12Ack != null) {
            return x12Ack;
        }
        return this.createX12ParserConfig(ediB2BProviderConfig);
    }

    private X12ParserConfig createX12ParserConfig(Config b2bProviderConfig) {
        return new X12ParserConfig(Boolean.valueOf(((Serializable)b2bProviderConfig.get("valueLengthErrorFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("invalidCharacterInValueFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("wrongValuesRepeatsFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("unknownsSegmentFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("segmentOutOfOrderFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("unusedSegmentPresentFail")).toString()), Boolean.valueOf(((Serializable)b2bProviderConfig.get("wrongSegmentsRepeatsFail")).toString()), this.x12EdiModule.getReportSegmentErrors(), Boolean.valueOf(((Serializable)b2bProviderConfig.get("generate999Acks")).toString()), -1, Enum.valueOf(X12Constants.CharacterRestriction.class, ((Serializable)b2bProviderConfig.get("stringCharacterSet")).toString()));
    }
}

