/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.x12;

import com.anypoint.df.edi.lexical.LexicalException;
import com.anypoint.df.edi.schema.EdiSchema;
import com.anypoint.df.edi.schema.X12Acknowledgment;
import com.anypoint.df.edi.schema.X12EnvelopeHandler;
import com.anypoint.df.edi.schema.X12InterchangeException;
import com.anypoint.df.edi.schema.X12ParserConfig;
import com.anypoint.df.edi.schema.X12SchemaDefs;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mule.modules.edi.BaseEnvelopeHandler;
import org.mule.modules.edi.x12.X12EdiModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectEnvelopeHandler
extends BaseEnvelopeHandler
implements X12EnvelopeHandler {
    protected static final Logger logger = LoggerFactory.getLogger(DirectEnvelopeHandler.class);
    protected X12EdiModule x12EdiModule;
    protected Set<String> groupCache;
    protected Set<String> setCache;
    protected String contextToken;
    protected String senderCode;
    protected String receiverCode;
    protected String versionCode;
    protected String functionalCode;
    protected boolean requireUniqueTransactionNumbers;

    public DirectEnvelopeHandler(X12EdiModule x12EdiModule) throws Exception {
        this.x12EdiModule = x12EdiModule;
        this.requireUniqueTransactionNumbers = x12EdiModule.isRequireUniqueTransactionNumbers();
    }

    @Override
    public Object handleIsa(Map<String, Object> map2) throws LexicalException {
        this.contextToken = DirectEnvelopeHandler.requiredString(X12SchemaDefs.interSenderQualKey(), map2) + DirectEnvelopeHandler.requiredString(X12SchemaDefs.interSenderInfoKey(), map2) + DirectEnvelopeHandler.requiredString(X12SchemaDefs.interReceiverQualKey(), map2) + DirectEnvelopeHandler.requiredString(X12SchemaDefs.interReceiverInfoKey(), map2);
        if (!(DirectEnvelopeHandler.verifySetting(this.x12EdiModule.getInterchangeIdQualifierPartner(), X12SchemaDefs.interSenderQualKey(), map2) && DirectEnvelopeHandler.verifySetting(this.x12EdiModule.getInterchangeIdPartner(), X12SchemaDefs.interSenderInfoKey(), map2) && DirectEnvelopeHandler.verifySetting(this.x12EdiModule.getInterchangeIdQualifierSelf(), X12SchemaDefs.interReceiverQualKey(), map2) && DirectEnvelopeHandler.verifySetting(this.x12EdiModule.getInterchangeIdSelf(), X12SchemaDefs.interReceiverInfoKey(), map2))) {
            throw new LexicalException("Interchange sender/receiver information does not match configuration");
        }
        int controlNum = DirectEnvelopeHandler.requiredInt(X12SchemaDefs.interControlNumberHeaderKey(), map2);
        if (this.x12EdiModule.isRequireUniqueInterchangeNumbers() && !this.x12EdiModule.cacheIdentifier(this.contextToken + controlNum)) {
            String text2 = "Duplicate interchange control number " + controlNum;
            logger.error(text2);
            throw new X12InterchangeException(X12Acknowledgment.InterchangeDuplicateNumber(), text2, null);
        }
        if (!this.x12EdiModule.isRequireUniqueGroupNumbers()) {
            this.groupCache = new HashSet<String>();
        }
        return new X12ParserConfig(this.x12EdiModule.getValueLengthErrorFail(), this.x12EdiModule.getInvalidCharacterInValueFail(), this.x12EdiModule.getWrongValuesRepeatsFail(), this.x12EdiModule.getUnknownsSegmentFail(), this.x12EdiModule.getSegmentOutOfOrderFail(), this.x12EdiModule.getUnusedSegmentPresentFail(), this.x12EdiModule.getWrongSegmentsRepeatsFail(), this.x12EdiModule.getReportSegmentErrors(), this.x12EdiModule.isGenerate999Acks(), -1, this.x12EdiModule.getStringCharacterSet());
    }

    @Override
    public Object handleGs(Map<String, Object> map2) throws LexicalException {
        return this.doHandleGs(this.x12EdiModule.isRequireUniqueGroupNumbers(), map2);
    }

    protected Object doHandleGs(boolean requireUniqueGroupNumbers, Map<String, Object> map2) throws LexicalException {
        String agency;
        if (!DirectEnvelopeHandler.verifySetting(this.x12EdiModule.getGroupIdPartner(), X12SchemaDefs.groupApplicationSenderKey(), map2) || !DirectEnvelopeHandler.verifySetting(this.x12EdiModule.getGroupIdSelf(), X12SchemaDefs.groupApplicationReceiverKey(), map2)) {
            throw new LexicalException("Group application sender/receiver information does not match configuration");
        }
        int controlNum = DirectEnvelopeHandler.requiredInt(X12SchemaDefs.groupControlNumberHeaderKey(), map2);
        this.senderCode = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupApplicationSenderKey(), map2);
        this.receiverCode = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupApplicationReceiverKey(), map2);
        String ident2 = this.contextToken + this.senderCode + this.receiverCode + ":" + controlNum;
        if (requireUniqueGroupNumbers) {
            if (!this.x12EdiModule.cacheIdentifier(ident2)) {
                logger.error("Duplicate group control number " + controlNum);
                return X12Acknowledgment.GroupControlNumberError();
            }
        } else if (!this.groupCache.add(ident2)) {
            logger.error("Duplicate group control number " + controlNum);
            return X12Acknowledgment.GroupControlNumberError();
        }
        if (!"X".equals(agency = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupResponsibleAgencyKey(), map2))) {
            logger.error("Group responsible agency code must be 'X' (found " + agency + ")");
            return X12Acknowledgment.NotSupportedGroupVersion();
        }
        String code2 = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupVersionReleaseIndustryKey(), map2);
        if (code2.length() < 6) {
            logger.error("Group version / release / industry identifier code less than 6 characters: '" + code2 + "'");
            return X12Acknowledgment.NotSupportedGroupVersion();
        }
        this.versionCode = code2.substring(0, 6);
        this.functionalCode = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupFunctionalIdentifierKey(), map2);
        if (!this.requireUniqueTransactionNumbers) {
            this.setCache = new HashSet<String>();
        }
        return null;
    }

    @Override
    public Object handleSt(Map<String, Object> map2) {
        EdiSchema.Structure structure;
        String controlNum = DirectEnvelopeHandler.requiredString(X12SchemaDefs.setControlNumberHeaderKey(), map2);
        String ident2 = this.contextToken + this.senderCode + this.receiverCode + "$" + controlNum;
        if (this.requireUniqueTransactionNumbers ? !this.x12EdiModule.cacheIdentifier(ident2) : !this.setCache.add(ident2)) {
            return X12Acknowledgment.BadTransactionSetControl();
        }
        String setId = DirectEnvelopeHandler.requiredString(X12SchemaDefs.setIdentifierCodeKey(), map2);
        try {
            structure = this.x12EdiModule.getStructureSchema(this.versionCode, setId);
        }
        catch (Exception e) {
            return X12Acknowledgment.NotSupportedTransaction();
        }
        if (!this.functionalCode.equals(structure.group().get())) {
            return X12Acknowledgment.SetNotInGroup();
        }
        return structure;
    }
}

