/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.x12;

import com.anypoint.df.edi.lexical.X12Constants;
import com.anypoint.df.edi.schema.EdiSchema;
import com.anypoint.df.edi.schema.EdiSchemaVersion;
import com.anypoint.df.edi.schema.SchemaJavaValues;
import com.anypoint.df.edi.schema.X12Acknowledgment;
import com.anypoint.df.edi.schema.X12InterchangeParser;
import com.anypoint.df.edi.schema.X12NumberProvider;
import com.anypoint.df.edi.schema.X12SchemaDefs;
import com.anypoint.df.edi.schema.X12SchemaWriter;
import com.anypoint.df.edi.schema.X12WriterConfig;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.Config;
import com.mulesoft.api.b2b.config.ConfigType;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.mule.api.MuleEvent;
import org.mule.api.annotations.param.MetaDataStaticKey;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.transport.OutputHandler;
import org.mule.modules.edi.BaseEdiModule;
import org.mule.modules.edi.TapOutputStream;
import org.mule.modules.edi.x12.B2BProviderEnvelopeHandler;
import org.mule.modules.edi.x12.DirectEnvelopeHandler;
import org.mule.modules.edi.x12.X12Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.util.Try;

public class X12EdiModule
extends BaseEdiModule {
    private static final Logger logger = LoggerFactory.getLogger(X12EdiModule.class);
    private X12Config x12Config;
    private List<String> schemas;
    private Boolean useB2BProvider = false;
    private String interchangeIdQualifierSelf;
    private String interchangeIdSelf;
    private String groupIdSelf;
    private String interchangeIdQualifierPartner;
    private String interchangeIdPartner;
    private String groupIdPartner;
    private X12CharacterEncoding characterEncoding;
    private X12Constants.CharacterRestriction stringCharacterSet;
    private Character stringSubstitutionChar;
    private String versionIdentifierSuffix;
    private boolean valueLengthErrorFail;
    private boolean invalidCharacterInValueFail;
    private boolean wrongValuesRepeatsFail;
    private boolean unknownsSegmentFail;
    private boolean segmentOutOfOrderFail;
    private boolean unusedSegmentPresentFail;
    private boolean wrongSegmentsRepeatsFail;
    private boolean reportSegmentErrors;
    private boolean requireUniqueInterchangeNumbers;
    private boolean requireUniqueGroupNumbers;
    private boolean requireUniqueTransactionNumbers;
    private boolean generate999Acks;
    private boolean includeFASchema;
    private Character dataSeparator;
    private Character componentSeparator;
    private Character repetitionSeparator;
    private Character segmentTerminator;
    private BaseEdiModule.SegmentWhitespace lineEnding;
    private boolean sendUniqueGroupNumbers;
    private boolean sendUniqueTransactionNumbers;
    private String implementationConventionReference;
    private int initialInterchangeNumber;
    private int initialGroupNumber;
    private int initialSetNumber;
    private boolean ackRequested;
    private Character defaultUsageIndicator;
    @Inject
    private MuleRegistry registry;

    public void setRegistry(MuleRegistry registry) {
        this.registry = registry;
    }

    @Override
    protected MuleRegistry getRegistry() {
        return this.registry;
    }

    public void onStart() throws Exception {
        EdiSchemaVersion dfltVersion = new EdiSchemaVersion(EdiSchema.convertEdiForm("X12"), "005010");
        if (this.includeFASchema) {
            List<EdiSchema.Structure> list2 = Collections.singletonList(this.generate999Acks ? X12Acknowledgment.trans999() : X12Acknowledgment.trans997());
            this.loadSchemas(list2, dfltVersion);
        } else {
            this.loadSchemas(null, dfltVersion);
        }
        if (!this.useB2BProvider.booleanValue()) {
            this.x12Config = this.createLocalX12Config();
        }
        this.doStart();
    }

    @Inject
    @MetaDataStaticKey(type="InMessage")
    public Map<String, Object> read(InputStream ediContent, MuleEvent event) throws Exception {
        Map<String, Object> parsedX12;
        if (ediContent == null) {
            throw new RuntimeException("Couldn't get the file");
        }
        if (this.useB2BProvider.booleanValue()) {
            this.loadB2BProvider();
            byte[] payload = event.getMessage().getPayloadAsBytes();
            X12InterchangeParser parser = new X12InterchangeParser(new ByteArrayInputStream(payload), this.characterEncoding.characterSet, new B2BProviderEnvelopeHandler(this.b2bProvider, this));
            parsedX12 = this.parse(parser);
            TransmissionSession transmissionSession = this.trackInboundTransmission(event, payload, parsedX12, TransmissionType.X12);
            event.setFlowVariable("b2bTransmissionSession", (Object)transmissionSession);
        } else {
            X12InterchangeParser parser = new X12InterchangeParser(ediContent, this.characterEncoding.characterSet, new DirectEnvelopeHandler(this));
            parsedX12 = this.parse(parser);
        }
        return parsedX12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Inject
    public OutputHandler write(final @MetaDataStaticKey(type="OutMessage") Map<String, Object> map2, String interIdQualSelf, String interIdSelf, String grpIdSelf, String interIdQualPartner, String interIdPartner, String grpIdPartner, MuleEvent event) throws Exception {
        HashMap<String, Object> imap;
        String delims;
        X12Config writeX12Config;
        final String selectedInterIdQualSelf = this.nonnull((Serializable)((Object)interIdQualSelf), this.interchangeIdQualifierSelf);
        final String selectedInterIdSelf = this.nonnull((Serializable)((Object)interIdSelf), this.interchangeIdSelf);
        final String selectedGrpIdSelf = this.nonnull((Serializable)((Object)grpIdSelf), this.groupIdSelf);
        final String selectedInterIdQualPartner = this.nonnull((Serializable)((Object)interIdQualPartner), this.interchangeIdQualifierPartner);
        final String selectedInterIdPartner = this.nonnull((Serializable)((Object)interIdPartner), this.interchangeIdPartner);
        final String selectedGrpIdPartner = this.nonnull((Serializable)((Object)grpIdPartner), this.groupIdPartner);
        if (this.useB2BProvider.booleanValue()) {
            Config ediB2BProviderConfig;
            this.loadB2BProvider();
            List<String> functionalIdCodes = this.getFunctionalIdCodes(map2);
            QueryObject queryObject = (QueryObject)this.queryObjectFactory.create();
            queryObject.put("applicationSenderCode", selectedGrpIdSelf);
            queryObject.put("interchangeSenderId", selectedInterIdSelf);
            queryObject.put("interchangeSenderQualifierId", selectedInterIdQualSelf);
            queryObject.put("applicationReceiverCode", selectedGrpIdPartner);
            queryObject.put("interchangeReceiverId", selectedInterIdPartner);
            queryObject.put("interchangeReceiverQualifierId", selectedInterIdQualPartner);
            queryObject.put("version", this.getCombinedSchema().ediVersion().version().substring(0, 5));
            if (functionalIdCodes.size() > 0) {
                queryObject.put("messageType", functionalIdCodes.get(0));
            }
            if ((ediB2BProviderConfig = this.b2bProvider.getConfig(ConfigType.X12, Direction.OUTBOUND, queryObject)) == null) throw new Exception("Queried registered B2B Provider for X12 write config but none was found. Check your configuration. Lookup key used was: " + queryObject.toString());
            writeX12Config = this.mapB2BProviderWriteConfigToX12Config(ediB2BProviderConfig);
        } else {
            writeX12Config = this.x12Config;
        }
        if ((delims = (String)map2.get(SchemaJavaValues.delimiterCharacters())) == null) {
            delims = new String(new char[]{writeX12Config.getDataSeparator().charValue(), writeX12Config.getComponentSeparator().charValue(), writeX12Config.getRepetitionSeparator().charValue(), writeX12Config.getSegmentTerminator().charValue()});
        } else if (delims.length() != 4) {
            throw new IllegalArgumentException(SchemaJavaValues.delimiterCharacters() + " value must be 4 characters: '" + delims + "'");
        }
        HashSet<Character> chars = new HashSet<Character>();
        for (int i = 0; i < 4; ++i) {
            char delim = delims.charAt(i);
            if ((Character.isAlphabetic(delim) || Character.isDigit(delim)) && (i != 2 || delim != 'U')) {
                throw new IllegalArgumentException("Invalid delimiter character: '" + delim + "'");
            }
            if (chars.add(Character.valueOf(delim))) continue;
            throw new IllegalArgumentException("Duplicate delimiter character: '" + delim + "'");
        }
        final String useDelims = delims;
        HashMap<String, Object> gmap = (HashMap<String, Object>)map2.get(SchemaJavaValues.groupKey());
        if (gmap == null) {
            gmap = new HashMap<String, Object>();
            map2.put(SchemaJavaValues.groupKey(), gmap);
        }
        if ((imap = (HashMap<String, Object>)map2.get(SchemaJavaValues.interchangeKey())) == null) {
            imap = new HashMap<String, Object>();
            map2.put(SchemaJavaValues.interchangeKey(), imap);
        }
        if (!imap.containsKey(X12SchemaDefs.interAckRequestedKey())) {
            imap.put(X12SchemaDefs.interAckRequestedKey(), writeX12Config.isAckRequested() ? "1" : "0");
        }
        if (!imap.containsKey(X12SchemaDefs.interControlVersionKey())) {
            imap.put(X12SchemaDefs.interControlVersionKey(), this.getCombinedSchema().ediVersion().version().substring(0, 5));
        }
        if (!imap.containsKey(X12SchemaDefs.interUsageIndicatorKey())) {
            imap.put(X12SchemaDefs.interUsageIndicatorKey(), new String(new char[]{writeX12Config.getDefaultUsageIndicator().charValue()}));
        }
        this.setNullDefault(X12SchemaDefs.interSenderQualKey(), selectedInterIdQualSelf, imap);
        this.setNullDefault(X12SchemaDefs.interSenderInfoKey(), selectedInterIdSelf, imap);
        this.setNullDefault(X12SchemaDefs.interReceiverQualKey(), selectedInterIdQualPartner, imap);
        this.setNullDefault(X12SchemaDefs.interReceiverInfoKey(), selectedInterIdPartner, imap);
        this.setNullDefault(X12SchemaDefs.groupApplicationSenderKey(), selectedGrpIdSelf, gmap);
        this.setNullDefault(X12SchemaDefs.groupApplicationReceiverKey(), selectedGrpIdPartner, gmap);
        this.setNullDefault(X12SchemaDefs.groupResponsibleAgencyKey(), "X", gmap);
        String versionId = this.getCombinedSchema().ediVersion().version() + (writeX12Config.getVersionIdentifierSuffix() == null ? "" : writeX12Config.getVersionIdentifierSuffix());
        this.setNullDefault(X12SchemaDefs.groupVersionReleaseIndustryKey(), versionId, gmap);
        if (this.isEmpty(writeX12Config.getImplementationConventionReference())) return new OutputHandler(){
            final Transmission transmission;
            {
                this.transmission = X12EdiModule.this.useB2BProvider != false ? (Transmission)X12EdiModule.this.transmissionFactory.create() : null;
            }

            public void write(MuleEvent onWriteEvent, OutputStream output) throws IOException {
                final ArrayList functionalGroupControlNumbers = new ArrayList();
                ByteArrayOutputStream tapStream = new ByteArrayOutputStream();
                int subChar = writeX12Config.getStringSubstitutionChar() == null ? -1 : (int)writeX12Config.getStringSubstitutionChar().charValue();
                X12WriterConfig config = new X12WriterConfig(true, writeX12Config.getStringCharacterSet(), subChar, writeX12Config.getCharacterEncoding().characterSet, useDelims, writeX12Config.getLineEnding().whitespace);
                Map verMap = (Map)map2.get(X12SchemaDefs.transactionsMap());
                for (String vkey : verMap.keySet()) {
                    Map transMap = (Map)verMap.get(vkey);
                    for (String tkey : transMap.keySet()) {
                        List sets = (List)transMap.get(tkey);
                        if (sets.isEmpty()) continue;
                        EdiSchema.Structure structure = X12EdiModule.this.getStructureSchema(vkey.substring(1), tkey);
                        for (Map set : sets) {
                            set.put(SchemaJavaValues.structureSchema(), structure);
                        }
                    }
                }
                X12SchemaWriter writer = new X12SchemaWriter(X12EdiModule.this.useB2BProvider != false ? new TapOutputStream(output, tapStream) : output, new X12NumberProvider(){
                    int groupNum;
                    int setNum;

                    @Override
                    public String interchangIdentifier(String senderQual, String senderId, String receiverQual, String receiverId) {
                        return senderQual + senderId + receiverQual + receiverId;
                    }

                    @Override
                    public int nextInterchange(String interchange) {
                        this.groupNum = writeX12Config.getInitialGroupNumber();
                        int interchangeControlNumber = X12EdiModule.this.getNextInteger(interchange, writeX12Config.getInitialInterchangeNumber());
                        if (transmission != null) {
                            transmission.put("interchangeControlNumber", interchangeControlNumber);
                        }
                        return interchangeControlNumber;
                    }

                    @Override
                    public int nextGroup(String interchange, String senderCode, String receiverCode) {
                        this.setNum = writeX12Config.getInitialSetNumber();
                        int functionalGroupControlNo = writeX12Config.isSendUniqueGroupNumbers() ? X12EdiModule.this.getNextInteger(interchange + "*" + senderCode + receiverCode, writeX12Config.getInitialGroupNumber()) : this.groupNum++;
                        functionalGroupControlNumbers.add(functionalGroupControlNo);
                        return functionalGroupControlNo;
                    }

                    @Override
                    public String nextSet(String interchange, String senderCode, String receiverCode) {
                        if (writeX12Config.isSendUniqueTransactionNumbers()) {
                            return Integer.toString(X12EdiModule.this.getNextInteger(interchange + "+" + senderCode + receiverCode, writeX12Config.getInitialSetNumber()));
                        }
                        return Integer.toString(this.setNum++);
                    }
                }, config);
                writer.write(map2).get();
                try {
                    if (this.transmission != null) {
                        this.transmission.put("edi", map2);
                        this.transmission.put("functionalGroupControlNumbers", functionalGroupControlNumbers);
                        String filename = (String)onWriteEvent.getMessage().getInboundProperty("originalFilename");
                        if (filename != null) {
                            this.transmission.put("filename", filename);
                        }
                        this.transmission.put("content", tapStream.toByteArray());
                        this.transmission.put("interchangeReceiverId", selectedInterIdPartner);
                        this.transmission.put("interchangeReceiverQualifierId", selectedInterIdQualPartner);
                        this.transmission.put("applicationReceiverCode", selectedGrpIdPartner);
                        this.transmission.put("interchangeSenderId", selectedInterIdSelf);
                        this.transmission.put("interchangeSenderQualifierId", selectedInterIdQualSelf);
                        this.transmission.put("applicationSenderCode", selectedGrpIdSelf);
                        TransmissionSession transmissionSession = X12EdiModule.this.trackTransmission(X12EdiModule.this.b2bProvider, onWriteEvent, Direction.OUTBOUND, this.transmission, TransmissionType.X12);
                        onWriteEvent.setFlowVariable("b2bTransmissionSession", (Object)transmissionSession);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        HashMap<String, String> smap = (HashMap<String, String>)map2.get(X12SchemaDefs.setKey());
        if (smap == null) {
            smap = new HashMap<String, String>();
            map2.put(X12SchemaDefs.setKey(), smap);
        }
        smap.put(X12SchemaDefs.setImplementationConventionKey(), writeX12Config.getImplementationConventionReference());
        return new /* invalid duplicate definition of identical inner class */;
    }

    protected String validateStringProperty(String text2, int maxl, X12Constants.CharacterRestriction chset, String name) {
        int length = text2.length();
        if (length > maxl) {
            throw new IllegalArgumentException("Value '" + text2 + "' too long for " + name);
        }
        boolean[] allowedChars = chset.flags();
        for (int i = 0; i < length; ++i) {
            char chr = text2.charAt(i);
            if (chr <= allowedChars.length && allowedChars[chr]) continue;
            throw new IllegalArgumentException("Character '" + chr + "' not allowed in string value " + name);
        }
        return text2;
    }

    protected int validateNumberProperty(int number2, String name) {
        if (number2 > 999999999) {
            throw new IllegalArgumentException("Value '" + number2 + "' too large for " + name);
        }
        if (number2 < 0) {
            throw new IllegalArgumentException("Value for " + name + " must be positive");
        }
        return number2;
    }

    @Override
    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public String getInterchangeIdQualifierSelf() {
        return this.interchangeIdQualifierSelf;
    }

    public void setInterchangeIdQualifierSelf(String interchangeIdQualifierSelf) {
        this.interchangeIdQualifierSelf = this.validateIdProperty(interchangeIdQualifierSelf, 2, 2, "interchangeIdQualifierSelf");
    }

    public String getInterchangeIdSelf() {
        return this.interchangeIdSelf;
    }

    public void setInterchangeIdSelf(String interchangeIdSelf) {
        this.interchangeIdSelf = this.validateStringProperty(interchangeIdSelf, 15, X12Constants.CharacterRestriction.EXTENDED, "interchangeIdSelf");
    }

    public int getInitialInterchangeNumber() {
        return this.initialInterchangeNumber;
    }

    public void setInitialInterchangeNumber(int initialInterchangeNumber) {
        this.initialInterchangeNumber = this.validateNumberProperty(initialInterchangeNumber, "initialInterchangeNumber");
    }

    public String getGroupIdSelf() {
        return this.groupIdSelf;
    }

    public void setGroupIdSelf(String groupIdSelf) {
        this.groupIdSelf = this.validateStringProperty(groupIdSelf, 15, X12Constants.CharacterRestriction.EXTENDED, "groupIdSelf");
    }

    public String getInterchangeIdQualifierPartner() {
        return this.interchangeIdQualifierPartner;
    }

    public void setInterchangeIdQualifierPartner(String interchangeIdQualifierPartner) {
        this.interchangeIdQualifierPartner = this.validateIdProperty(interchangeIdQualifierPartner, 2, 2, "interchangeIdQualifierPartner");
    }

    public String getInterchangeIdPartner() {
        return this.interchangeIdPartner;
    }

    public void setInterchangeIdPartner(String interchangeIdPartner) {
        this.interchangeIdPartner = this.validateStringProperty(interchangeIdPartner, 15, X12Constants.CharacterRestriction.EXTENDED, "interchangeIdPartner");
    }

    public String getGroupIdPartner() {
        return this.groupIdPartner;
    }

    public void setGroupIdPartner(String groupIdPartner) {
        this.groupIdPartner = this.validateStringProperty(groupIdPartner, 15, X12Constants.CharacterRestriction.EXTENDED, "groupIdPartner");
    }

    public boolean getAckRequested() {
        return this.ackRequested;
    }

    public void setAckRequested(boolean ackRequested) {
        this.ackRequested = ackRequested;
    }

    public String getImplementationConventionReference() {
        return this.implementationConventionReference;
    }

    public void setImplementationConventionReference(String implementationConventionReference) {
        this.implementationConventionReference = this.validateStringProperty(implementationConventionReference, 35, X12Constants.CharacterRestriction.EXTENDED, "implementationConventionReference");
    }

    public boolean getValueLengthErrorFail() {
        return this.valueLengthErrorFail;
    }

    public void setValueLengthErrorFail(boolean valueLengthErrorFail) {
        this.valueLengthErrorFail = valueLengthErrorFail;
    }

    public X12Constants.CharacterRestriction getStringCharacterSet() {
        return this.stringCharacterSet;
    }

    public void setStringCharacterSet(X12Constants.CharacterRestriction stringCharacterSet) {
        this.stringCharacterSet = stringCharacterSet;
    }

    public Character getStringSubstitutionChar() {
        return this.stringSubstitutionChar;
    }

    public void setStringSubstitutionChar(Character stringSubstitutionChar) {
        this.stringSubstitutionChar = this.validateSeparator(stringSubstitutionChar, "stringSubstitutionChar");
    }

    public boolean getInvalidCharacterInValueFail() {
        return this.invalidCharacterInValueFail;
    }

    public void setInvalidCharacterInValueFail(boolean invalidCharacterInValueFail) {
        this.invalidCharacterInValueFail = invalidCharacterInValueFail;
    }

    public boolean getWrongValuesRepeatsFail() {
        return this.wrongValuesRepeatsFail;
    }

    public void setWrongValuesRepeatsFail(boolean wrongValuesRepeatsFail) {
        this.wrongValuesRepeatsFail = wrongValuesRepeatsFail;
    }

    public boolean getUnknownsSegmentFail() {
        return this.unknownsSegmentFail;
    }

    public void setUnknownsSegmentFail(boolean unknownsSegmentFail) {
        this.unknownsSegmentFail = unknownsSegmentFail;
    }

    public boolean getSegmentOutOfOrderFail() {
        return this.segmentOutOfOrderFail;
    }

    public void setSegmentOutOfOrderFail(boolean segmentOutOfOrderFail) {
        this.segmentOutOfOrderFail = segmentOutOfOrderFail;
    }

    public boolean getUnusedSegmentPresentFail() {
        return this.unusedSegmentPresentFail;
    }

    public void setUnusedSegmentPresentFail(boolean unusedSegmentPresentFail) {
        this.unusedSegmentPresentFail = unusedSegmentPresentFail;
    }

    public boolean getWrongSegmentsRepeatsFail() {
        return this.wrongSegmentsRepeatsFail;
    }

    public void setWrongSegmentsRepeatsFail(boolean wrongSegmentsRepeatsFail) {
        this.wrongSegmentsRepeatsFail = wrongSegmentsRepeatsFail;
    }

    public boolean getReportSegmentErrors() {
        return this.reportSegmentErrors;
    }

    public void setReportSegmentErrors(boolean reportSegmentErrors) {
        this.reportSegmentErrors = reportSegmentErrors;
    }

    public boolean isRequireUniqueInterchangeNumbers() {
        return this.requireUniqueInterchangeNumbers;
    }

    public void setRequireUniqueInterchangeNumbers(boolean requireUniqueInterchangeNumbers) {
        this.requireUniqueInterchangeNumbers = requireUniqueInterchangeNumbers;
    }

    public boolean isRequireUniqueGroupNumbers() {
        return this.requireUniqueGroupNumbers;
    }

    public void setRequireUniqueGroupNumbers(boolean requireUniqueGroupNumbers) {
        this.requireUniqueGroupNumbers = requireUniqueGroupNumbers;
    }

    public boolean isRequireUniqueTransactionNumbers() {
        return this.requireUniqueTransactionNumbers;
    }

    public void setRequireUniqueTransactionNumbers(boolean requireUniqueTransactionNumbers) {
        this.requireUniqueTransactionNumbers = requireUniqueTransactionNumbers;
    }

    public boolean isSendUniqueGroupNumbers() {
        return this.sendUniqueGroupNumbers;
    }

    public void setSendUniqueGroupNumbers(boolean sendUniqueGroupNumbers) {
        this.sendUniqueGroupNumbers = sendUniqueGroupNumbers;
    }

    public boolean isSendUniqueTransactionNumbers() {
        return this.sendUniqueTransactionNumbers;
    }

    public void setSendUniqueTransactionNumbers(boolean sendUniqueTransactionNumbers) {
        this.sendUniqueTransactionNumbers = sendUniqueTransactionNumbers;
    }

    public int getInitialGroupNumber() {
        return this.initialGroupNumber;
    }

    public void setInitialGroupNumber(int initialGroupNumber) {
        this.initialGroupNumber = this.validateNumberProperty(initialGroupNumber, "initialGroupNumber");
    }

    public int getInitialSetNumber() {
        return this.initialSetNumber;
    }

    public void setInitialSetNumber(int initialSetNumber) {
        this.initialSetNumber = this.validateNumberProperty(initialSetNumber, "initialSetNumber");
    }

    public Character getDefaultUsageIndicator() {
        return this.defaultUsageIndicator;
    }

    public void setDefaultUsageIndicator(Character defaultUsageIndicator) {
        if ("IPT".indexOf(defaultUsageIndicator.charValue()) < 0) {
            throw new IllegalArgumentException("Character '" + defaultUsageIndicator + "' is not a valid choice for defaultUsageIndicator");
        }
        this.defaultUsageIndicator = defaultUsageIndicator;
    }

    public boolean isGenerate999Acks() {
        return this.generate999Acks;
    }

    public void setGenerate999Acks(boolean generate999Acks) {
        this.generate999Acks = generate999Acks;
    }

    public boolean isIncludeFASchema() {
        return this.includeFASchema;
    }

    public void setIncludeFASchema(boolean includeFASchema) {
        this.includeFASchema = includeFASchema;
    }

    public X12CharacterEncoding getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(X12CharacterEncoding characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public Character getDataSeparator() {
        return this.dataSeparator;
    }

    public void setDataSeparator(Character dataSeparator) {
        this.dataSeparator = this.validateSeparator(dataSeparator, "dataSeparator");
    }

    public Character getComponentSeparator() {
        return this.componentSeparator;
    }

    public void setComponentSeparator(Character componentSeparator) {
        this.componentSeparator = this.validateSeparator(componentSeparator, "componentSeparator");
    }

    public Character getRepetitionSeparator() {
        return this.repetitionSeparator;
    }

    public void setRepetitionSeparator(Character repetitionSeparator) {
        this.repetitionSeparator = repetitionSeparator.charValue() == 'U' ? repetitionSeparator : this.validateSeparator(repetitionSeparator, "repetitionSeparator");
    }

    public Character getSegmentTerminator() {
        return this.segmentTerminator;
    }

    public void setSegmentTerminator(Character segmentTerminator) {
        this.segmentTerminator = this.validateSeparator(segmentTerminator, "segmentTerminator");
    }

    public BaseEdiModule.SegmentWhitespace getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(BaseEdiModule.SegmentWhitespace lineEnding) {
        this.lineEnding = lineEnding;
    }

    public String getVersionIdentifierSuffix() {
        return this.versionIdentifierSuffix;
    }

    public void setVersionIdentifierSuffix(String versionIdentifierSuffix) {
        this.versionIdentifierSuffix = this.validateStringProperty(versionIdentifierSuffix, 6, X12Constants.CharacterRestriction.EXTENDED, "versionIdentifierSuffix");
    }

    public Boolean getUseB2BProvider() {
        return this.useB2BProvider;
    }

    public void setUseB2BProvider(Boolean useB2BProvider) {
        this.useB2BProvider = useB2BProvider;
    }

    protected EdiSchema.Structure getStructureSchema(String version, String setId) {
        if (setId.equals("997")) {
            return X12Acknowledgment.trans997();
        }
        if (setId.equals("999")) {
            return X12Acknowledgment.trans999();
        }
        return this.getSchema("X12", version, setId);
    }

    private X12Config mapB2BProviderWriteConfigToX12Config(Config ediB2BProviderConfig) throws Exception {
        X12Config x12Config = new X12Config();
        x12Config.setCharacterEncoding(Enum.valueOf(X12CharacterEncoding.class, ((Serializable)ediB2BProviderConfig.get("characterEncoding")).toString()));
        x12Config.setStringCharacterSet(Enum.valueOf(X12Constants.CharacterRestriction.class, ((Serializable)ediB2BProviderConfig.get("stringCharacterSet")).toString()));
        if (ediB2BProviderConfig.get("stringSubstitutionChar") != null) {
            x12Config.setStringSubstitutionChar(new Character(((Serializable)ediB2BProviderConfig.get("stringSubstitutionChar")).toString().charAt(0)));
        }
        x12Config.setVersionIdentifierSuffix(this.validateStringProperty(((Serializable)ediB2BProviderConfig.get("versionIdentifierSuffix")).toString(), 6, X12Constants.CharacterRestriction.EXTENDED, "versionIdentifierSuffix"));
        x12Config.setSendUniqueGroupNumbers(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("sendUniqueGroupNumbers")).toString()));
        x12Config.setSendUniqueTransactionNumbers(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("sendUniqueTransactionNumbers")).toString()));
        x12Config.setDataSeparator(new Character(((Serializable)ediB2BProviderConfig.get("dataSeparator")).toString().charAt(0)));
        x12Config.setComponentSeparator(new Character(((Serializable)ediB2BProviderConfig.get("componentSeparator")).toString().charAt(0)));
        x12Config.setRepetitionSeparator(new Character(((Serializable)ediB2BProviderConfig.get("repetitionSeparator")).toString().charAt(0)));
        x12Config.setSegmentTerminator(new Character(((Serializable)ediB2BProviderConfig.get("segmentTerminator")).toString().charAt(0)));
        x12Config.setLineEnding(Enum.valueOf(BaseEdiModule.SegmentWhitespace.class, ((Serializable)ediB2BProviderConfig.get("lineEnding")).toString()));
        x12Config.setSendUniqueGroupNumbers(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("sendUniqueGroupNumbers")).toString()));
        x12Config.setSendUniqueTransactionNumbers(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("sendUniqueTransactionNumbers")).toString()));
        x12Config.setImplementationConventionReference(this.validateStringProperty(((Serializable)ediB2BProviderConfig.get("implementationConventionReference")).toString(), 35, X12Constants.CharacterRestriction.EXTENDED, "implementationConventionReference"));
        x12Config.setInitialInterchangeNumber(Integer.parseInt(((Serializable)ediB2BProviderConfig.get("initialInterchangeNumber")).toString()));
        x12Config.setInitialGroupNumber(Integer.parseInt(((Serializable)ediB2BProviderConfig.get("initialGroupNumber")).toString()));
        x12Config.setInitialSetNumber(Integer.parseInt(((Serializable)ediB2BProviderConfig.get("initialSetNumber")).toString()));
        x12Config.setAckRequested(Boolean.valueOf(((Serializable)ediB2BProviderConfig.get("ackRequested")).toString()));
        x12Config.setDefaultUsageIndicator(new Character(((Serializable)ediB2BProviderConfig.get("defaultUsageIndicator")).toString().charAt(0)));
        return x12Config;
    }

    private X12Config createLocalX12Config() throws Exception {
        X12Config x12Config = new X12Config();
        x12Config.setCharacterEncoding(this.characterEncoding);
        x12Config.setStringCharacterSet(this.stringCharacterSet);
        x12Config.setStringSubstitutionChar(this.stringSubstitutionChar);
        x12Config.setVersionIdentifierSuffix(this.versionIdentifierSuffix);
        x12Config.setValueLengthErrorFail(this.valueLengthErrorFail);
        x12Config.setInvalidCharacterInValueFail(this.invalidCharacterInValueFail);
        x12Config.setWrongValuesRepeatsFail(this.wrongValuesRepeatsFail);
        x12Config.setUnknownsSegmentFail(this.unknownsSegmentFail);
        x12Config.setSegmentOutOfOrderFail(this.segmentOutOfOrderFail);
        x12Config.setUnusedSegmentPresentFail(this.unusedSegmentPresentFail);
        x12Config.setWrongSegmentsRepeatsFail(this.wrongSegmentsRepeatsFail);
        x12Config.setReportSegmentErrors(this.reportSegmentErrors);
        x12Config.setRequireUniqueInterchangeNumbers(this.requireUniqueInterchangeNumbers);
        x12Config.setRequireUniqueGrouplNumbers(this.requireUniqueGroupNumbers);
        x12Config.setRequireUniqueTransactionNumbers(this.requireUniqueTransactionNumbers);
        x12Config.setGenerate999Acks(this.generate999Acks);
        x12Config.setIncludeFASchema(this.includeFASchema);
        x12Config.setDataSeparator(this.dataSeparator);
        x12Config.setComponentSeparator(this.componentSeparator);
        x12Config.setRepetitionSeparator(this.repetitionSeparator);
        x12Config.setSegmentTerminator(this.segmentTerminator);
        x12Config.setLineEnding(this.lineEnding);
        x12Config.setSendUniqueGroupNumbers(this.sendUniqueGroupNumbers);
        x12Config.setSendUniqueTransactionNumbers(this.sendUniqueTransactionNumbers);
        x12Config.setImplementationConventionReference(this.implementationConventionReference);
        x12Config.setInitialInterchangeNumber(this.initialInterchangeNumber);
        x12Config.setInitialGroupNumber(this.initialGroupNumber);
        x12Config.setInitialSetNumber(this.initialSetNumber);
        x12Config.setAckRequested(this.ackRequested);
        x12Config.setDefaultUsageIndicator(this.defaultUsageIndicator);
        return x12Config;
    }

    private Map<String, Object> parse(X12InterchangeParser parser) {
        Try<Map<String, Object>> parse2 = parser.parse();
        return parse2.get();
    }

    private List<String> getFunctionalIdCodes(Map x12) {
        ArrayList<String> functionalIdCodes = new ArrayList<String>();
        Map transactionSetsByVersion = (Map)x12.get(X12SchemaDefs.transactionsMap());
        for (Map.Entry transactionSetsByVersionEntry : transactionSetsByVersion.entrySet()) {
            for (Map.Entry transactionSetsByTransactionSetIdCode : ((Map)transactionSetsByVersionEntry.getValue()).entrySet()) {
                List transactionSets = (List)transactionSetsByTransactionSetIdCode.getValue();
                for (Map transactionSet : transactionSets) {
                    if (transactionSet.get("Structure") == null) continue;
                    functionalIdCodes.add(((EdiSchema.Structure)transactionSet.get("Structure")).group().get());
                }
            }
        }
        Collections.sort(functionalIdCodes);
        return functionalIdCodes;
    }

    public static enum X12CharacterEncoding {
        ASCII("ASCII"),
        ISO8859_1("ISO-8859-1"),
        IBM1047("IBM1047"),
        UTF8("UTF-8");

        public final Charset characterSet;

        private X12CharacterEncoding(String name) {
            this.characterSet = Charset.forName(name);
        }
    }
}

