/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi.x12.adapters;

import com.mulesource.licm.EnterpriseLicenseKey;
import com.mulesource.licm.LicenseKeyException;
import com.mulesource.licm.LicenseManagementFactory;
import com.mulesource.licm.LicenseManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.property.StructureIdentifierMetaDataModelProperty;
import org.mule.modules.edi.x12.X12EdiMetaData;
import org.mule.modules.edi.x12.adapters.X12EdiModuleCapabilitiesAdapter;
import org.mule.modules.edi.x12.adapters.X12EdiModuleLifecycleAdapter;
import org.mule.security.oauth.callback.ProcessCallback;

public class X12EdiModuleProcessAdapter
extends X12EdiModuleLifecycleAdapter
implements ProcessAdapter<X12EdiModuleCapabilitiesAdapter>,
Initialisable,
ConnectorMetaDataEnabled {
    public <P> ProcessTemplate<P, X12EdiModuleCapabilitiesAdapter> getProcessTemplate() {
        final X12EdiModuleProcessAdapter object = this;
        return new ProcessTemplate<P, X12EdiModuleCapabilitiesAdapter>(){

            public P execute(ProcessCallback<P, X12EdiModuleCapabilitiesAdapter> processCallback, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
                return processCallback.process((Object)object);
            }

            public P execute(ProcessCallback<P, X12EdiModuleCapabilitiesAdapter> processCallback, Filter filter2, MuleMessage message) throws Exception {
                return processCallback.process((Object)object);
            }
        };
    }

    public Result<List<MetaDataKey>> getMetaDataKeys() {
        try {
            ArrayList<MetaDataKey> gatheredMetaDataKeys = new ArrayList<MetaDataKey>();
            X12EdiMetaData x12EdiMetaData = new X12EdiMetaData();
            x12EdiMetaData.setModule(this);
            gatheredMetaDataKeys.addAll(this.fillCategory(x12EdiMetaData.getMetaDataKeys(), "X12EdiMetaData"));
            return new DefaultResult(gatheredMetaDataKeys, Result.Status.SUCCESS);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving the metadata keys from service provider after acquiring connection, for more detailed information please read the provided stacktrace", (FailureType)MetaDataFailureType.ERROR_METADATA_KEYS_RETRIEVER, (Throwable)e);
        }
    }

    private List<MetaDataKey> fillCategory(List<MetaDataKey> metadataKeys, String categoryClassName) {
        for (MetaDataKey metaDataKey : metadataKeys) {
            ((DefaultMetaDataKey)metaDataKey).setCategory(categoryClassName);
        }
        return metadataKeys;
    }

    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        try {
            MetaData metaData = null;
            TypeDescribingProperty property = (TypeDescribingProperty)metaDataKey.getProperty(TypeDescribingProperty.class);
            String category = ((DefaultMetaDataKey)metaDataKey).getCategory();
            if (category != null) {
                if (!category.equals("X12EdiMetaData")) {
                    throw new Exception("Invalid key type. There is no matching category for [" + metaDataKey.getId() + "]. All keys must contain a category with any of the following options:[X12EdiMetaData]" + ", but found [" + category + "] instead");
                }
            } else {
                throw new Exception("Invalid key type. There is no matching category for [" + metaDataKey.getId() + "]. All keys must contain a category with any of the following options:[X12EdiMetaData]");
            }
            X12EdiMetaData x12EdiMetaData = new X12EdiMetaData();
            x12EdiMetaData.setModule(this);
            metaData = x12EdiMetaData.getMetaData(metaDataKey);
            metaData.getPayload().addProperty((MetaDataModelProperty)new StructureIdentifierMetaDataModelProperty(metaDataKey, false));
            return new DefaultResult((Object)metaData);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, this.getMetaDataException(metaDataKey), (FailureType)MetaDataFailureType.ERROR_METADATA_RETRIEVER, (Throwable)e);
        }
    }

    private String getMetaDataException(MetaDataKey key) {
        if (key != null && key.getId() != null) {
            return "There was an error retrieving metadata from key: " + key.getId() + " after acquiring the connection, for more detailed information please read the provided stacktrace";
        }
        return "There was an error retrieving metadata after acquiring the connection, MetaDataKey is null or its id is null, for more detailed information please read the provided stacktrace";
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.checkMuleLicense();
    }

    private void checkMuleLicense() {
        try {
            LicenseManager licenseManager = LicenseManagementFactory.getInstance().createLicenseManager("mule-ee");
            EnterpriseLicenseKey license = licenseManager.validate("mule-ee");
            Calendar expirationDate = Calendar.getInstance();
            if (license.getExpirationDate() != null) {
                expirationDate.setTime(license.getExpirationDate());
                if (expirationDate.after(new Date())) {
                    throw new RuntimeException("Your license has expire");
                }
            }
        }
        catch (LicenseKeyException _x) {
            throw new RuntimeException("This Module requires an Enterprise license");
        }
    }
}

