/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.edi;

import com.anypoint.df.edi.schema.EdiSchema;
import com.anypoint.df.edi.schema.EdiSchemaVersion;
import com.anypoint.df.edi.schema.YamlReader;
import com.mulesoft.api.b2b.B2BProvider;
import com.mulesoft.api.b2b.B2BProviderException;
import com.mulesoft.api.b2b.Direction;
import com.mulesoft.api.b2b.config.QueryObject;
import com.mulesoft.api.b2b.factory.Factory;
import com.mulesoft.api.b2b.transmission.Transmission;
import com.mulesoft.api.b2b.transmission.TransmissionContext;
import com.mulesoft.api.b2b.transmission.TransmissionSession;
import com.mulesoft.api.b2b.transmission.TransmissionType;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.util.lock.LockFactory;
import scala.collection.Map;
import scala.collection.convert.WrapAsJava$;

public abstract class BaseEdiModule {
    protected static final String B2B_TRANSMISSION_SESSION_FLOW_VARIABLE_KEY = "b2bTransmissionSession";
    private static final long LOCK_WAIT_SECONDS = 15L;
    protected B2BProvider b2bProvider;
    protected Factory<QueryObject> queryObjectFactory;
    protected Factory<Transmission> transmissionFactory;
    private EdiSchema combinedSchema;
    private ObjectStore counterObjectStore;
    private LockFactory lockFactory;
    private java.util.Map<String, EdiSchema.Structure> loadedSchemas = new ConcurrentHashMap<String, EdiSchema.Structure>();

    public synchronized void setCounterObjectStore(ObjectStore<? extends Serializable> counterObjectStore) {
        this.counterObjectStore = counterObjectStore;
    }

    public abstract List<String> getSchemas();

    protected abstract MuleRegistry getRegistry();

    public EdiSchema getCombinedSchema() {
        return this.combinedSchema;
    }

    protected void doStart() {
        MuleContext context = (MuleContext)this.getRegistry().lookupObject("_muleContext");
        this.lockFactory = context.getLockFactory();
        if (this.counterObjectStore == null) {
            this.counterObjectStore = (ObjectStore)this.getRegistry().lookupObject("_defaultUserObjectStore");
            if (this.counterObjectStore == null) {
                throw new IllegalArgumentException("Unable to acquire an object store.");
            }
        }
    }

    protected String nonnull(Serializable s1, String s2) {
        if (s1 != null) {
            return s1.toString();
        }
        return s2;
    }

    protected boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected void setNullDefault(String key, String dflt, java.util.Map<String, Object> map) {
        if (map.get(key) == null && !this.isEmpty(dflt)) {
            map.put(key, dflt);
        }
    }

    protected String validateIdProperty(String text, int minl, int maxl, String name) {
        int length = text.length();
        if (length < minl - 1) {
            throw new IllegalArgumentException("Value '" + text + "' too short for " + name);
        }
        if (length > maxl) {
            throw new IllegalArgumentException("Value '" + text + "' too long for " + name);
        }
        for (int i = 0; i < length; ++i) {
            char chr = text.charAt(i);
            if (chr >= 'A' && chr <= 'Z' || chr >= 'a' && chr <= 'z' || chr >= '0' && chr <= '9') continue;
            throw new IllegalArgumentException("Character '" + chr + "' not allowed in id value " + name);
        }
        return text;
    }

    protected Character validateSeparator(Character separator, String name) {
        char chr = separator.charValue();
        if (Character.isAlphabetic(chr) || Character.isDigit(chr)) {
            throw new IllegalArgumentException("Invalid separator or substitution character " + chr + " for " + name);
        }
        return separator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Integer getNextInteger(String key, int initial) {
        Lock lock = this.lockFactory.createLock(key);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to increment number " + key);
            try {
                Integer count;
                if (this.counterObjectStore.contains((Serializable)((Object)key))) {
                    count = (Integer)this.counterObjectStore.retrieve((Serializable)((Object)key));
                    count = count + 1;
                    this.counterObjectStore.remove((Serializable)((Object)key));
                } else {
                    count = initial;
                }
                this.counterObjectStore.store((Serializable)((Object)key), (Serializable)count);
                Integer n = count;
                return n;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Could not increment number " + key, e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to increment number " + key);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Long getNextLong(String key, long initial) {
        Lock lock = this.lockFactory.createLock(key);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to increment number " + key);
            try {
                Long count;
                if (this.counterObjectStore.contains((Serializable)((Object)key))) {
                    count = (Long)this.counterObjectStore.retrieve((Serializable)((Object)key));
                    count = count + 1L;
                    this.counterObjectStore.remove((Serializable)((Object)key));
                } else {
                    count = initial;
                }
                this.counterObjectStore.store((Serializable)((Object)key), (Serializable)count);
                Long l = count;
                return l;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Could not increment number " + key, e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to increment number " + key);
        }
    }

    protected String incrementString(String value, int maxlen) {
        char ch;
        int split;
        for (split = value.length(); split > 0 && (ch = value.charAt(split - 1)) >= '0' && ch <= '9'; --split) {
        }
        long seq = split < value.length() ? Long.parseLong(value.substring(split)) : 0L;
        String suffix = Long.toString(seq + 1L);
        int excess = split + suffix.length() - maxlen;
        if (excess > 0) {
            if (excess >= suffix.length()) {
                throw new RuntimeException("Unable to increment string already at maximum length");
            }
            suffix = suffix.substring(excess);
        }
        return value.substring(0, split) + suffix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getNextString(String key, String initial, int maxlen) {
        Lock lock = this.lockFactory.createLock(key);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to update identifier " + key);
            try {
                String value;
                if (this.counterObjectStore.contains((Serializable)((Object)key))) {
                    value = this.incrementString(this.counterObjectStore.retrieve((Serializable)((Object)key)).toString(), maxlen);
                    this.counterObjectStore.remove((Serializable)((Object)key));
                } else {
                    value = initial;
                }
                this.counterObjectStore.store((Serializable)((Object)key), (Serializable)((Object)value));
                String string = value;
                return string;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Could not update identifier " + key, e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to update identifier " + key);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cacheIdentifier(String ident) {
        Lock lock = this.lockFactory.createLock(ident);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to cache identifier " + ident);
            try {
                if (this.counterObjectStore.contains((Serializable)((Object)ident))) {
                    boolean bl = false;
                    return bl;
                }
                this.counterObjectStore.store((Serializable)((Object)ident), (Serializable)((Object)""));
                boolean bl = true;
                return bl;
            }
            catch (ObjectStoreException e) {
                throw new RuntimeException("Could not cache identifier " + ident, e);
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to cache identifier " + ident);
        }
    }

    private static String schemaPath(String type, String version, String ident) {
        return File.separator + type.toLowerCase() + File.separator + version.toLowerCase() + File.separator + ident + ".esl";
    }

    private static EdiSchema mergeAcks(List<EdiSchema.Structure> acks, EdiSchema merged) {
        if (acks != null) {
            for (EdiSchema.Structure struct : acks) {
                merged = merged.merge(struct);
            }
        }
        return merged;
    }

    protected void loadSchemas(List<EdiSchema.Structure> acks, EdiSchemaVersion dfltVersion) {
        EdiSchema merged = null;
        List<String> schemas = this.getSchemas();
        if (schemas == null || schemas.isEmpty()) {
            merged = new EdiSchema(dfltVersion);
        } else {
            YamlReader yamlrdr = new YamlReader();
            for (String path : schemas) {
                try {
                    InputStream is = yamlrdr.findSchema(path, new String[]{""});
                    EdiSchema schema = yamlrdr.loadYaml((Reader)new InputStreamReader(is), new String[0]);
                    java.util.Map map = WrapAsJava$.MODULE$.mapAsJavaMap((Map)schema.structures());
                    for (String ident : map.keySet()) {
                        EdiSchemaVersion version = schema.ediVersion();
                        String key = BaseEdiModule.schemaPath(version.ediForm().text(), version.version(), ident);
                        this.loadedSchemas.put(key, (EdiSchema.Structure)map.get(ident));
                    }
                    if (merged == null) {
                        merged = schema;
                    } else if (merged.ediVersion().equals((Object)schema.ediVersion())) {
                        merged = merged.merge(schema);
                    } else {
                        throw new IllegalArgumentException("Configured schema version conflict (" + merged.ediVersion().version() + " vs. " + schema.ediVersion().version() + ")");
                    }
                    merged = merged == null ? schema : merged.merge(schema);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not load schema " + path, e);
                }
            }
        }
        this.combinedSchema = merged = BaseEdiModule.mergeAcks(acks, merged);
    }

    protected EdiSchema.Structure getSchema(String type, String version, String ident) {
        String path = File.separator + type.toLowerCase() + File.separator + version.toLowerCase() + File.separator + ident + ".esl";
        EdiSchema.Structure structure = this.loadedSchemas.get(path);
        if (structure == null) {
            try {
                YamlReader yamlrdr = new YamlReader();
                InputStream is = yamlrdr.findSchema(path, new String[]{""});
                EdiSchema schema = yamlrdr.loadYaml((Reader)new InputStreamReader(is), new String[0]);
                structure = (EdiSchema.Structure)schema.structures().apply((Object)ident);
                this.loadedSchemas.put(path, structure);
                return structure;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load schema " + ident + " from path " + path, e);
            }
        }
        return structure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadB2BProvider() throws Exception {
        if (this.b2bProvider == null) {
            BaseEdiModule baseEdiModule = this;
            synchronized (baseEdiModule) {
                try {
                    this.b2bProvider = (B2BProvider)this.getRegistry().lookupObject(B2BProvider.class);
                    if (this.b2bProvider == null) {
                        throw new Exception("Could not find B2B Provider. Configure B2B Connector to register an implementation of B2B Provider.");
                    }
                    this.queryObjectFactory = this.b2bProvider.getFactoryResolver().getFactory(QueryObject.class);
                    this.transmissionFactory = this.b2bProvider.getFactoryResolver().getFactory(Transmission.class);
                }
                catch (Exception e) {
                    throw new Exception("An error occurred while trying to read from registered B2B Provider", e);
                }
            }
        }
    }

    protected TransmissionSession trackTransmission(B2BProvider b2bProvider, MuleEvent muleEvent, Direction direction, Transmission transmission, TransmissionType transmissionType) throws B2BProviderException {
        TransmissionSession transmissionSession = (TransmissionSession)muleEvent.getMessage().getInvocationProperty(B2B_TRANSMISSION_SESSION_FLOW_VARIABLE_KEY);
        Factory transmissionContextFactory = b2bProvider.getFactoryResolver().getFactory(TransmissionContext.class);
        TransmissionContext transmissionContext = (TransmissionContext)transmissionContextFactory.create();
        transmissionContext.setMuleEventId(muleEvent.getId());
        transmissionContext.setTransmissionSession(transmissionSession);
        return b2bProvider.writeTransmission(direction, transmission, transmissionContext, transmissionType);
    }

    protected TransmissionSession trackInboundTransmission(MuleEvent muleEvent, byte[] payload, java.util.Map<String, Object> parsedContent, TransmissionType transmissionType) throws B2BProviderException {
        Transmission transmission = (Transmission)this.transmissionFactory.create();
        String filename = (String)muleEvent.getMessage().getInboundProperty("originalFilename");
        if (filename != null) {
            transmission.put((Object)"filename", (Object)filename);
        }
        transmission.put((Object)"content", (Object)payload);
        transmission.put((Object)"edi", parsedContent);
        return this.trackTransmission(this.b2bProvider, muleEvent, Direction.INBOUND, transmission, transmissionType);
    }

    public static enum SegmentWhitespace {
        NONE(""),
        LF("\n"),
        LFCR("\r\n"),
        CR("\r");

        public final String whitespace;

        private SegmentWhitespace(String ws) {
            this.whitespace = ws;
        }
    }
}

