
package org.mule.module.cmis.processors;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.cmis.CMISCloudConnector;
import org.mule.module.cmis.VersioningState;
import org.mule.module.cmis.adapters.CMISCloudConnectorProcessAdapter;


/**
 * CreateDocumentByIdFromContentMessageProcessor invokes the {@link org.mule.module.cmis.CMISCloudConnector#createDocumentByIdFromContent(java.lang.String, java.lang.String, java.lang.Object, java.lang.String, org.mule.module.cmis.VersioningState, java.lang.String, java.util.Map)} method in {@link CMISCloudConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-02-20T11:29:47-03:00", comments = "Build UNNAMED.1372.db235f3")
public class CreateDocumentByIdFromContentMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object folderId;
    protected String _folderIdType;
    protected Object filename;
    protected String _filenameType;
    protected Object content;
    protected Object _contentType;
    protected Object mimeType;
    protected String _mimeTypeType;
    protected Object versioningState;
    protected VersioningState _versioningStateType;
    protected Object objectType;
    protected String _objectTypeType;
    protected Object properties;
    protected Map<String, String> _propertiesType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets content
     * 
     * @param value Value to set
     */
    public void setContent(Object value) {
        this.content = value;
    }

    /**
     * Sets versioningState
     * 
     * @param value Value to set
     */
    public void setVersioningState(Object value) {
        this.versioningState = value;
    }

    /**
     * Sets filename
     * 
     * @param value Value to set
     */
    public void setFilename(Object value) {
        this.filename = value;
    }

    /**
     * Sets properties
     * 
     * @param value Value to set
     */
    public void setProperties(Object value) {
        this.properties = value;
    }

    /**
     * Sets objectType
     * 
     * @param value Value to set
     */
    public void setObjectType(Object value) {
        this.objectType = value;
    }

    /**
     * Sets mimeType
     * 
     * @param value Value to set
     */
    public void setMimeType(Object value) {
        this.mimeType = value;
    }

    /**
     * Sets folderId
     * 
     * @param value Value to set
     */
    public void setFolderId(Object value) {
        this.folderId = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(CMISCloudConnectorProcessAdapter.class, false, event);
            final String _transformedFolderId = ((String) evaluateAndTransform(getMuleContext(), event, CreateDocumentByIdFromContentMessageProcessor.class.getDeclaredField("_folderIdType").getGenericType(), null, folderId));
            final String _transformedFilename = ((String) evaluateAndTransform(getMuleContext(), event, CreateDocumentByIdFromContentMessageProcessor.class.getDeclaredField("_filenameType").getGenericType(), null, filename));
            final Object _transformedContent = ((Object) evaluateAndTransform(getMuleContext(), event, CreateDocumentByIdFromContentMessageProcessor.class.getDeclaredField("_contentType").getGenericType(), null, content));
            final String _transformedMimeType = ((String) evaluateAndTransform(getMuleContext(), event, CreateDocumentByIdFromContentMessageProcessor.class.getDeclaredField("_mimeTypeType").getGenericType(), null, mimeType));
            final VersioningState _transformedVersioningState = ((VersioningState) evaluateAndTransform(getMuleContext(), event, CreateDocumentByIdFromContentMessageProcessor.class.getDeclaredField("_versioningStateType").getGenericType(), null, versioningState));
            final String _transformedObjectType = ((String) evaluateAndTransform(getMuleContext(), event, CreateDocumentByIdFromContentMessageProcessor.class.getDeclaredField("_objectTypeType").getGenericType(), null, objectType));
            final Map<String, String> _transformedProperties = ((Map<String, String> ) evaluateAndTransform(getMuleContext(), event, CreateDocumentByIdFromContentMessageProcessor.class.getDeclaredField("_propertiesType").getGenericType(), null, properties));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((CMISCloudConnector) object).createDocumentByIdFromContent(_transformedFolderId, _transformedFilename, _transformedContent, _transformedMimeType, _transformedVersioningState, _transformedObjectType, _transformedProperties);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("createDocumentByIdFromContent"), event, e);
        }
    }

}
