
package org.mule.module.cmis.processors;

import java.util.List;
import javax.annotation.Generated;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.process.ProcessAdapter;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessTemplate;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.cmis.CMISCloudConnector;
import org.mule.module.cmis.NavigationOptions;
import org.mule.module.cmis.adapters.CMISCloudConnectorProcessAdapter;


/**
 * FolderMessageProcessor invokes the {@link org.mule.module.cmis.CMISCloudConnector#folder(org.apache.chemistry.opencmis.client.api.Folder, java.lang.String, org.mule.module.cmis.NavigationOptions, java.lang.Integer, java.lang.String, java.lang.String)} method in {@link CMISCloudConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.3.2", date = "2013-02-20T11:29:47-03:00", comments = "Build UNNAMED.1372.db235f3")
public class FolderMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object folder;
    protected Folder _folderType;
    protected Object folderId;
    protected String _folderIdType;
    protected Object get;
    protected NavigationOptions _getType;
    protected Object depth;
    protected Integer _depthType;
    protected Object filter;
    protected String _filterType;
    protected Object orderBy;
    protected String _orderByType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets folder
     * 
     * @param value Value to set
     */
    public void setFolder(Object value) {
        this.folder = value;
    }

    /**
     * Sets orderBy
     * 
     * @param value Value to set
     */
    public void setOrderBy(Object value) {
        this.orderBy = value;
    }

    /**
     * Sets get
     * 
     * @param value Value to set
     */
    public void setGet(Object value) {
        this.get = value;
    }

    /**
     * Sets filter
     * 
     * @param value Value to set
     */
    public void setFilter(Object value) {
        this.filter = value;
    }

    /**
     * Sets depth
     * 
     * @param value Value to set
     */
    public void setDepth(Object value) {
        this.depth = value;
    }

    /**
     * Sets folderId
     * 
     * @param value Value to set
     */
    public void setFolderId(Object value) {
        this.folderId = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(CMISCloudConnectorProcessAdapter.class, false, event);
            final Folder _transformedFolder = ((Folder) evaluateAndTransform(getMuleContext(), event, FolderMessageProcessor.class.getDeclaredField("_folderType").getGenericType(), null, folder));
            final String _transformedFolderId = ((String) evaluateAndTransform(getMuleContext(), event, FolderMessageProcessor.class.getDeclaredField("_folderIdType").getGenericType(), null, folderId));
            final NavigationOptions _transformedGet = ((NavigationOptions) evaluateAndTransform(getMuleContext(), event, FolderMessageProcessor.class.getDeclaredField("_getType").getGenericType(), null, get));
            final Integer _transformedDepth = ((Integer) evaluateAndTransform(getMuleContext(), event, FolderMessageProcessor.class.getDeclaredField("_depthType").getGenericType(), null, depth));
            final String _transformedFilter = ((String) evaluateAndTransform(getMuleContext(), event, FolderMessageProcessor.class.getDeclaredField("_filterType").getGenericType(), null, filter));
            final String _transformedOrderBy = ((String) evaluateAndTransform(getMuleContext(), event, FolderMessageProcessor.class.getDeclaredField("_orderByType").getGenericType(), null, orderBy));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((CMISCloudConnector) object).folder(_transformedFolder, _transformedFolderId, _transformedGet, _transformedDepth, _transformedFilter, _transformedOrderBy);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("folder"), event, e);
        }
    }

}
