
package org.mule.module.cmis.processors;

import java.util.List;
import javax.annotation.Generated;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.cmis.CMISCloudConnector;
import org.mule.module.cmis.adapters.CMISCloudConnectorProcessAdapter;
import org.mule.module.cmis.process.ProcessAdapter;
import org.mule.module.cmis.process.ProcessCallback;
import org.mule.module.cmis.process.ProcessTemplate;


/**
 * ApplyAclMessageProcessor invokes the {@link org.mule.module.cmis.CMISCloudConnector#applyAcl(org.apache.chemistry.opencmis.client.api.CmisObject, java.lang.String, java.util.List, java.util.List, org.apache.chemistry.opencmis.commons.enums.AclPropagation)} method in {@link CMISCloudConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@Generated(value = "Mule DevKit Version 3.4.0", date = "2013-04-08T02:05:47-03:00", comments = "Build 3.4.0.1555.8df15c1")
public class ApplyAclMessageProcessor
    extends AbstractMessageProcessor<Object>
    implements Disposable, Initialisable, Startable, Stoppable, MessageProcessor
{

    protected Object cmisObject;
    protected CmisObject _cmisObjectType;
    protected Object objectId;
    protected String _objectIdType;
    protected Object addAces;
    protected List<Ace> _addAcesType;
    protected Object removeAces;
    protected List<Ace> _removeAcesType;
    protected Object aclPropagation;
    protected AclPropagation _aclPropagationType;

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    public void start()
        throws MuleException
    {
    }

    public void stop()
        throws MuleException
    {
    }

    public void dispose() {
    }

    /**
     * Set the Mule context
     * 
     * @param context Mule context to set
     */
    public void setMuleContext(MuleContext context) {
        super.setMuleContext(context);
    }

    /**
     * Sets flow construct
     * 
     * @param flowConstruct Flow construct to set
     */
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        super.setFlowConstruct(flowConstruct);
    }

    /**
     * Sets addAces
     * 
     * @param value Value to set
     */
    public void setAddAces(Object value) {
        this.addAces = value;
    }

    /**
     * Sets aclPropagation
     * 
     * @param value Value to set
     */
    public void setAclPropagation(Object value) {
        this.aclPropagation = value;
    }

    /**
     * Sets objectId
     * 
     * @param value Value to set
     */
    public void setObjectId(Object value) {
        this.objectId = value;
    }

    /**
     * Sets cmisObject
     * 
     * @param value Value to set
     */
    public void setCmisObject(Object value) {
        this.cmisObject = value;
    }

    /**
     * Sets removeAces
     * 
     * @param value Value to set
     */
    public void setRemoveAces(Object value) {
        this.removeAces = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws MuleException
     */
    public MuleEvent process(final MuleEvent event)
        throws MuleException
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(CMISCloudConnectorProcessAdapter.class, false, event);
            final CmisObject _transformedCmisObject = ((CmisObject) evaluateAndTransform(getMuleContext(), event, ApplyAclMessageProcessor.class.getDeclaredField("_cmisObjectType").getGenericType(), null, cmisObject));
            final String _transformedObjectId = ((String) evaluateAndTransform(getMuleContext(), event, ApplyAclMessageProcessor.class.getDeclaredField("_objectIdType").getGenericType(), null, objectId));
            final List<Ace> _transformedAddAces = ((List<Ace> ) evaluateAndTransform(getMuleContext(), event, ApplyAclMessageProcessor.class.getDeclaredField("_addAcesType").getGenericType(), null, addAces));
            final List<Ace> _transformedRemoveAces = ((List<Ace> ) evaluateAndTransform(getMuleContext(), event, ApplyAclMessageProcessor.class.getDeclaredField("_removeAcesType").getGenericType(), null, removeAces));
            final AclPropagation _transformedAclPropagation = ((AclPropagation) evaluateAndTransform(getMuleContext(), event, ApplyAclMessageProcessor.class.getDeclaredField("_aclPropagationType").getGenericType(), null, aclPropagation));
            Object resultPayload;
            ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((CMISCloudConnector) object).applyAcl(_transformedCmisObject, _transformedObjectId, _transformedAddAces, _transformedRemoveAces, _transformedAclPropagation);
                }

            }
            , this, event);
            overwritePayload(event, resultPayload);
            return event;
        } catch (MessagingException messagingException) {
            messagingException.setProcessedEvent(event);
            throw messagingException;
        } catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToInvoke("applyAcl"), event, e);
        }
    }

}
