/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cmis;

import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.mule.api.ConnectionException;
import org.mule.module.cmis.CMISConnectionType;
import org.mule.module.cmis.CMISFacade;
import org.mule.module.cmis.CMISFacadeAdaptor;
import org.mule.module.cmis.ChemistryCMISFacade;
import org.mule.module.cmis.NavigationOptions;
import org.mule.module.cmis.VersioningState;

public class CMISCloudConnector
implements CMISFacade {
    private CMISFacade facade;
    private String connectionIdentifier;
    private Object threadSafeLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String username, String password, String baseUrl, String repositoryId, String endpoint, String connectionTimeout, String useAlfrescoExtension, String cxfPortProvider) throws ConnectionException {
        Object object = this.threadSafeLock;
        synchronized (object) {
            if (this.facade == null) {
                boolean useAtomPub;
                if (endpoint == null) {
                    useAtomPub = true;
                } else if (CMISConnectionType.valueOf(endpoint) == CMISConnectionType.SOAP) {
                    useAtomPub = false;
                } else if (CMISConnectionType.valueOf(endpoint) == CMISConnectionType.ATOM) {
                    useAtomPub = true;
                } else {
                    throw new IllegalStateException("unknown endpoint type " + endpoint + ". Please use SOAP or ATOMPUB");
                }
                this.setConnectionIdentifier(username + "@" + baseUrl);
                this.facade = CMISFacadeAdaptor.adapt(new ChemistryCMISFacade(username, password, repositoryId, baseUrl, useAtomPub, connectionTimeout, useAlfrescoExtension, cxfPortProvider));
                this.repositoryInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.threadSafeLock;
        synchronized (object) {
            this.facade = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.threadSafeLock;
        synchronized (object) {
            return this.facade != null;
        }
    }

    public String getConnectionIdentifier() {
        return this.connectionIdentifier;
    }

    @Override
    public List<Repository> repositories() {
        return this.facade.repositories();
    }

    @Override
    public RepositoryInfo repositoryInfo() {
        return this.facade.repositoryInfo();
    }

    @Override
    public ChangeEvents changelog(String changeLogToken, boolean includeProperties) {
        return this.facade.changelog(changeLogToken, includeProperties);
    }

    @Override
    public CmisObject getObjectById(String objectId) {
        return this.facade.getObjectById(objectId);
    }

    @Override
    public CmisObject getObjectByPath(String path) {
        return this.facade.getObjectByPath(path);
    }

    @Override
    public ObjectId createDocumentByPath(String folderPath, String filename, Object content, String mimeType, VersioningState versioningState, String objectType, Map<String, String> properties, boolean force) {
        return this.facade.createDocumentByPath(folderPath, filename, content, mimeType, versioningState, objectType, properties, force);
    }

    @Override
    public ObjectId createDocumentByPathFromContent(String folderPath, String filename, Object content, String mimeType, VersioningState versioningState, String objectType, Map<String, String> properties, boolean force) {
        return this.facade.createDocumentByPathFromContent(folderPath, filename, content, mimeType, versioningState, objectType, properties, force);
    }

    @Override
    public CmisObject getOrCreateFolderByPath(String folderPath) {
        return this.facade.getOrCreateFolderByPath(folderPath);
    }

    @Override
    public ObjectId createDocumentById(String folderId, String filename, Object content, String mimeType, VersioningState versioningState, String objectType, Map<String, String> properties) {
        return this.facade.createDocumentById(folderId, filename, content, mimeType, versioningState, objectType, properties);
    }

    @Override
    public ObjectId createDocumentByIdFromContent(String folderId, String filename, Object content, String mimeType, VersioningState versioningState, String objectType, Map<String, String> properties) {
        return this.facade.createDocumentByIdFromContent(folderId, filename, content, mimeType, versioningState, objectType, properties);
    }

    @Override
    public ObjectId createFolder(String folderName, String parentObjectId) {
        return this.facade.createFolder(folderName, parentObjectId);
    }

    @Override
    public ObjectType getTypeDefinition(String typeId) {
        return this.facade.getTypeDefinition(typeId);
    }

    @Override
    public ItemIterable<Document> getCheckoutDocs(String filter, String orderBy) {
        return this.facade.getCheckoutDocs(filter, orderBy);
    }

    @Override
    public ItemIterable<QueryResult> query(String statement, Boolean searchAllVersions, String filter, String orderBy) {
        return this.facade.query(statement, searchAllVersions, filter, orderBy);
    }

    @Override
    public List<Folder> getParentFolders(CmisObject cmisObject, String objectId) {
        return this.facade.getParentFolders(cmisObject, objectId);
    }

    @Override
    public Object folder(Folder folder, String folderId, NavigationOptions get, Integer depth, String filter, String orderBy) {
        return this.facade.folder(folder, folderId, get, depth, filter, orderBy);
    }

    @Override
    public ContentStream getContentStream(CmisObject cmisObject, String objectId) {
        return this.facade.getContentStream(cmisObject, objectId);
    }

    @Override
    public FileableCmisObject moveObject(FileableCmisObject cmisObject, String objectId, String sourceFolderId, String targetFolderId) {
        return this.facade.moveObject(cmisObject, objectId, sourceFolderId, targetFolderId);
    }

    @Override
    public CmisObject updateObjectProperties(CmisObject cmisObject, String objectId, Map<String, String> properties) {
        return this.facade.updateObjectProperties(cmisObject, objectId, properties);
    }

    @Override
    public List<Relationship> getObjectRelationships(CmisObject cmisObject, String objectId) {
        return this.facade.getObjectRelationships(cmisObject, objectId);
    }

    @Override
    public Acl getAcl(CmisObject cmisObject, String objectId) {
        return this.facade.getAcl(cmisObject, objectId);
    }

    @Override
    public List<Document> getAllVersions(CmisObject document, String documentId, String filter, String orderBy) {
        return this.facade.getAllVersions(document, documentId, filter, orderBy);
    }

    @Override
    public ObjectId checkOut(CmisObject document, String documentId) {
        return this.facade.checkOut(document, documentId);
    }

    @Override
    public void cancelCheckOut(CmisObject document, String documentId) {
        this.facade.cancelCheckOut(document, documentId);
    }

    @Override
    public ObjectId checkIn(CmisObject document, String documentId, Object content, String filename, String mimeType, boolean major, String checkinComment, Map<String, String> properties) {
        return this.facade.checkIn(document, documentId, content, filename, mimeType, major, checkinComment, properties);
    }

    @Override
    public Acl applyAcl(CmisObject cmisObject, String objectId, List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        return this.facade.applyAcl(cmisObject, objectId, addAces, removeAces, aclPropagation);
    }

    @Override
    public List<Policy> getAppliedPolicies(CmisObject cmisObject, String objectId) {
        return this.facade.getAppliedPolicies(cmisObject, objectId);
    }

    @Override
    public void applyPolicy(CmisObject cmisObject, String objectId, List<ObjectId> policyIds) {
        this.facade.applyPolicy(cmisObject, objectId, policyIds);
    }

    @Override
    public void delete(CmisObject cmisObject, String objectId, boolean allVersions) {
        this.facade.delete(cmisObject, objectId, allVersions);
    }

    @Override
    public List<String> deleteTree(CmisObject folder, String folderId, boolean allversions, UnfileObject unfile, boolean continueOnFailure) {
        return this.facade.deleteTree(folder, folderId, allversions, unfile, continueOnFailure);
    }

    @Override
    public void applyAspect(String objectId, String aspectName, Map<String, String> properties) {
        this.facade.applyAspect(objectId, aspectName, properties);
    }

    @Override
    public ObjectId createRelationship(String parentObjectId, String childObjectId, String relationshipType) {
        return this.facade.createRelationship(parentObjectId, childObjectId, relationshipType);
    }

    public CMISFacade getFacade() {
        return this.facade;
    }

    public void setFacade(CMISFacade facade) {
        this.facade = facade;
    }

    public void setConnectionIdentifier(String connectionIdentifier) {
        this.connectionIdentifier = connectionIdentifier;
    }
}

