/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cmis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mule.module.cmis.CMISConnectorException;
import org.mule.module.cmis.CMISFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMISFacadeAdaptor {
    private static Logger LOGGER = LoggerFactory.getLogger(CMISFacadeAdaptor.class);

    public static CMISFacade adapt(CMISFacade facade) {
        return (CMISFacade)Proxy.newProxyInstance(CMISFacadeAdaptor.class.getClassLoader(), new Class[]{CMISFacade.class}, (InvocationHandler)new MyInvocationHandler(facade));
    }

    private static class MyInvocationHandler
    implements InvocationHandler {
        private final CMISFacade facade;

        private MyInvocationHandler(CMISFacade facade) {
            this.facade = facade;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Invoked method {0} with arguments {1}", (Object)method.getName(), (Object)args);
            }
            try {
                Object ret = method.invoke((Object)this.facade, args);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Returned method {0} with value {1}", ret);
                }
                return ret;
            }
            catch (InvocationTargetException e) {
                Throwable cause;
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Method " + method.getName() + " thew " + e.getClass(), (Throwable)e);
                }
                if ((cause = e.getCause()) instanceof RuntimeException) {
                    throw e.getCause();
                }
                throw new CMISConnectorException(cause);
            }
        }
    }
}

