/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cmis;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.cmis.client.AlfrescoDocument;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.ChangeEventsImpl;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.mule.module.cmis.CMISFacade;
import org.mule.module.cmis.NavigationOptions;
import org.mule.module.cmis.VersioningState;

public class ChemistryCMISFacade
implements CMISFacade {
    public static Logger log = Logger.getLogger(ChemistryCMISFacade.class);
    private Session session;
    private Map<String, String> connectionParameters;
    private String baseURL = null;

    public ChemistryCMISFacade(String username, String password, String repositoryId, String baseURL, boolean useAtomPub, String connectionTimeout, String useAlfrescoExtension, String cxfPortProvider) {
        this.baseURL = baseURL;
        this.connectionParameters = ChemistryCMISFacade.paramMap(username, password, repositoryId, baseURL, useAtomPub, connectionTimeout, useAlfrescoExtension, cxfPortProvider);
    }

    @Override
    public List<Repository> repositories() {
        return SessionFactoryImpl.newInstance().getRepositories(this.connectionParameters);
    }

    @Override
    public RepositoryInfo repositoryInfo() {
        RepositoryInfo repoInfo = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            repoInfo = session.getRepositoryInfo();
        }
        return repoInfo;
    }

    @Override
    public ChangeEvents changelog(String changeLogToken, boolean includeProperties) {
        boolean hasMore = false;
        String token = changeLogToken;
        ChangeEventsImpl returnEvents = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            ArrayList changeEvents = new ArrayList();
            long totalNumItems = 0L;
            do {
                String t;
                ChangeEvents events = session.getContentChanges(token, includeProperties, 50L);
                totalNumItems += events.getTotalNumItems();
                changeEvents.addAll(events.getChangeEvents());
                if (!events.getHasMoreItems() || (t = events.getLatestChangeLogToken()) == null || t.equals(token)) continue;
                hasMore = true;
                token = t;
            } while (hasMore);
            returnEvents = new ChangeEventsImpl(token, changeEvents, false, totalNumItems);
        }
        return returnEvents;
    }

    @Override
    public CmisObject getObjectById(String objectId) {
        CmisObject returnObj = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            returnObj = session.getObject(session.createObjectId(objectId), ChemistryCMISFacade.createOperationContext(null, null));
        }
        return returnObj;
    }

    @Override
    public CmisObject getObjectByPath(String path) {
        CmisObject returnObj = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            returnObj = session.getObjectByPath(path, ChemistryCMISFacade.createOperationContext(null, null));
        }
        return returnObj;
    }

    @Override
    public ObjectId createDocumentById(String objectId, String filename, Object content, String mimeType, VersioningState versioningState, String objectType, Map<String, String> properties) {
        ObjectId returnId = null;
        if (content == null) {
            log.error((Object)"No document content was specified in the payload.");
            return null;
        }
        if (filename == null) {
            log.error((Object)"No filename was specified in the request.");
            return null;
        }
        if (mimeType == null) {
            log.error((Object)"No file mime type was specified in the request.");
            return null;
        }
        if (objectType == null) {
            log.error((Object)"No object type was specified in the request.");
            return null;
        }
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            Validate.notEmpty((String)objectId, (String)"objectId is empty");
            log.debug((Object)("Preparing to create a document with file name \"" + filename + "\" in the folder with ID \"" + objectId + "\"."));
            returnId = this.createDocument(session.getObject(session.createObjectId(objectId)), filename, content, mimeType, versioningState, objectType, properties);
            log.debug((Object)("The ID of the repository node after document creation is \"" + returnId.getId() + "\"."));
        }
        return returnId;
    }

    @Override
    public ObjectId createDocumentByIdFromContent(String objectId, String filename, Object content, String mimeType, VersioningState versioningState, String objectType, Map<String, String> properties) {
        ObjectId returnId = null;
        if (content == null) {
            log.error((Object)"No document content was specified in the payload.");
            return null;
        }
        if (filename == null) {
            log.error((Object)"No filename was specified in the request.");
            return null;
        }
        if (mimeType == null) {
            log.error((Object)"No file mime type was specified in the request.");
            return null;
        }
        if (objectType == null) {
            log.error((Object)"No object type was specified in the request.");
            return null;
        }
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            Validate.notEmpty((String)objectId, (String)"objectId is empty");
            log.debug((Object)("Preparing to create a document with file name \"" + filename + "\" in the folder with ID \"" + objectId + "\"."));
            returnId = this.createDocument(session.getObject(session.createObjectId(objectId)), filename, content, mimeType, versioningState, objectType, properties);
            log.debug((Object)("The ID of the repository node after document creation is \"" + returnId.getId() + "\"."));
        }
        return returnId;
    }

    @Override
    public ObjectId createDocumentByPath(String folderPath, String filename, Object content, String mimeType, VersioningState versioningState, String objectType, Map<String, String> properties, boolean force) {
        ObjectId returnId = null;
        if (content == null) {
            log.error((Object)"No document content was specified in the payload.");
            return null;
        }
        if (filename == null) {
            log.error((Object)"No filename was specified in the request.");
            return null;
        }
        if (mimeType == null) {
            log.error((Object)"No file mime type was specified in the request.");
            return null;
        }
        if (objectType == null) {
            log.error((Object)"No object type was specified in the request.");
            return null;
        }
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            Validate.notEmpty((String)folderPath, (String)"folderPath is empty");
            log.debug((Object)("Preparing to create a document with file name \"" + filename + "\" in folder \"" + folderPath + "\"."));
            returnId = this.createDocument(force ? this.getOrCreateFolderByPath(folderPath) : session.getObjectByPath(folderPath), filename, content, mimeType, versioningState, objectType, properties);
            log.debug((Object)("The ID of the repository node after document creation is \"" + returnId.getId() + "\"."));
        }
        return returnId;
    }

    @Override
    public ObjectId createDocumentByPathFromContent(String folderPath, String filename, Object content, String mimeType, VersioningState versioningState, String objectType, Map<String, String> properties, boolean force) {
        ObjectId returnId = null;
        if (content == null) {
            log.error((Object)"No document content was specified in the payload.");
            return null;
        }
        if (filename == null) {
            log.error((Object)"No filename was specified in the request.");
            return null;
        }
        if (mimeType == null) {
            log.error((Object)"No file mime type was specified in the request.");
            return null;
        }
        if (objectType == null) {
            log.error((Object)"No object type was specified in the request.");
            return null;
        }
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            Validate.notEmpty((String)folderPath, (String)"folderPath is empty");
            log.debug((Object)("Preparing to create a document with file name \"" + filename + "\" in folder \"" + folderPath + "\"."));
            returnId = this.createDocument(force ? this.getOrCreateFolderByPath(folderPath) : session.getObjectByPath(folderPath), filename, content, mimeType, versioningState, objectType, properties);
            log.debug((Object)("The ID of the repository node after document creation is \"" + returnId.getId() + "\"."));
        }
        return returnId;
    }

    @Override
    public CmisObject getOrCreateFolderByPath(String folderPath) {
        CmisObject returnObj = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            Validate.notEmpty((String)folderPath, (String)"folderPath is empty");
            try {
                returnObj = session.getObjectByPath(folderPath);
            }
            catch (CmisObjectNotFoundException e) {
                return this.createFolderStructure(folderPath);
            }
        }
        return returnObj;
    }

    private CmisObject createFolderStructure(String folderPath) {
        String[] folderNames = StringUtils.split((String)folderPath, (String)"/");
        String currentObjectId = this.getObjectByPath("/").getId();
        String currentPath = "/";
        for (String folder : folderNames) {
            currentPath = currentPath + folder + "/";
            CmisObject currentObject = null;
            try {
                currentObject = this.getObjectByPath(currentPath);
            }
            catch (CmisObjectNotFoundException ex) {
                log.debug((Object)("Path not found: " + currentPath));
            }
            currentObjectId = currentObject != null ? currentObject.getId() : this.createFolder(folder, currentObjectId).getId();
        }
        return this.getObjectById(currentObjectId);
    }

    protected ObjectId createDocument(CmisObject folder, String filename, Object content, String mimeType, VersioningState versioningState, String objectType, Map<String, String> extraProperties) {
        ObjectId returnId = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            Validate.notNull((Object)folder, (String)"folder is null");
            Validate.notEmpty((String)filename, (String)"filename is empty");
            Validate.notNull((Object)content, (String)"content is null");
            Validate.notEmpty((String)mimeType, (String)"did you mean application/octet-stream?");
            Validate.notNull((Object)((Object)versioningState), (String)"versionState is null");
            org.apache.chemistry.opencmis.commons.enums.VersioningState vs = null;
            try {
                vs = org.apache.chemistry.opencmis.commons.enums.VersioningState.valueOf((String)versioningState.name());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Illegal value for versioningState. Given `%s' could be: ", new Object[]{versioningState, Arrays.toString(org.apache.chemistry.opencmis.commons.enums.VersioningState.values())}), e);
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("cmis:objectTypeId", objectType);
            properties.put("cmis:name", filename);
            if (extraProperties != null) {
                properties.putAll(this.translateInboundProperties(extraProperties));
            }
            returnId = session.createDocument(properties, session.createObjectId(folder.getId()), ChemistryCMISFacade.createContentStream(filename, mimeType, content), vs);
        }
        return returnId;
    }

    public static ContentStream createContentStream(String filename, String mimeType, Object content) {
        ContentStreamImpl ret;
        if (content instanceof String) {
            ret = new ContentStreamImpl(filename, mimeType, (String)content);
        } else {
            ret = new ContentStreamImpl();
            ret.setFileName(filename);
            ret.setMimeType(mimeType);
            if (content instanceof InputStream) {
                ret.setStream((InputStream)content);
            } else if (content instanceof byte[]) {
                ret.setStream((InputStream)new ByteArrayInputStream((byte[])content));
            } else if (content instanceof Document) {
                ret = (ContentStreamImpl)((Document)content).getContentStream();
            } else {
                throw new IllegalArgumentException("The content must be one of the following: Document, InputStream or Byte array. The received type is not a valid one for generating a content stream: " + content.getClass());
            }
        }
        return ret;
    }

    @Override
    public ObjectId createFolder(String folderName, String parentObjectId) {
        ObjectId returnId = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("cmis:name", folderName);
            properties.put("cmis:objectTypeId", "cmis:folder");
            try {
                returnId = session.createFolder(properties, (ObjectId)session.getObject(session.createObjectId(parentObjectId)));
            }
            catch (CmisContentAlreadyExistsException e) {
                CmisObject object = session.getObject(session.createObjectId(parentObjectId));
                if (!(object instanceof Folder)) {
                    throw new IllegalArgumentException(parentObjectId + " is not a folder");
                }
                Folder folder = (Folder)object;
                for (CmisObject o : folder.getChildren()) {
                    if (!o.getName().equals(folderName)) continue;
                    return session.createObjectId(o.getId());
                }
            }
        }
        return returnId;
    }

    @Override
    public ObjectType getTypeDefinition(String typeId) {
        ObjectType returnTypeDef = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            Validate.notEmpty((String)typeId, (String)"typeId is empty");
            returnTypeDef = session.getTypeDefinition(typeId);
        }
        return returnTypeDef;
    }

    @Override
    public ItemIterable<Document> getCheckoutDocs(String filter, String orderBy) {
        ItemIterable docList = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            docList = session.getCheckedOutDocs(ChemistryCMISFacade.createOperationContext(filter, orderBy));
        }
        return docList;
    }

    @Override
    public ItemIterable<QueryResult> query(String statement, Boolean searchAllVersions, String filter, String orderBy) {
        ItemIterable resultList = null;
        Session session = this.getSession(this.connectionParameters);
        if (session != null) {
            Validate.notEmpty((String)statement, (String)"statement is empty");
            Validate.notNull((Object)searchAllVersions, (String)"searchAllVersions is empty");
            log.debug((Object)("Preparing to execute the CMIS query \"" + statement + "\"."));
            OperationContext ctx = ChemistryCMISFacade.createOperationContext(filter, orderBy);
            resultList = session.query(statement, searchAllVersions.booleanValue(), ctx);
            log.debug((Object)("The result list contains " + resultList.getTotalNumItems() + " items."));
            for (QueryResult currentResult : resultList) {
                log.debug((Object)("Object with ID \"" + currentResult.getPropertyByQueryName("cmis:objectId") + "\" is in the result set."));
            }
        }
        return resultList;
    }

    @Override
    public List<Folder> getParentFolders(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null && target instanceof FileableCmisObject) {
            return ((FileableCmisObject)target).getParents();
        }
        log.error((Object)"Unable to obtain the object reference, so no parent references could be obtained.");
        return null;
    }

    @Override
    public Object folder(Folder folder, String folderId, NavigationOptions get, Integer depth, String filter, String orderBy) {
        ChemistryCMISFacade.validateObjectOrId((CmisObject)folder, folderId);
        ChemistryCMISFacade.validateRedundantIdentifier((CmisObject)folder, folderId);
        Folder target = this.getCmisObject(folder, folderId, Folder.class);
        Object ret = null;
        if (target != null) {
            if (get.equals((Object)NavigationOptions.DESCENDANTS) || get.equals((Object)NavigationOptions.TREE)) {
                Validate.notNull((Object)depth, (String)"depth is null");
            }
            if (get.equals((Object)NavigationOptions.PARENT)) {
                ret = target.getFolderParent();
            } else {
                OperationContext ctx = ChemistryCMISFacade.createOperationContext(filter, orderBy);
                if (get.equals((Object)NavigationOptions.CHILDREN)) {
                    ret = target.getChildren(ctx);
                } else if (get.equals((Object)NavigationOptions.DESCENDANTS)) {
                    ret = target.getDescendants(depth.intValue(), ctx);
                } else if (get.equals((Object)NavigationOptions.TREE)) {
                    ret = target.getFolderTree(depth.intValue(), ctx);
                }
            }
        }
        return ret;
    }

    @Override
    public ContentStream getContentStream(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null && target instanceof Document) {
            return ((Document)target).getContentStream();
        }
        log.error((Object)"Unable to obtain the object reference in order to obtain the content of the object.");
        return null;
    }

    @Override
    public FileableCmisObject moveObject(FileableCmisObject cmisObject, String objectId, String sourceFolderId, String targetFolderId) {
        ChemistryCMISFacade.validateObjectOrId((CmisObject)cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier((CmisObject)cmisObject, objectId);
        Validate.notEmpty((String)sourceFolderId, (String)"sourceFolderId is empty");
        Validate.notEmpty((String)targetFolderId, (String)"targetFolderId is empty");
        FileableCmisObject target = this.getCmisObject(cmisObject, objectId, FileableCmisObject.class);
        if (target != null) {
            return target.move((ObjectId)new ObjectIdImpl(sourceFolderId), (ObjectId)new ObjectIdImpl(targetFolderId));
        }
        log.error((Object)"Unable to obtain the object reference in order to perform the object move.");
        return null;
    }

    @Override
    public CmisObject updateObjectProperties(CmisObject cmisObject, String objectId, Map<String, String> properties) {
        CmisObject returnObj = null;
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        Validate.notNull(properties, (String)"properties is null");
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            AlfrescoDocument alfDocument = (AlfrescoDocument)target;
            returnObj = alfDocument.updateProperties(this.translateInboundProperties(properties));
        } else {
            log.error((Object)"Unable to obtain the object reference in order to update the properties of the object.");
        }
        return returnObj;
    }

    @Override
    public void delete(CmisObject cmisObject, String objectId, boolean allVersions) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            target.delete(allVersions);
        }
    }

    @Override
    public List<String> deleteTree(CmisObject folder, String folderId, boolean allversions, UnfileObject unfile, boolean continueOnFailure) {
        ChemistryCMISFacade.validateObjectOrId(folder, folderId);
        ChemistryCMISFacade.validateRedundantIdentifier(folder, folderId);
        CmisObject target = this.getCmisObject(folder, folderId);
        if (target != null && target instanceof Folder) {
            return ((Folder)target).deleteTree(allversions, unfile, continueOnFailure);
        }
        return null;
    }

    @Override
    public List<Relationship> getObjectRelationships(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.getRelationships();
        }
        return null;
    }

    @Override
    public Acl getAcl(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.getAcl();
        }
        return null;
    }

    @Override
    public List<Document> getAllVersions(CmisObject document, String documentId, String filter, String orderBy) {
        ChemistryCMISFacade.validateObjectOrId(document, documentId);
        ChemistryCMISFacade.validateRedundantIdentifier(document, documentId);
        CmisObject target = this.getCmisObject(document, documentId);
        if (target instanceof Document) {
            OperationContext ctx = ChemistryCMISFacade.createOperationContext(filter, orderBy);
            return ((Document)target).getAllVersions(ctx);
        }
        return null;
    }

    @Override
    public ObjectId checkOut(CmisObject document, String documentId) {
        ChemistryCMISFacade.validateObjectOrId(document, documentId);
        ChemistryCMISFacade.validateRedundantIdentifier(document, documentId);
        CmisObject target = this.getCmisObject(document, documentId);
        if (target != null && target instanceof Document) {
            return ((Document)target).checkOut();
        }
        return null;
    }

    @Override
    public void cancelCheckOut(CmisObject document, String documentId) {
        ChemistryCMISFacade.validateObjectOrId(document, documentId);
        ChemistryCMISFacade.validateRedundantIdentifier(document, documentId);
        CmisObject target = this.getCmisObject(document, documentId);
        if (target != null && target instanceof Document) {
            ((Document)target).cancelCheckOut();
        }
    }

    @Override
    public ObjectId checkIn(CmisObject document, String documentId, Object content, String filename, String mimeType, boolean major, String checkinComment, Map<String, String> properties) {
        ChemistryCMISFacade.validateObjectOrId(document, documentId);
        ChemistryCMISFacade.validateRedundantIdentifier(document, documentId);
        Validate.notEmpty((String)filename, (String)"filename is empty");
        Validate.notNull((Object)content, (String)"content is null");
        Validate.notEmpty((String)mimeType, (String)"did you mean application/octet-stream?");
        Validate.notEmpty((String)checkinComment, (String)"checkinComment is empty");
        CmisObject target = this.getCmisObject(document, documentId);
        if (target != null && target instanceof Document) {
            Document doc = (Document)target;
            return doc.checkIn(major, this.coalesceProperties(properties), ChemistryCMISFacade.createContentStream(filename, mimeType, content), checkinComment);
        }
        return null;
    }

    private Map<String, String> coalesceProperties(Map<String, String> properties) {
        return properties != null ? properties : Collections.emptyMap();
    }

    @Override
    public Acl applyAcl(CmisObject cmisObject, String objectId, List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.applyAcl(addAces, removeAces, aclPropagation);
        }
        return null;
    }

    @Override
    public List<Policy> getAppliedPolicies(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.getPolicies();
        }
        return null;
    }

    @Override
    public void applyPolicy(CmisObject cmisObject, String objectId, List<ObjectId> policyIds) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        Validate.notNull(policyIds);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            target.applyPolicy(policyIds.toArray(new ObjectId[policyIds.size()]));
        }
    }

    @Override
    public void applyAspect(String objectId, String aspectName, Map<String, String> properties) {
        ChemistryCMISFacade.validateObjectOrId(null, objectId);
        CmisObject target = this.getCmisObject(null, objectId);
        AlfrescoDocument alfDocument = (AlfrescoDocument)target;
        if (alfDocument != null && !alfDocument.hasAspect("P:" + aspectName)) {
            alfDocument.addAspect(new String[]{"P:" + aspectName});
            if (properties != null) {
                alfDocument.updateProperties(this.translateInboundProperties(properties));
            }
        }
    }

    @Override
    public ObjectId createRelationship(String parentObjectId, String childObjectId, String relationshipType) {
        if (StringUtils.isEmpty((String)parentObjectId)) {
            log.error((Object)"No value was specified for the required attribute \"parentObjectId\". No relationship could be created.");
            return null;
        }
        if (StringUtils.isEmpty((String)childObjectId)) {
            log.error((Object)"No value was specified for the required attribute \"childObjectId\". No relationship could be created.");
            return null;
        }
        if (StringUtils.isEmpty((String)relationshipType)) {
            log.error((Object)"No value was specified for the required attribute \"relationshipType\". No relationship could be created.");
            return null;
        }
        Session session = this.getSession(this.connectionParameters);
        if (session == null) {
            log.error((Object)"Unable to obtain a repository session, so no relationship could be created.");
            return null;
        }
        try {
            CmisObject parentObj = this.getObjectById(parentObjectId);
            if (parentObj == null) {
                log.error((Object)("The parent object with ID \"" + parentObjectId + "\" doesn't exists in the repository. No relationship will be created."));
                return null;
            }
        }
        catch (Exception objEx) {
            log.error((Object)("An error occurred while attempting to determine if an the parent object with ID \"" + parentObjectId + "\" exists in the repository. " + objEx.getMessage()));
            return null;
        }
        try {
            CmisObject childObj = this.getObjectById(childObjectId);
            if (childObj == null) {
                log.error((Object)("The child object with ID \"" + childObjectId + "\" doesn't exists in the repository. No relationship will be created."));
                return null;
            }
        }
        catch (Exception objEx) {
            log.error((Object)("An error occurred while attempting to determine if an the child object with ID \"" + childObjectId + "\" exists in the repository. " + objEx.getMessage()));
            return null;
        }
        HashMap<String, String> relProps = new HashMap<String, String>();
        relProps.put("cmis:sourceId", parentObjectId);
        relProps.put("cmis:targetId", childObjectId);
        relProps.put("cmis:objectTypeId", "R:" + relationshipType);
        try {
            return session.createRelationship(relProps, null, null, null);
        }
        catch (Exception relEx) {
            log.error((Object)("An error occurred while attempting to create a relationship between the parent object with ID \"" + parentObjectId + "\" and the child object with ID \"" + childObjectId + "\". " + relEx.getMessage()));
            return null;
        }
    }

    private static void validateObjectOrId(CmisObject object, String objectId) {
        if (object == null && StringUtils.isBlank((String)objectId)) {
            throw new IllegalArgumentException("Both the cmis object and it's ID are not set");
        }
    }

    private static void validateRedundantIdentifier(CmisObject object, String objectId) {
        if (object != null && StringUtils.isNotBlank((String)objectId) && !object.getId().equals(objectId)) {
            throw new IllegalArgumentException("The id provided does not match the object's ID");
        }
    }

    private CmisObject getCmisObject(CmisObject object, String objectId) {
        return this.getCmisObject(object, objectId, CmisObject.class);
    }

    private <T> T getCmisObject(T object, String objectId, Class<T> clazz) {
        if (object != null) {
            return object;
        }
        CmisObject obj = this.getObjectById(objectId);
        if (obj != null && clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        return null;
    }

    private static OperationContext createOperationContext(String filter, String orderBy) {
        OperationContextImpl ctx = new OperationContextImpl();
        ctx.setIncludeAcls(true);
        ctx.setIncludePolicies(true);
        if (StringUtils.isNotBlank((String)filter) || StringUtils.isNotBlank((String)orderBy)) {
            if (StringUtils.isNotBlank((String)filter)) {
                ctx.setFilterString(filter);
            }
            if (StringUtils.isNotBlank((String)orderBy)) {
                ctx.setOrderBy(orderBy);
            }
        }
        return ctx;
    }

    private static Map<String, String> paramMap(String username, String password, String repositoryId, String baseURL, boolean useAtomPub, String connectionTimeout, String useAlfrescoExtension, String cxfPortProvider) {
        if (username == null || username.trim().length() <= 0) {
            log.error((Object)"The \"username\" attribute of the \"config\" element for the repository connector configuration is empty or missing. This configuration is required in order to provide repository connection parameters to the connector. The connector is currently non-functional.");
            return null;
        }
        if (password == null || password.trim().length() <= 0) {
            log.error((Object)"The \"password\" attribute of the \"config\" element for the repository connector configuration is empty or missing. This configuration is required in order to provide repository connection parameters to the connector. The connector is currently non-functional.");
            return null;
        }
        if (baseURL == null || baseURL.trim().length() <= 0) {
            log.error((Object)"The \"baseURL\" attribute of the \"config\" element for the repository connector configuration is empty or missing. This configuration is required in order to provide repository connection parameters to the connector. The connector is currently non-functional.");
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.user", username.trim());
        parameters.put("org.apache.chemistry.opencmis.password", password.trim());
        if (!useAtomPub) {
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", baseURL + "ACLService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", baseURL + "DiscoveryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", baseURL + "MultiFilingService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", baseURL + "NavigationService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", baseURL + "ObjectService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", baseURL + "PolicyService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", baseURL + "RelationshipService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", baseURL + "RepositoryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", baseURL + "VersioningService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.portprovider.classname", cxfPortProvider);
        } else {
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", baseURL.trim());
        }
        parameters.put("org.apache.chemistry.opencmis.locale.iso3166", "");
        parameters.put("org.apache.chemistry.opencmis.locale.iso639", "en");
        if (connectionTimeout != null) {
            parameters.put("org.apache.chemistry.opencmis.binding.connecttimeout", connectionTimeout);
        }
        if (repositoryId != null) {
            parameters.put("org.apache.chemistry.opencmis.session.repository.id", repositoryId.trim());
        } else {
            String repoID = ChemistryCMISFacade.getRepositoryID(parameters, baseURL);
            if (repoID != null) {
                parameters.put("org.apache.chemistry.opencmis.session.repository.id", repoID);
            }
        }
        if (Boolean.parseBoolean(useAlfrescoExtension.trim().toLowerCase())) {
            parameters.put("org.apache.chemistry.opencmis.objectfactory.classname", "org.alfresco.cmis.client.impl.AlfrescoObjectFactoryImpl");
            log.debug((Object)"The Alfresco Object Factor CMIS extension has been included in the session parameters.");
        }
        return parameters;
    }

    public static String getRepositoryID(Map<String, String> parameters, String baseURL) {
        String repoID = null;
        try {
            log.debug((Object)"Attempting to dynamically obtain the repository ID.");
            List repositoryList = SessionFactoryImpl.newInstance().getRepositories(parameters);
            if (repositoryList.size() <= 0) {
                log.error((Object)("No repositories were returned at the CMIS server URL \"" + baseURL + "\". " + "The connector is currently non-functional."));
            } else {
                Repository firstRepo = (Repository)repositoryList.get(0);
                repoID = firstRepo.getId();
                log.debug((Object)("The repository ID that will be used is " + repoID + "."));
            }
        }
        catch (Exception repoIDEx) {
            log.error((Object)("An error occurred while attempting to dynamically obtain a repository ID. The connector is currently non-functional. " + repoIDEx.getMessage()));
        }
        return repoID;
    }

    private Session getSession(Map<String, String> parameters) {
        Session repoSession = this.session;
        if (parameters == null) {
            log.error((Object)"Repository sessions cannot be obtained through the connector because the connector configuration is missing or incorrectly specified in the mule application configuration file.");
            return null;
        }
        if (parameters.get("org.apache.chemistry.opencmis.session.repository.id") == null) {
            String repoID = ChemistryCMISFacade.getRepositoryID(parameters, this.baseURL);
            if (repoID != null) {
                parameters.put("org.apache.chemistry.opencmis.session.repository.id", repoID);
            } else {
                log.error((Object)"Repository sessions cannot be obtained through the connector because the repository ID is missing from the connector configuration.");
            }
            return null;
        }
        if (repoSession == null) {
            Validate.notNull(parameters);
            try {
                this.session = repoSession = SessionFactoryImpl.newInstance().createSession(parameters);
            }
            catch (Exception sessionEx) {
                log.error((Object)("An error occurred while attempting to obtain a new repository session. " + sessionEx.getMessage()));
            }
        }
        return repoSession;
    }

    private Map<String, Object> translateInboundProperties(Map<String, String> inboundProperties) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (inboundProperties == null) {
            returnMap = null;
        } else if (inboundProperties.size() > 0) {
            for (String currentKey : inboundProperties.keySet()) {
                String currentVal = inboundProperties.get(currentKey);
                if (currentVal == null) continue;
                if (currentKey.toLowerCase().startsWith("m:")) {
                    String[] valArray = currentVal.split(",");
                    ArrayList<String> propArray = new ArrayList<String>(Arrays.asList(valArray));
                    returnMap.put(currentKey.substring(2), propArray);
                    continue;
                }
                returnMap.put(currentKey, currentVal);
            }
        }
        return returnMap;
    }
}

