/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cmis.process;

import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.module.cmis.adapters.CMISCloudConnectorConnectionIdentifierAdapter;
import org.mule.module.cmis.connection.ConnectionManager;
import org.mule.module.cmis.connection.UnableToAcquireConnectionException;
import org.mule.module.cmis.connection.UnableToReleaseConnectionException;
import org.mule.module.cmis.connectivity.CMISCloudConnectorConnectionKey;
import org.mule.module.cmis.process.ProcessCallback;
import org.mule.module.cmis.process.ProcessInterceptor;
import org.mule.module.cmis.processors.AbstractConnectedProcessor;
import org.mule.module.cmis.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, CMISCloudConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(ManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<CMISCloudConnectorConnectionKey, CMISCloudConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, CMISCloudConnectorConnectionIdentifierAdapter> next;

    public ManagedConnectionProcessInterceptor(ProcessInterceptor<T, CMISCloudConnectorConnectionIdentifierAdapter> next, ConnectionManager<CMISCloudConnectorConnectionKey, CMISCloudConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    @Override
    public T execute(ProcessCallback<T, CMISCloudConnectorConnectionIdentifierAdapter> processCallback, CMISCloudConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        String _transformedUsername;
        CMISCloudConnectorConnectionIdentifierAdapter connection = null;
        CMISCloudConnectorConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getUsername() != null) {
            _transformedUsername = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_usernameType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getUsername());
            if (_transformedUsername == null) {
                throw new UnableToAcquireConnectionException("Parameter username in method connect can't be null because is not @Optional");
            }
            String _transformedPassword = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_passwordType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getPassword());
            if (_transformedPassword == null) {
                throw new UnableToAcquireConnectionException("Parameter password in method connect can't be null because is not @Optional");
            }
            String _transformedBaseUrl = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_baseUrlType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getBaseUrl());
            if (_transformedBaseUrl == null) {
                throw new UnableToAcquireConnectionException("Parameter baseUrl in method connect can't be null because is not @Optional");
            }
            String _transformedRepositoryId = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_repositoryIdType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getRepositoryId());
            if (_transformedRepositoryId == null) {
                throw new UnableToAcquireConnectionException("Parameter repositoryId in method connect can't be null because is not @Optional");
            }
            String _transformedEndpoint = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_endpointType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getEndpoint());
            String _transformedConnectionTimeout = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_connectionTimeoutType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getConnectionTimeout());
            String _transformedUseAlfrescoExtension = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_useAlfrescoExtensionType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getUseAlfrescoExtension());
            String _transformedCxfPortProvider = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_cxfPortProviderType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getCxfPortProvider());
            key = new CMISCloudConnectorConnectionKey(_transformedUsername, _transformedPassword, _transformedBaseUrl, _transformedRepositoryId, _transformedEndpoint, _transformedConnectionTimeout, _transformedUseAlfrescoExtension, _transformedCxfPortProvider);
        } else {
            key = this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = this.connectionManager.acquireConnection(key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedUsername = this.next.execute(processCallback, connection, messageProcessor, event);
            return (T)_transformedUsername;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        this.connectionManager.destroyConnection(key, connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection(key, connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException(e);
            }
        }
    }

    @Override
    public T execute(ProcessCallback<T, CMISCloudConnectorConnectionIdentifierAdapter> processCallback, CMISCloudConnectorConnectionIdentifierAdapter object, Filter filter, MuleMessage message) throws Exception {
        throw new UnsupportedOperationException();
    }
}

