/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cmis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mule.module.cmis.CMISConnectorException;
import org.mule.module.cmis.CMISFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMISFacadeAdaptor {
    private static Logger logger = LoggerFactory.getLogger(CMISFacadeAdaptor.class);

    public static CMISFacade adapt(final CMISFacade facade) {
        return (CMISFacade)Proxy.newProxyInstance(CMISFacadeAdaptor.class.getClassLoader(), new Class[]{CMISFacade.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (logger.isDebugEnabled()) {
                    logger.debug("Invoked method {0} with arguments {1}", (Object)method.getName(), (Object)args);
                }
                try {
                    Object ret = method.invoke((Object)facade, args);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Returned method {0} with value {1}", ret);
                    }
                    return ret;
                }
                catch (InvocationTargetException e) {
                    Throwable cause;
                    if (logger.isWarnEnabled()) {
                        logger.warn("Method " + method.getName() + " thew " + e.getClass(), (Throwable)e);
                    }
                    if ((cause = e.getCause()) instanceof RuntimeException) {
                        throw e.getCause();
                    }
                    throw new CMISConnectorException(cause);
                }
            }
        });
    }
}

