/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cmis;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.ChangeEventsImpl;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.mule.module.cmis.CMISFacade;
import org.mule.module.cmis.NavigationOptions;
import org.mule.module.cmis.VersioningState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChemistryCMISFacade
implements CMISFacade {
    private final Session session;
    private final Map<String, String> connectionParameters;

    public ChemistryCMISFacade(String username, String password, String repositoryId, String baseURL, boolean useAtomPub) {
        this.connectionParameters = ChemistryCMISFacade.paramMap(username, password, repositoryId, baseURL, useAtomPub);
        this.session = ChemistryCMISFacade.createSession(this.connectionParameters);
    }

    @Override
    public List<Repository> repositories() {
        return SessionFactoryImpl.newInstance().getRepositories(this.connectionParameters);
    }

    @Override
    public RepositoryInfo repositoryInfo() {
        return this.session.getRepositoryInfo();
    }

    @Override
    public ChangeEvents changelog(String changeLogToken, boolean includeProperties) {
        boolean hasMore = false;
        String token = changeLogToken;
        ArrayList changeEvents = new ArrayList();
        long totalNumItems = 0L;
        do {
            String t;
            ChangeEvents events = this.session.getContentChanges(token, includeProperties, 50L);
            totalNumItems += events.getTotalNumItems();
            changeEvents.addAll(events.getChangeEvents());
            if (!events.getHasMoreItems() || (t = events.getLatestChangeLogToken()) == null || t.equals(token)) continue;
            hasMore = true;
            token = t;
        } while (hasMore);
        return new ChangeEventsImpl(token, changeEvents, false, totalNumItems);
    }

    @Override
    public CmisObject getObjectById(String objectId) {
        try {
            return this.session.getObject(this.session.createObjectId(objectId), ChemistryCMISFacade.createOperationContext(null, null));
        }
        catch (CmisObjectNotFoundException e) {
            return null;
        }
    }

    @Override
    public CmisObject getObjectByPath(String path) {
        try {
            return this.session.getObjectByPath(path, ChemistryCMISFacade.createOperationContext(null, null));
        }
        catch (CmisObjectNotFoundException e) {
            return null;
        }
        catch (CmisInvalidArgumentException e) {
            return null;
        }
    }

    @Override
    public ObjectId createDocumentById(String objectId, String filename, Object content, String mimeType, VersioningState versioningState, String objectType) {
        Validate.notEmpty((String)objectId, (String)"objectId is empty");
        return this.createDocument(this.session.getObject(this.session.createObjectId(objectId)), filename, content, mimeType, versioningState, objectType);
    }

    @Override
    public ObjectId createDocumentByPath(String folderPath, String filename, Object content, String mimeType, VersioningState versioningState, String objectType) {
        Validate.notEmpty((String)folderPath, (String)"folderPath is empty");
        return this.createDocument(this.session.getObjectByPath(folderPath), filename, content, mimeType, versioningState, objectType);
    }

    protected ObjectId createDocument(CmisObject folder, String filename, Object content, String mimeType, VersioningState versioningState, String objectType) {
        Validate.notNull((Object)folder, (String)"folder is null");
        Validate.notEmpty((String)filename, (String)"filename is empty");
        Validate.notNull((Object)content, (String)"content is null");
        Validate.notEmpty((String)mimeType, (String)"did you mean application/octet-stream?");
        Validate.notNull((Object)((Object)versioningState), (String)"versionState is null");
        org.apache.chemistry.opencmis.commons.enums.VersioningState vs = null;
        try {
            vs = org.apache.chemistry.opencmis.commons.enums.VersioningState.valueOf((String)versioningState.name());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Illegal value for versioningState. Given `%s' could be: ", new Object[]{versioningState, Arrays.toString(org.apache.chemistry.opencmis.commons.enums.VersioningState.values())}), e);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", objectType);
        properties.put("cmis:name", filename);
        return this.session.createDocument(properties, this.session.createObjectId(folder.getId()), ChemistryCMISFacade.createContentStream(filename, mimeType, content), vs);
    }

    public static ContentStream createContentStream(String filename, String mimeType, Object content) {
        ContentStreamImpl ret;
        if (content instanceof String) {
            ret = new ContentStreamImpl(filename, mimeType, (String)content);
        } else {
            ret = new ContentStreamImpl();
            ret.setFileName(filename);
            ret.setMimeType(mimeType);
            if (content instanceof InputStream) {
                ret.setStream((InputStream)content);
            } else if (content instanceof byte[]) {
                ret.setStream((InputStream)new ByteArrayInputStream((byte[])content));
            } else {
                throw new IllegalArgumentException("Don't know how to handle content of type" + content.getClass());
            }
        }
        return ret;
    }

    @Override
    public ObjectId createFolder(String folderName, String parentObjectId) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", folderName);
        properties.put("cmis:objectTypeId", "cmis:folder");
        try {
            return this.session.createFolder(properties, (ObjectId)this.session.getObject(this.session.createObjectId(parentObjectId)));
        }
        catch (CmisContentAlreadyExistsException e) {
            CmisObject object = this.session.getObject(this.session.createObjectId(parentObjectId));
            if (!(object instanceof Folder)) {
                throw new IllegalArgumentException(parentObjectId + " is not a folder");
            }
            Folder folder = (Folder)object;
            for (CmisObject o : folder.getChildren()) {
                if (!o.getName().equals(folderName)) continue;
                return this.session.createObjectId(o.getId());
            }
            return null;
        }
    }

    @Override
    public ObjectType getTypeDefinition(String typeId) {
        Validate.notEmpty((String)typeId, (String)"typeId is empty");
        return this.session.getTypeDefinition(typeId);
    }

    @Override
    public ItemIterable<Document> getCheckoutDocs(String filter, String orderBy) {
        return this.session.getCheckedOutDocs(ChemistryCMISFacade.createOperationContext(filter, orderBy));
    }

    @Override
    public ItemIterable<QueryResult> query(String statement, Boolean searchAllVersions, String filter, String orderBy) {
        Validate.notEmpty((String)statement, (String)"statement is empty");
        Validate.notNull((Object)searchAllVersions, (String)"searchAllVersions is empty");
        OperationContext ctx = ChemistryCMISFacade.createOperationContext(filter, orderBy);
        return this.session.query(statement, searchAllVersions.booleanValue(), ctx);
    }

    @Override
    public List<Folder> getParentFolders(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null && target instanceof FileableCmisObject) {
            return ((FileableCmisObject)target).getParents();
        }
        return null;
    }

    @Override
    public Object folder(Folder folder, String folderId, NavigationOptions get, Integer depth, String filter, String orderBy) {
        ChemistryCMISFacade.validateObjectOrId((CmisObject)folder, folderId);
        ChemistryCMISFacade.validateRedundantIdentifier((CmisObject)folder, folderId);
        Folder target = this.getCmisObject(folder, folderId, Folder.class);
        Object ret = null;
        if (target != null) {
            if (get.equals((Object)NavigationOptions.DESCENDANTS) || get.equals((Object)NavigationOptions.TREE)) {
                Validate.notNull((Object)depth, (String)"depth is null");
            }
            if (get.equals((Object)NavigationOptions.PARENT)) {
                ret = target.getFolderParent();
            } else {
                OperationContext ctx = ChemistryCMISFacade.createOperationContext(filter, orderBy);
                if (get.equals((Object)NavigationOptions.CHILDREN)) {
                    ret = target.getChildren(ctx);
                } else if (get.equals((Object)NavigationOptions.DESCENDANTS)) {
                    ret = target.getDescendants(depth.intValue(), ctx);
                } else if (get.equals((Object)NavigationOptions.TREE)) {
                    ret = target.getFolderTree(depth.intValue(), ctx);
                }
            }
        }
        return ret;
    }

    @Override
    public ContentStream getContentStream(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null && target instanceof Document) {
            return ((Document)target).getContentStream();
        }
        return null;
    }

    @Override
    public FileableCmisObject moveObject(FileableCmisObject cmisObject, String objectId, String sourceFolderId, String targetFolderId) {
        ChemistryCMISFacade.validateObjectOrId((CmisObject)cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier((CmisObject)cmisObject, objectId);
        Validate.notEmpty((String)sourceFolderId, (String)"sourceFolderId is empty");
        Validate.notEmpty((String)targetFolderId, (String)"targetFolderId is empty");
        FileableCmisObject target = this.getCmisObject(cmisObject, objectId, FileableCmisObject.class);
        if (target != null) {
            return target.move((ObjectId)new ObjectIdImpl(sourceFolderId), (ObjectId)new ObjectIdImpl(targetFolderId));
        }
        return null;
    }

    @Override
    public CmisObject updateObjectProperties(CmisObject cmisObject, String objectId, Map<String, Object> properties) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        Validate.notNull(properties, (String)"properties is null");
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.updateProperties(properties);
        }
        return null;
    }

    @Override
    public void delete(CmisObject cmisObject, String objectId, boolean allVersions) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            target.delete(allVersions);
        }
    }

    @Override
    public List<String> deleteTree(CmisObject folder, String folderId, boolean allversions, UnfileObject unfile, boolean continueOnFailure) {
        ChemistryCMISFacade.validateObjectOrId(folder, folderId);
        ChemistryCMISFacade.validateRedundantIdentifier(folder, folderId);
        CmisObject target = this.getCmisObject(folder, folderId);
        if (target != null && target instanceof Folder) {
            return ((Folder)target).deleteTree(allversions, unfile, continueOnFailure);
        }
        return null;
    }

    @Override
    public List<Relationship> getObjectRelationships(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.getRelationships();
        }
        return null;
    }

    @Override
    public Acl getAcl(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.getAcl();
        }
        return null;
    }

    @Override
    public List<Document> getAllVersions(CmisObject document, String documentId, String filter, String orderBy) {
        ChemistryCMISFacade.validateObjectOrId(document, documentId);
        ChemistryCMISFacade.validateRedundantIdentifier(document, documentId);
        CmisObject target = this.getCmisObject(document, documentId);
        if (target instanceof Document) {
            OperationContext ctx = ChemistryCMISFacade.createOperationContext(filter, orderBy);
            return ((Document)target).getAllVersions(ctx);
        }
        return null;
    }

    @Override
    public ObjectId checkOut(CmisObject document, String documentId) {
        ChemistryCMISFacade.validateObjectOrId(document, documentId);
        ChemistryCMISFacade.validateRedundantIdentifier(document, documentId);
        CmisObject target = this.getCmisObject(document, documentId);
        if (target != null && target instanceof Document) {
            return ((Document)target).checkOut();
        }
        return null;
    }

    @Override
    public void cancelCheckOut(CmisObject document, String documentId) {
        ChemistryCMISFacade.validateObjectOrId(document, documentId);
        ChemistryCMISFacade.validateRedundantIdentifier(document, documentId);
        CmisObject target = this.getCmisObject(document, documentId);
        if (target != null && target instanceof Document) {
            ((Document)target).cancelCheckOut();
        }
    }

    @Override
    public ObjectId checkIn(CmisObject document, String documentId, Object content, String filename, String mimeType, boolean major, String checkinComment) {
        ChemistryCMISFacade.validateObjectOrId(document, documentId);
        ChemistryCMISFacade.validateRedundantIdentifier(document, documentId);
        Validate.notEmpty((String)filename, (String)"filename is empty");
        Validate.notNull((Object)content, (String)"content is null");
        Validate.notEmpty((String)mimeType, (String)"did you mean application/octet-stream?");
        Validate.notEmpty((String)checkinComment, (String)"checkinComment is empty");
        CmisObject target = this.getCmisObject(document, documentId);
        if (target != null && target instanceof Document) {
            Document doc = (Document)target;
            return doc.checkIn(major, Collections.emptyMap(), ChemistryCMISFacade.createContentStream(filename, mimeType, content), checkinComment);
        }
        return null;
    }

    @Override
    public Acl applyAcl(CmisObject cmisObject, String objectId, List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.applyAcl(addAces, removeAces, aclPropagation);
        }
        return null;
    }

    @Override
    public List<Policy> getAppliedPolicies(CmisObject cmisObject, String objectId) {
        ChemistryCMISFacade.validateObjectOrId(cmisObject, objectId);
        ChemistryCMISFacade.validateRedundantIdentifier(cmisObject, objectId);
        CmisObject target = this.getCmisObject(cmisObject, objectId);
        if (target != null) {
            return target.getPolicies();
        }
        return null;
    }

    private static void validateObjectOrId(CmisObject object, String objectId) {
        if (object == null && StringUtils.isBlank((String)objectId)) {
            throw new IllegalArgumentException("Both the cmis object and it's ID are not set");
        }
    }

    private static void validateRedundantIdentifier(CmisObject object, String objectId) {
        if (object != null && StringUtils.isNotBlank((String)objectId) && !object.getId().equals(objectId)) {
            throw new IllegalArgumentException("The id provided does not match the object's ID");
        }
    }

    private CmisObject getCmisObject(CmisObject object, String objectId) {
        return this.getCmisObject(object, objectId, CmisObject.class);
    }

    private <T> T getCmisObject(T object, String objectId, Class<T> clazz) {
        if (object != null) {
            return object;
        }
        CmisObject obj = this.getObjectById(objectId);
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        return null;
    }

    private static OperationContext createOperationContext(String filter, String orderBy) {
        OperationContextImpl ctx = new OperationContextImpl();
        ctx.setIncludeAcls(true);
        ctx.setIncludePolicies(true);
        if (StringUtils.isNotBlank((String)filter) || StringUtils.isNotBlank((String)orderBy)) {
            if (StringUtils.isNotBlank((String)filter)) {
                ctx.setFilterString(filter);
            }
            if (StringUtils.isNotBlank((String)orderBy)) {
                ctx.setOrderBy(orderBy);
            }
        }
        return ctx;
    }

    private static Map<String, String> paramMap(String username, String password, String repositoryId, String baseURL, boolean useAtomPub) {
        Validate.notEmpty((String)username, (String)"username is empty");
        Validate.notEmpty((String)password, (String)"password is empty");
        Validate.notEmpty((String)repositoryId, (String)"repository-id is empty");
        Validate.notEmpty((String)baseURL, (String)"base-url is empty");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.user", username);
        parameters.put("org.apache.chemistry.opencmis.password", password);
        if (!useAtomPub) {
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", baseURL + "ACLService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", baseURL + "DiscoveryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", baseURL + "MultiFilingService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", baseURL + "NavigationService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", baseURL + "ObjectService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", baseURL + "PolicyService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", baseURL + "RelationshipService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", baseURL + "RepositoryService?wsdl");
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", baseURL + "VersioningService?wsdl");
        } else {
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", baseURL);
        }
        parameters.put("org.apache.chemistry.opencmis.session.repository.id", repositoryId);
        parameters.put("org.apache.chemistry.opencmis.locale.iso3166", "");
        parameters.put("org.apache.chemistry.opencmis.locale.iso639", "en");
        return parameters;
    }

    private static Session createSession(Map<String, String> parameters) {
        Validate.notNull(parameters);
        return SessionFactoryImpl.newInstance().createSession(parameters);
    }
}

