
package org.mule.module.cmis.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.cmis.config.ApplyAclMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ApplyAclDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public ApplyAclDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ApplyAclMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("cmisObject-ref")!= null)&&(!StringUtils.isBlank(element.getAttribute("cmisObject-ref")))) {
            if (element.getAttribute("cmisObject-ref").startsWith("#")) {
                builder.addPropertyValue("cmisObject", element.getAttribute("cmisObject-ref"));
            } else {
                builder.addPropertyValue("cmisObject", (("#[registry:"+ element.getAttribute("cmisObject-ref"))+"]"));
            }
        }
        if ((element.getAttribute("objectId")!= null)&&(!StringUtils.isBlank(element.getAttribute("objectId")))) {
            builder.addPropertyValue("objectId", element.getAttribute("objectId"));
        }
        Element addAcesListElement = null;
        addAcesListElement = DomUtils.getChildElementByTagName(element, "add-aces");
        List<Element> addAcesListChilds = null;
        if (addAcesListElement!= null) {
            String addAcesRef = addAcesListElement.getAttribute("ref");
            if ((addAcesRef!= null)&&(!StringUtils.isBlank(addAcesRef))) {
                if ((!addAcesRef.startsWith(patternInfo.getPrefix()))&&(!addAcesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("addAces", new RuntimeBeanReference(addAcesRef));
                } else {
                    builder.addPropertyValue("addAces", addAcesRef);
                }
            } else {
                ManagedList addAces = new ManagedList();
                addAcesListChilds = DomUtils.getChildElementsByTagName(addAcesListElement, "add-ace");
                if (addAcesListChilds!= null) {
                    for (Element addAcesChild: addAcesListChilds) {
                        String valueRef = addAcesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            addAces.add(new RuntimeBeanReference(valueRef));
                        } else {
                            addAces.add(addAcesChild.getTextContent());
                        }
                    }
                }
                builder.addPropertyValue("addAces", addAces);
            }
        }
        Element removeAcesListElement = null;
        removeAcesListElement = DomUtils.getChildElementByTagName(element, "remove-aces");
        List<Element> removeAcesListChilds = null;
        if (removeAcesListElement!= null) {
            String removeAcesRef = removeAcesListElement.getAttribute("ref");
            if ((removeAcesRef!= null)&&(!StringUtils.isBlank(removeAcesRef))) {
                if ((!removeAcesRef.startsWith(patternInfo.getPrefix()))&&(!removeAcesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("removeAces", new RuntimeBeanReference(removeAcesRef));
                } else {
                    builder.addPropertyValue("removeAces", removeAcesRef);
                }
            } else {
                ManagedList removeAces = new ManagedList();
                removeAcesListChilds = DomUtils.getChildElementsByTagName(removeAcesListElement, "remove-ace");
                if (removeAcesListChilds!= null) {
                    for (Element removeAcesChild: removeAcesListChilds) {
                        String valueRef = removeAcesChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            removeAces.add(new RuntimeBeanReference(valueRef));
                        } else {
                            removeAces.add(removeAcesChild.getTextContent());
                        }
                    }
                }
                builder.addPropertyValue("removeAces", removeAces);
            }
        }
        if (element.hasAttribute("aclPropagation")) {
            builder.addPropertyValue("aclPropagation", element.getAttribute("aclPropagation"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                propertyValues.addPropertyValue("messageProcessors", new ManagedList());
            }
            List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
            listMessageProcessors.add(definition);
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
