
package org.mule.module.cmis.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.cmis.config.CreateDocumentByPathMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateDocumentByPathDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public CreateDocumentByPathDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CreateDocumentByPathMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("folderPath")!= null)&&(!StringUtils.isBlank(element.getAttribute("folderPath")))) {
            builder.addPropertyValue("folderPath", element.getAttribute("folderPath"));
        }
        if ((element.getAttribute("filename")!= null)&&(!StringUtils.isBlank(element.getAttribute("filename")))) {
            builder.addPropertyValue("filename", element.getAttribute("filename"));
        }
        if ((element.getAttribute("content-ref")!= null)&&(!StringUtils.isBlank(element.getAttribute("content-ref")))) {
            if (element.getAttribute("content-ref").startsWith("#")) {
                builder.addPropertyValue("content", element.getAttribute("content-ref"));
            } else {
                builder.addPropertyValue("content", (("#[registry:"+ element.getAttribute("content-ref"))+"]"));
            }
        }
        if ((element.getAttribute("mimeType")!= null)&&(!StringUtils.isBlank(element.getAttribute("mimeType")))) {
            builder.addPropertyValue("mimeType", element.getAttribute("mimeType"));
        }
        if (element.hasAttribute("versioningState")) {
            builder.addPropertyValue("versioningState", element.getAttribute("versioningState"));
        }
        if ((element.getAttribute("objectType")!= null)&&(!StringUtils.isBlank(element.getAttribute("objectType")))) {
            builder.addPropertyValue("objectType", element.getAttribute("objectType"));
        }
        Element propertiesListElement = null;
        propertiesListElement = DomUtils.getChildElementByTagName(element, "properties");
        List<Element> propertiesListChilds = null;
        if (propertiesListElement!= null) {
            String propertiesRef = propertiesListElement.getAttribute("ref");
            if ((propertiesRef!= null)&&(!StringUtils.isBlank(propertiesRef))) {
                if ((!propertiesRef.startsWith(patternInfo.getPrefix()))&&(!propertiesRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("properties", new RuntimeBeanReference(propertiesRef));
                } else {
                    builder.addPropertyValue("properties", propertiesRef);
                }
            } else {
                ManagedMap properties = new ManagedMap();
                propertiesListChilds = DomUtils.getChildElementsByTagName(propertiesListElement, "property");
                if (propertiesListChilds!= null) {
                    if (propertiesListChilds.size() == 0) {
                        propertiesListChilds = DomUtils.getChildElements(propertiesListElement);
                    }
                    for (Element propertiesChild: propertiesListChilds) {
                        String propertiesValueRef = propertiesChild.getAttribute("value-ref");
                        String propertiesKeyRef = propertiesChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((propertiesValueRef!= null)&&(!StringUtils.isBlank(propertiesValueRef))) {
                            valueObject = new RuntimeBeanReference(propertiesValueRef);
                        } else {
                            valueObject = propertiesChild.getTextContent();
                        }
                        if ((propertiesKeyRef!= null)&&(!StringUtils.isBlank(propertiesKeyRef))) {
                            keyObject = new RuntimeBeanReference(propertiesKeyRef);
                        } else {
                            keyObject = propertiesChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = propertiesChild.getTagName();
                        }
                        properties.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("properties", properties);
            }
        }
        if ((element.getAttribute("force")!= null)&&(!StringUtils.isBlank(element.getAttribute("force")))) {
            builder.addPropertyValue("force", element.getAttribute("force"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                propertyValues.addPropertyValue("messageProcessors", new ManagedList());
            }
            List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
            listMessageProcessors.add(definition);
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
