/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.cache.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.bindings.cache.Cache;
import org.apache.chemistry.opencmis.client.bindings.cache.CacheLevel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheImpl
implements Cache {
    private static Log log = LogFactory.getLog(CacheImpl.class);
    private static final long serialVersionUID = 1L;
    private List<Class<?>> fLevels;
    private List<Map<String, String>> fLevelParameters;
    private String fName;
    private CacheLevel fRoot;
    private final ReentrantReadWriteLock fLock = new ReentrantReadWriteLock();

    public CacheImpl() {
        this.fName = "Cache";
    }

    public CacheImpl(String name) {
        this.fName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(String[] cacheLevelConfig) {
        if (this.fLevels != null) {
            throw new IllegalStateException("Cache already initialize!");
        }
        if (cacheLevelConfig == null || cacheLevelConfig.length == 0) {
            throw new IllegalArgumentException("Cache config must not be empty!");
        }
        this.fLock.writeLock().lock();
        try {
            this.fLevels = new ArrayList();
            this.fLevelParameters = new ArrayList<Map<String, String>>();
            for (String config : cacheLevelConfig) {
                int x = config.indexOf(32);
                if (x == -1) {
                    this.addLevel(config, null);
                    continue;
                }
                this.addLevel(config.substring(0, x), config.substring(x + 1));
            }
            this.fRoot = this.createCacheLevel(0);
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    private void addLevel(String className, String parameters) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class '" + className + "' not found!", e);
        }
        if (!CacheLevel.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class '" + className + "' does not implement the CacheLevel interface!");
        }
        this.fLevels.add(clazz);
        if (parameters == null) {
            this.fLevelParameters.add(null);
        } else {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            this.fLevelParameters.add(parameterMap);
            for (String pair : parameters.split(",")) {
                String[] keyValue = pair.split("=");
                if (keyValue.length == 1) {
                    parameterMap.put(keyValue[0], "");
                    continue;
                }
                parameterMap.put(keyValue[0], keyValue[1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String ... keys) {
        if (keys == null) {
            return null;
        }
        if (this.fLevels.size() != keys.length) {
            throw new IllegalArgumentException("Wrong number of keys!");
        }
        Object result = null;
        this.fLock.readLock().lock();
        try {
            CacheLevel cacheLevel = this.fRoot;
            for (int i = 0; i < keys.length - 1; ++i) {
                Object level = cacheLevel.get(keys[i]);
                if (level == null) {
                    Object var6_6 = null;
                    return var6_6;
                }
                cacheLevel = (CacheLevel)level;
            }
            result = cacheLevel.get(keys[keys.length - 1]);
        }
        finally {
            this.fLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object value, String ... keys) {
        if (keys == null) {
            return;
        }
        if (this.fLevels.size() != keys.length) {
            throw new IllegalArgumentException("Wrong number of keys!");
        }
        this.fLock.writeLock().lock();
        try {
            CacheLevel cacheLevel = this.fRoot;
            for (int i = 0; i < keys.length - 1; ++i) {
                Object level = cacheLevel.get(keys[i]);
                if (level == null) {
                    level = this.createCacheLevel(i + 1);
                    cacheLevel.put(level, keys[i]);
                }
                cacheLevel = (CacheLevel)level;
            }
            cacheLevel.put(value, keys[keys.length - 1]);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.fName + ": put [" + this.getFormattedKeys(keys) + "] = " + value));
            }
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String ... keys) {
        if (keys == null) {
            return;
        }
        this.fLock.writeLock().lock();
        try {
            CacheLevel cacheLevel = this.fRoot;
            for (int i = 0; i < keys.length - 1; ++i) {
                Object level = cacheLevel.get(keys[i]);
                if (level == null) {
                    return;
                }
                cacheLevel = (CacheLevel)level;
            }
            cacheLevel.remove(keys[keys.length - 1]);
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.fName + ": removed [" + this.getFormattedKeys(keys) + "]"));
            }
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int check(String ... keys) {
        if (keys == null) {
            return -1;
        }
        this.fLock.readLock().lock();
        try {
            CacheLevel cacheLevel = this.fRoot;
            for (int i = 0; i < keys.length - 1; ++i) {
                Object level = cacheLevel.get(keys[i]);
                if (level == null) {
                    int n = i;
                    return n;
                }
                cacheLevel = (CacheLevel)level;
            }
        }
        finally {
            this.fLock.readLock().unlock();
        }
        return keys.length;
    }

    public void writeLock() {
        this.fLock.writeLock().lock();
    }

    public void writeUnlock() {
        this.fLock.writeLock().unlock();
    }

    private CacheLevel createCacheLevel(int level) {
        if (level < 0 || level >= this.fLevels.size()) {
            throw new IllegalArgumentException("Cache level doesn't fit the configuration!");
        }
        Class<?> clazz = this.fLevels.get(level);
        CacheLevel cacheLevel = null;
        try {
            cacheLevel = (CacheLevel)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cache level problem?!", e);
        }
        cacheLevel.initialize(this.fLevelParameters.get(level));
        return cacheLevel;
    }

    public String toString() {
        return this.fRoot == null ? "(no cache root)" : this.fRoot.toString();
    }

    private String getFormattedKeys(String[] keys) {
        StringBuilder sb = new StringBuilder();
        for (String k : keys) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(k);
        }
        return sb.toString();
    }
}

