/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.cache.Cache;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.CacheImpl;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.ContentTypeCacheLevelImpl;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.LruCacheLevelImpl;
import org.apache.chemistry.opencmis.client.bindings.cache.impl.MapCacheLevelImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int CACHE_SIZE_REPOSITORIES = 10;
    private static final int CACHE_SIZE_TYPES = 100;
    private static final int CACHE_SIZE_OBJECTS = 400;
    private Cache linkCache;
    private Cache typeLinkCache;
    private Cache collectionLinkCache;
    private Cache templateCache;
    private Cache repositoryLinkCache;

    public LinkCache(Session session) {
        int objCount;
        int typeCount;
        int repCount = session.get("org.apache.chemistry.opencmis.binding.cache.repositories.size", 10);
        if (repCount < 1) {
            repCount = 10;
        }
        if ((typeCount = session.get("org.apache.chemistry.opencmis.binding.cache.types.size", 100)) < 1) {
            typeCount = 100;
        }
        if ((objCount = session.get("org.apache.chemistry.opencmis.binding.cache.links.size", 400)) < 1) {
            objCount = 400;
        }
        this.linkCache = new CacheImpl("Link Cache");
        this.linkCache.initialize(new String[]{MapCacheLevelImpl.class.getName() + " " + "capacity" + "=" + repCount, LruCacheLevelImpl.class.getName() + " " + "maxEntries" + "=" + objCount, MapCacheLevelImpl.class.getName() + " " + "capacity" + "=16", ContentTypeCacheLevelImpl.class.getName() + " " + "capacity" + "=3," + "singleValue" + "=true"});
        this.typeLinkCache = new CacheImpl("Type Link Cache");
        this.typeLinkCache.initialize(new String[]{MapCacheLevelImpl.class.getName() + " " + "capacity" + "=" + repCount, LruCacheLevelImpl.class.getName() + " " + "maxEntries" + "=" + typeCount, MapCacheLevelImpl.class.getName() + " " + "capacity" + "=16", ContentTypeCacheLevelImpl.class.getName() + " " + "capacity" + "=3," + "singleValue" + "=true"});
        this.collectionLinkCache = new CacheImpl("Collection Link Cache");
        this.collectionLinkCache.initialize(new String[]{MapCacheLevelImpl.class.getName() + " " + "capacity" + "=" + repCount, MapCacheLevelImpl.class.getName() + " " + "capacity" + "=8"});
        this.templateCache = new CacheImpl("URI Template Cache");
        this.templateCache.initialize(new String[]{MapCacheLevelImpl.class.getName() + " " + "capacity" + "=" + repCount, MapCacheLevelImpl.class.getName() + " " + "capacity" + "=6"});
        this.repositoryLinkCache = new CacheImpl("Repository Link Cache");
        this.repositoryLinkCache.initialize(new String[]{MapCacheLevelImpl.class.getName() + " " + "capacity" + "=" + repCount, MapCacheLevelImpl.class.getName() + " " + "capacity" + "=6"});
    }

    public void addLink(String repositoryId, String id, String rel, String type, String link) {
        this.linkCache.put(link, repositoryId, id, rel, type);
    }

    public void removeLinks(String repositoryId, String id) {
        this.linkCache.remove(repositoryId, id);
    }

    public String getLink(String repositoryId, String id, String rel, String type) {
        return (String)this.linkCache.get(repositoryId, id, rel, type);
    }

    public String getLink(String repositoryId, String id, String rel) {
        return this.getLink(repositoryId, id, rel, null);
    }

    public int checkLink(String repositoryId, String id, String rel, String type) {
        return this.linkCache.check(repositoryId, id, rel, type);
    }

    public void lockLinks() {
        this.linkCache.writeLock();
    }

    public void unlockLinks() {
        this.linkCache.writeUnlock();
    }

    public void addTypeLink(String repositoryId, String id, String rel, String type, String link) {
        this.typeLinkCache.put(link, repositoryId, id, rel, type);
    }

    public void removeTypeLinks(String repositoryId, String id) {
        this.typeLinkCache.remove(repositoryId, id);
    }

    public String getTypeLink(String repositoryId, String id, String rel, String type) {
        return (String)this.typeLinkCache.get(repositoryId, id, rel, type);
    }

    public void lockTypeLinks() {
        this.typeLinkCache.writeLock();
    }

    public void unlockTypeLinks() {
        this.typeLinkCache.writeUnlock();
    }

    public void addCollection(String repositoryId, String collection, String link) {
        this.collectionLinkCache.put(link, repositoryId, collection);
    }

    public String getCollection(String repositoryId, String collection) {
        return (String)this.collectionLinkCache.get(repositoryId, collection);
    }

    public void addTemplate(String repositoryId, String type, String link) {
        this.templateCache.put(link, repositoryId, type);
    }

    public String getTemplateLink(String repositoryId, String type, Map<String, Object> parameters) {
        String template = (String)this.templateCache.get(repositoryId, type);
        if (template == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        StringBuilder param = new StringBuilder();
        boolean paramMode = false;
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (paramMode) {
                if (c == '}') {
                    paramMode = false;
                    String paramValue = UrlBuilder.normalizeParameter((Object)parameters.get(param.toString()));
                    if (paramValue != null) {
                        try {
                            result.append(URLEncoder.encode(paramValue, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            result.append(paramValue);
                        }
                    }
                    param = new StringBuilder();
                    continue;
                }
                param.append(c);
                continue;
            }
            if (c == '{') {
                paramMode = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public void addRepositoryLink(String repositoryId, String rel, String link) {
        this.repositoryLinkCache.put(link, repositoryId, rel);
    }

    public String getRepositoryLink(String repositoryId, String rel) {
        return (String)this.repositoryLinkCache.get(repositoryId, rel);
    }

    public void clearRepository(String repositoryId) {
        this.linkCache.remove(repositoryId);
        this.typeLinkCache.remove(repositoryId);
        this.collectionLinkCache.remove(repositoryId);
        this.templateCache.remove(repositoryId);
        this.repositoryLinkCache.remove(repositoryId);
    }

    public String toString() {
        return "Link Cache [link cache=" + this.linkCache + ", type link cache=" + this.typeLinkCache + ", collection link cache=" + this.collectionLinkCache + ", repository link cache=" + this.repositoryLinkCache + ",  template cache=" + this.templateCache + "]";
    }
}

