/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.OutputStream;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AtomEntryWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.HttpUtils;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.MultiFilingService;

public class MultiFilingServiceImpl
extends AbstractAtomPubService
implements MultiFilingService {
    public MultiFilingServiceImpl(Session session) {
        this.setSession(session);
    }

    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        if (objectId == null) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        String link = this.loadLink(repositoryId, folderId, "down", "application/atom+xml;type=feed");
        if (link == null) {
            this.throwLinkException(repositoryId, folderId, "down", "application/atom+xml;type=feed");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("allVersions", (Object)allVersions);
        final AtomEntryWriter entryWriter = new AtomEntryWriter(this.createIdObject(objectId));
        this.post(url, "application/atom+xml;type=entry", new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                entryWriter.write(out);
            }
        });
    }

    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        if (objectId == null) {
            throw new CmisInvalidArgumentException("Object id must be set!");
        }
        String link = this.loadCollection(repositoryId, "unfiled");
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or unfiling not supported!");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("removeFrom", (Object)folderId);
        final AtomEntryWriter entryWriter = new AtomEntryWriter(this.createIdObject(objectId));
        this.post(url, "application/atom+xml;type=entry", new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                entryWriter.write(out);
            }
        });
    }
}

