/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.ws.developer.WSBindingProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ACLService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DiscoveryService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.MultiFilingService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.NavigationService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.PolicyService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RelationshipService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryService;
import org.apache.chemistry.opencmis.commons.impl.jaxb.RepositoryServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class PortProvider
extends AbstractPortProvider {
    private static Log log = LogFactory.getLog(PortProvider.class);
    private boolean useCompression;
    private String acceptLanguage;

    public PortProvider(Session session) {
        this.session = session;
        this.useCompression = false;
        if (session.get("org.apache.chemistry.opencmis.binding.compression") instanceof String && Boolean.parseBoolean((String)session.get("org.apache.chemistry.opencmis.binding.compression"))) {
            this.useCompression = true;
        }
        if (session.get("org.apache.chemistry.opencmis.binding.compression") instanceof Boolean && ((Boolean)session.get("org.apache.chemistry.opencmis.binding.compression")).booleanValue()) {
            this.useCompression = true;
        }
        if (session.get("org.apache.chemistry.opencmis.locale.iso639") instanceof String) {
            String language = (String)session.get("org.apache.chemistry.opencmis.locale.iso639");
            String country = "";
            if (session.get("org.apache.chemistry.opencmis.locale.iso3166") instanceof String) {
                country = "-" + (String)session.get("org.apache.chemistry.opencmis.locale.iso3166");
            }
            this.acceptLanguage = language + country;
            if (this.acceptLanguage.indexOf(10) > -1 || this.acceptLanguage.indexOf(13) > -1) {
                this.acceptLanguage = null;
            }
        }
    }

    protected Object createPortObject(Service service) {
        RepositoryServicePort portObject = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating Web Service port object of " + (service == null ? "???" : service.getServiceName()) + "..."));
        }
        try {
            if (service instanceof RepositoryService) {
                portObject = ((RepositoryService)service).getRepositoryServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof NavigationService) {
                portObject = ((NavigationService)service).getNavigationServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof ObjectService) {
                int threshold = 0x400000;
                try {
                    threshold = Integer.parseInt((String)this.session.get("org.apache.chemistry.opencmis.binding.webservices.memoryThreshold"));
                }
                catch (Exception e) {
                    // empty catch block
                }
                portObject = ((ObjectService)service).getObjectServicePort(new WebServiceFeature[]{new MTOMFeature(), new StreamingAttachmentFeature(null, true, (long)threshold)});
                ((BindingProvider)portObject).getRequestContext().put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", 65536);
            } else if (service instanceof VersioningService) {
                portObject = ((VersioningService)service).getVersioningServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof DiscoveryService) {
                portObject = ((DiscoveryService)service).getDiscoveryServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof MultiFilingService) {
                portObject = ((MultiFilingService)service).getMultiFilingServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof RelationshipService) {
                portObject = ((RelationshipService)service).getRelationshipServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof PolicyService) {
                portObject = ((PolicyService)service).getPolicyServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else if (service instanceof ACLService) {
                portObject = ((ACLService)service).getACLServicePort(new WebServiceFeature[]{new MTOMFeature()});
            } else {
                throw new CmisRuntimeException("Cannot find Web Services service object!");
            }
            AbstractAuthenticationProvider authProvider = CmisBindingsHelper.getAuthenticationProvider(this.session);
            Map<String, List<String>> httpHeaders = null;
            if (authProvider != null) {
                Element soapHeader = authProvider.getSOAPHeaders(portObject);
                if (soapHeader != null) {
                    ((WSBindingProvider)portObject).setOutboundHeaders(new Header[]{Headers.create((Element)soapHeader)});
                }
                httpHeaders = authProvider.getHTTPHeaders(service.getWSDLDocumentLocation().toString());
            }
            if (this.useCompression) {
                if (httpHeaders == null) {
                    httpHeaders = new HashMap<String, List<String>>();
                }
                httpHeaders.put("Accept-Encoding", Collections.singletonList("gzip"));
            }
            if (this.acceptLanguage != null) {
                if (httpHeaders == null) {
                    httpHeaders = new HashMap();
                }
                httpHeaders.put("Accept-Language", Collections.singletonList(this.acceptLanguage));
            }
            if (httpHeaders != null) {
                ((BindingProvider)portObject).getRequestContext().put("javax.xml.ws.http.request.headers", httpHeaders);
            }
        }
        catch (CmisBaseException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot initalize Web Services port object: " + e.getMessage(), (Throwable)e);
        }
        return portObject;
    }
}

