/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.TransientDocument;
import org.apache.chemistry.opencmis.client.runtime.AbstractTransientCmisObject;
import org.apache.chemistry.opencmis.client.runtime.AbstractTransientFileableCmisObject;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.spi.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientDocumentImpl
extends AbstractTransientFileableCmisObject
implements TransientDocument {
    private static final long serialVersionUID = 1L;
    private ContentStream contentStream;
    private boolean contentOverwrite;
    private boolean deleteContent;

    @Override
    protected void initialize(Session session, CmisObject object) {
        super.initialize(session, object);
        this.contentStream = null;
        this.contentOverwrite = false;
        this.deleteContent = false;
    }

    public void deleteAllVersions() {
        this.delete(true);
    }

    public ContentStream getContentStream() {
        return ((Document)this.getCmisObject()).getContentStream();
    }

    public ContentStream getContentStream(String streamId) {
        return ((Document)this.getCmisObject()).getContentStream(streamId);
    }

    public void setContentStream(ContentStream contentStream, boolean overwrite) {
        this.contentStream = contentStream;
        this.contentOverwrite = overwrite;
        this.deleteContent = false;
        this.isModified = true;
    }

    public void deleteContentStream() {
        this.deleteContent = true;
        this.contentStream = null;
        this.isModified = true;
    }

    public Document getObjectOfLatestVersion(boolean major) {
        return ((Document)this.getCmisObject()).getObjectOfLatestVersion(major);
    }

    public Document getObjectOfLatestVersion(boolean major, OperationContext context) {
        return ((Document)this.getCmisObject()).getObjectOfLatestVersion(major, context);
    }

    public List<Document> getAllVersions() {
        return ((Document)this.getCmisObject()).getAllVersions();
    }

    public List<Document> getAllVersions(OperationContext context) {
        return ((Document)this.getCmisObject()).getAllVersions(context);
    }

    public Document copy(ObjectId targetFolderId) {
        return ((Document)this.getCmisObject()).copy(targetFolderId);
    }

    public Document copy(ObjectId targetFolderId, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addACEs, List<Ace> removeACEs, OperationContext context) {
        return ((Document)this.getCmisObject()).copy(targetFolderId, properties, versioningState, policies, addACEs, removeACEs, context);
    }

    public String getCheckinComment() {
        return (String)this.getPropertyValue("cmis:checkinComment");
    }

    public String getVersionLabel() {
        return (String)this.getPropertyValue("cmis:versionLabel");
    }

    public String getVersionSeriesId() {
        return (String)this.getPropertyValue("cmis:versionSeriesId");
    }

    public String getVersionSeriesCheckedOutId() {
        return (String)this.getPropertyValue("cmis:versionSeriesCheckedOutId");
    }

    public String getVersionSeriesCheckedOutBy() {
        return (String)this.getPropertyValue("cmis:versionSeriesCheckedOutBy");
    }

    public Boolean isImmutable() {
        return (Boolean)this.getPropertyValue("cmis:isImmutable");
    }

    public Boolean isLatestMajorVersion() {
        return (Boolean)this.getPropertyValue("cmis:isLatestMajorVersion");
    }

    public Boolean isLatestVersion() {
        return (Boolean)this.getPropertyValue("cmis:isLatestVersion");
    }

    public Boolean isMajorVersion() {
        return (Boolean)this.getPropertyValue("cmis:isMajorVersion");
    }

    public Boolean isVersionSeriesCheckedOut() {
        return (Boolean)this.getPropertyValue("cmis:isVersionSeriesCheckedOut");
    }

    public long getContentStreamLength() {
        BigInteger bigInt = (BigInteger)this.getPropertyValue("cmis:contentStreamLength");
        return bigInt == null ? -1L : bigInt.longValue();
    }

    public String getContentStreamMimeType() {
        return (String)this.getPropertyValue("cmis:contentStreamMimeType");
    }

    public String getContentStreamFileName() {
        return (String)this.getPropertyValue("cmis:contentStreamFileName");
    }

    public String getContentStreamId() {
        return (String)this.getPropertyValue("cmis:contentStreamId");
    }

    @Override
    public ObjectId save() {
        if (!this.isModified()) {
            return this.getObjectId();
        }
        String objectId = this.getId();
        if (this.saveDelete(objectId)) {
            return null;
        }
        String newObjectId = objectId;
        String newChangeToken = this.getChangeToken();
        newObjectId = this.saveProperties(this.getId(), newChangeToken);
        if (this.isPropertyUpdateRequired && (this.contentStream != null || this.deleteContent)) {
            newChangeToken = this.getLatestChangeToken(newObjectId);
        }
        newObjectId = this.saveContent(newObjectId, newChangeToken);
        this.saveACL(newObjectId);
        this.savePolicies(newObjectId);
        return this.getSession().createObjectId(newObjectId);
    }

    protected String saveContent(String objectId, String changeToken) {
        Holder objectIdHolder = new Holder((Object)objectId);
        Holder changeTokenHolder = new Holder((Object)changeToken);
        if (this.contentStream != null) {
            this.getBinding().getObjectService().setContentStream(this.getRepositoryId(), objectIdHolder, Boolean.valueOf(this.contentOverwrite), changeTokenHolder, this.contentStream, null);
        } else if (this.deleteContent) {
            this.getBinding().getObjectService().deleteContentStream(this.getRepositoryId(), objectIdHolder, changeTokenHolder, null);
        }
        if (objectIdHolder.getValue() != null) {
            return (String)objectIdHolder.getValue();
        }
        return objectId;
    }

    public ObjectId checkIn(boolean major, String checkinComment) {
        Holder objectIdHolder = new Holder((Object)this.getId());
        Properties checkinProperties = this.prepareProperties();
        ArrayList checkinPolicies = null;
        if (this.addPolicies != null && !this.addPolicies.isEmpty()) {
            checkinPolicies = new ArrayList(this.addPolicies);
        }
        ArrayList<AbstractTransientCmisObject.AceChangeHolder> checkinAddAces = new ArrayList<AbstractTransientCmisObject.AceChangeHolder>();
        ArrayList<AbstractTransientCmisObject.AceChangeHolder> checkinRemoveAces = new ArrayList<AbstractTransientCmisObject.AceChangeHolder>();
        for (AclPropagation ap : AclPropagation.values()) {
            if (this.addAces.containsKey(ap)) {
                checkinAddAces.addAll((Collection)this.addAces.get(ap));
            }
            if (!this.removeAces.containsKey(ap)) continue;
            checkinAddAces.addAll((Collection)this.removeAces.get(ap));
        }
        if (this.addAces.containsKey(null)) {
            checkinAddAces.addAll((Collection)this.addAces.get(null));
        }
        if (this.removeAces.containsKey(null)) {
            checkinAddAces.addAll((Collection)this.removeAces.get(null));
        }
        this.getBinding().getVersioningService().checkIn(this.getRepositoryId(), objectIdHolder, Boolean.valueOf(major), checkinProperties, this.contentStream, checkinComment, checkinPolicies, this.prepareAcl(checkinAddAces), this.prepareAcl(checkinRemoveAces), null);
        if (objectIdHolder.getValue() != null) {
            return this.getSession().createObjectId((String)objectIdHolder.getValue());
        }
        return this.getObjectId();
    }
}

