/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cmis;

import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.display.Password;
import org.mule.api.annotations.display.Placement;
import org.mule.api.annotations.lifecycle.Start;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.api.annotations.param.Payload;
import org.mule.module.cmis.CMISFacade;
import org.mule.module.cmis.CMISFacadeAdaptor;
import org.mule.module.cmis.ChemistryCMISFacade;
import org.mule.module.cmis.NavigationOptions;
import org.mule.module.cmis.VersioningState;

@Module(name="cmis", schemaVersion="1.1", friendlyName="CMIS")
public class CMISCloudConnector
implements CMISFacade {
    @Configurable
    @Placement(group="Authentication")
    private String username;
    @Configurable
    @Password
    @Placement(group="Authentication")
    private String password;
    @Configurable
    @Optional
    @Placement(group="Connection")
    private String repositoryId;
    @Configurable
    @Placement(group="Connection")
    private String baseUrl;
    private String endpoint;
    @Configurable
    @Optional
    private String connectionTimeout = "10000";
    @Configurable
    @Optional
    private String useAlfrescoExtension = "false";
    private CMISFacade facade;

    @Start
    public void initialiseConnector() {
        if (this.facade == null) {
            boolean useAtomPub = false;
            if (this.endpoint == null) {
                useAtomPub = true;
            } else if ("soap".equals(this.endpoint)) {
                useAtomPub = false;
            } else if ("atompub".equals(this.endpoint)) {
                useAtomPub = true;
            } else {
                throw new IllegalStateException("unknown endpoint type " + this.endpoint);
            }
            this.facade = CMISFacadeAdaptor.adapt(new ChemistryCMISFacade(this.username, this.password, this.repositoryId, this.baseUrl, useAtomPub, this.connectionTimeout, this.useAlfrescoExtension));
        }
    }

    @Override
    @Processor
    public List<Repository> repositories() {
        return this.facade.repositories();
    }

    @Override
    @Processor
    public RepositoryInfo repositoryInfo() {
        return this.facade.repositoryInfo();
    }

    @Override
    @Processor
    public ChangeEvents changelog(@Optional String changeLogToken, boolean includeProperties) {
        return this.facade.changelog(changeLogToken, includeProperties);
    }

    @Override
    @Processor
    public CmisObject getObjectById(String objectId) {
        return this.facade.getObjectById(objectId);
    }

    @Override
    @Processor
    public CmisObject getObjectByPath(String path) {
        return this.facade.getObjectByPath(path);
    }

    @Override
    @Processor
    public ObjectId createDocumentByPath(String folderPath, String filename, @Payload Object content, String mimeType, VersioningState versioningState, String objectType, @Optional @Placement(group="Properties") Map<String, String> properties, @Optional @Default(value="false") boolean force) {
        return this.facade.createDocumentByPath(folderPath, filename, content, mimeType, versioningState, objectType, properties, force);
    }

    @Override
    @Processor
    public ObjectId createDocumentByPathFromContent(String folderPath, String filename, Object content, String mimeType, VersioningState versioningState, String objectType, @Optional Map<String, String> properties, @Optional @Default(value="false") boolean force) {
        return this.facade.createDocumentByPathFromContent(folderPath, filename, content, mimeType, versioningState, objectType, properties, force);
    }

    @Override
    @Processor
    public CmisObject getOrCreateFolderByPath(String folderPath) {
        return this.facade.getOrCreateFolderByPath(folderPath);
    }

    @Override
    @Processor
    public ObjectId createDocumentById(String folderId, String filename, @Payload Object content, String mimeType, VersioningState versioningState, String objectType, @Optional @Default(value="false") @Placement(group="Properties") Map<String, String> properties) {
        return this.facade.createDocumentById(folderId, filename, content, mimeType, versioningState, objectType, properties);
    }

    @Override
    @Processor
    public ObjectId createDocumentByIdFromContent(String folderId, String filename, Object content, String mimeType, VersioningState versioningState, String objectType, @Optional @Default(value="false") Map<String, String> properties) {
        return this.facade.createDocumentByIdFromContent(folderId, filename, content, mimeType, versioningState, objectType, properties);
    }

    @Override
    @Processor
    public ObjectId createFolder(String folderName, String parentObjectId) {
        return this.facade.createFolder(folderName, parentObjectId);
    }

    @Override
    @Processor
    public ObjectType getTypeDefinition(String typeId) {
        return this.facade.getTypeDefinition(typeId);
    }

    @Override
    @Processor
    public ItemIterable<Document> getCheckoutDocs(@Optional String filter, @Optional String orderBy) {
        return this.facade.getCheckoutDocs(filter, orderBy);
    }

    @Override
    @Processor
    public ItemIterable<QueryResult> query(@Placement(order=1) String statement, @Placement(order=4) Boolean searchAllVersions, @Optional @Placement(order=2) String filter, @Optional @Placement(order=3) String orderBy) {
        return this.facade.query(statement, searchAllVersions, filter, orderBy);
    }

    @Override
    @Processor
    public List<Folder> getParentFolders(@Optional CmisObject cmisObject, @Optional String objectId) {
        return this.facade.getParentFolders(cmisObject, objectId);
    }

    @Override
    @Processor
    public Object folder(@Optional @Placement(order=2) Folder folder, @Optional @Placement(order=3) String folderId, @Placement(order=1) NavigationOptions get, @Optional @Placement(order=4) Integer depth, @Optional @Placement(order=5) String filter, @Optional @Placement(order=6) String orderBy) {
        return this.facade.folder(folder, folderId, get, depth, filter, orderBy);
    }

    @Override
    @Processor
    public ContentStream getContentStream(@Optional CmisObject cmisObject, @Optional String objectId) {
        return this.facade.getContentStream(cmisObject, objectId);
    }

    @Override
    @Processor
    public FileableCmisObject moveObject(@Optional @Placement(order=3) FileableCmisObject cmisObject, @Optional @Placement(order=4) String objectId, @Placement(order=1) String sourceFolderId, @Placement(order=2) String targetFolderId) {
        return this.facade.moveObject(cmisObject, objectId, sourceFolderId, targetFolderId);
    }

    @Override
    @Processor
    public CmisObject updateObjectProperties(@Optional CmisObject cmisObject, @Optional String objectId, @Placement(group="Properties") Map<String, String> properties) {
        return this.facade.updateObjectProperties(cmisObject, objectId, properties);
    }

    @Override
    @Processor
    public List<Relationship> getObjectRelationships(@Optional CmisObject cmisObject, @Optional String objectId) {
        return this.facade.getObjectRelationships(cmisObject, objectId);
    }

    @Override
    @Processor
    public Acl getAcl(@Optional CmisObject cmisObject, @Optional String objectId) {
        return this.facade.getAcl(cmisObject, objectId);
    }

    @Override
    @Processor
    public List<Document> getAllVersions(@Optional CmisObject document, @Optional String documentId, @Optional String filter, @Optional String orderBy) {
        return this.facade.getAllVersions(document, documentId, filter, orderBy);
    }

    @Override
    @Processor
    public ObjectId checkOut(@Optional CmisObject document, @Optional String documentId) {
        return this.facade.checkOut(document, documentId);
    }

    @Override
    @Processor
    public void cancelCheckOut(@Optional CmisObject document, @Optional String documentId) {
        this.facade.cancelCheckOut(document, documentId);
    }

    @Override
    @Processor
    public ObjectId checkIn(@Optional CmisObject document, @Optional String documentId, @Payload Object content, String filename, String mimeType, boolean major, String checkinComment, @Optional @Placement(group="Properties") Map<String, String> properties) {
        return this.facade.checkIn(document, documentId, content, filename, mimeType, major, checkinComment, properties);
    }

    @Override
    @Processor
    public Acl applyAcl(@Optional CmisObject cmisObject, @Optional String objectId, @Placement(group="Add Aces") List<Ace> addAces, @Placement(group="Remove Aces") List<Ace> removeAces, @Placement(order=1) AclPropagation aclPropagation) {
        return this.facade.applyAcl(cmisObject, objectId, addAces, removeAces, aclPropagation);
    }

    @Override
    @Processor
    public List<Policy> getAppliedPolicies(@Optional CmisObject cmisObject, @Optional String objectId) {
        return this.facade.getAppliedPolicies(cmisObject, objectId);
    }

    @Override
    @Processor
    public void applyPolicy(@Optional CmisObject cmisObject, @Optional String objectId, @Placement(group="Policy Ids") List<ObjectId> policyIds) {
        this.facade.applyPolicy(cmisObject, objectId, policyIds);
    }

    @Override
    @Processor
    public void delete(@Optional CmisObject cmisObject, @Optional String objectId, @Optional @Default(value="false") boolean allVersions) {
        this.facade.delete(cmisObject, objectId, allVersions);
    }

    @Override
    @Processor
    public List<String> deleteTree(@Optional @Placement(order=1) CmisObject folder, @Optional @Placement(order=2) String folderId, @Placement(order=4) boolean allversions, @Optional @Placement(order=3) UnfileObject unfile, @Placement(order=5) boolean continueOnFailure) {
        return this.facade.deleteTree(folder, folderId, allversions, unfile, continueOnFailure);
    }

    @Override
    @Processor
    public void applyAspect(String objectId, String aspectName, Map<String, String> properties) {
        this.facade.applyAspect(objectId, aspectName, properties);
    }

    @Override
    @Processor
    public void createRelationship(String parentObjectId, String childObjectId, String relationshipType) {
        this.facade.createRelationship(parentObjectId, childObjectId, relationshipType);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getUseAlfrescoExtension() {
        return this.useAlfrescoExtension;
    }

    public void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public CMISFacade getFacade() {
        return this.facade;
    }

    public void setFacade(CMISFacade facade) {
        this.facade = facade;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setUseAlfrescoExtension(String useAlfrescoExtension) {
        this.useAlfrescoExtension = useAlfrescoExtension;
    }
}

