/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.LinkAccess;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.RepositoryUrlCache;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpUtils;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisProxyAuthenticationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBrowserBindingService
implements LinkAccess {
    private BindingSession session;

    protected void setSession(BindingSession session) {
        this.session = session;
    }

    protected BindingSession getSession() {
        return this.session;
    }

    protected String getServiceURL() {
        Object url = this.session.get("org.apache.chemistry.opencmis.binding.browser.url");
        if (url instanceof String) {
            return (String)url;
        }
        return null;
    }

    protected CmisBaseException convertStatusCode(int code, String message, String errorContent, Throwable t) {
        JSONObject json;
        Object jsonError;
        Object obj = null;
        try {
            JSONParser parser = new JSONParser();
            obj = parser.parse(errorContent);
        }
        catch (Exception pe) {
            // empty catch block
        }
        if (obj instanceof JSONObject && (jsonError = (json = (JSONObject)obj).get((Object)"exception")) instanceof String) {
            Object jsonMessage = json.get((Object)"message");
            if (jsonMessage != null) {
                message = jsonMessage.toString();
            }
            if ("constraint".equalsIgnoreCase((String)jsonError)) {
                return new CmisConstraintException(message, errorContent, t);
            }
            if ("contentAlreadyExists".equalsIgnoreCase((String)jsonError)) {
                return new CmisContentAlreadyExistsException(message, errorContent, t);
            }
            if ("filterNotValid".equalsIgnoreCase((String)jsonError)) {
                return new CmisFilterNotValidException(message, errorContent, t);
            }
            if ("invalidArgument".equalsIgnoreCase((String)jsonError)) {
                return new CmisInvalidArgumentException(message, errorContent, t);
            }
            if ("nameConstraintViolation".equalsIgnoreCase((String)jsonError)) {
                return new CmisNameConstraintViolationException(message, errorContent, t);
            }
            if ("notSupported".equalsIgnoreCase((String)jsonError)) {
                return new CmisNotSupportedException(message, errorContent, t);
            }
            if ("objectNotFound".equalsIgnoreCase((String)jsonError)) {
                return new CmisObjectNotFoundException(message, errorContent, t);
            }
            if ("permissionDenied".equalsIgnoreCase((String)jsonError)) {
                return new CmisPermissionDeniedException(message, errorContent, t);
            }
            if ("storage".equalsIgnoreCase((String)jsonError)) {
                return new CmisStorageException(message, errorContent, t);
            }
            if ("streamNotSupported".equalsIgnoreCase((String)jsonError)) {
                return new CmisStreamNotSupportedException(message, errorContent, t);
            }
            if ("updateConflict".equalsIgnoreCase((String)jsonError)) {
                return new CmisUpdateConflictException(message, errorContent, t);
            }
            if ("versioning".equalsIgnoreCase((String)jsonError)) {
                return new CmisVersioningException(message, errorContent, t);
            }
        }
        switch (code) {
            case 400: {
                return new CmisInvalidArgumentException(message, errorContent, t);
            }
            case 401: {
                return new CmisUnauthorizedException(message, errorContent, t);
            }
            case 403: {
                return new CmisPermissionDeniedException(message, errorContent, t);
            }
            case 404: {
                return new CmisObjectNotFoundException(message, errorContent, t);
            }
            case 405: {
                return new CmisNotSupportedException(message, errorContent, t);
            }
            case 407: {
                return new CmisProxyAuthenticationException(message, errorContent, t);
            }
            case 409: {
                return new CmisConstraintException(message, errorContent, t);
            }
        }
        return new CmisRuntimeException(message, errorContent, t);
    }

    protected Object parse(InputStream stream, String charset) {
        Object obj = null;
        try {
            JSONParser parser = new JSONParser();
            obj = parser.parse((Reader)new InputStreamReader(stream, charset));
        }
        catch (Exception e) {
            throw new CmisConnectionException("Parsing exception!", (Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception e) {}
        }
        return obj;
    }

    protected HttpUtils.Response read(UrlBuilder url) {
        HttpUtils.Response resp = HttpUtils.invokeGET(url, this.session);
        if (resp.getResponseCode() != 200) {
            throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
        }
        return resp;
    }

    protected HttpUtils.Response post(UrlBuilder url, String contentType, HttpUtils.Output writer) {
        HttpUtils.Response resp = HttpUtils.invokePOST(url, contentType, writer, this.session);
        if (resp.getResponseCode() != 200 && resp.getResponseCode() != 201) {
            throw this.convertStatusCode(resp.getResponseCode(), resp.getResponseMessage(), resp.getErrorContent(), null);
        }
        return resp;
    }

    protected RepositoryUrlCache geRepositoryUrlCache() {
        RepositoryUrlCache repositoryUrlCache = (RepositoryUrlCache)this.getSession().get("org.apache.chemistry.opencmis.binding.browser.repositoryurls");
        if (repositoryUrlCache == null) {
            repositoryUrlCache = new RepositoryUrlCache();
            this.getSession().put("org.apache.chemistry.opencmis.binding.browser.repositoryurls", repositoryUrlCache);
        }
        return repositoryUrlCache;
    }

    protected List<RepositoryInfo> getRepositoriesInternal(String repositoryId) {
        UrlBuilder url = new UrlBuilder(this.getServiceURL());
        url.addParameter("repositoryId", (Object)repositoryId);
        HttpUtils.Response resp = this.read(url);
        Object json = this.parse(resp.getStream(), resp.getCharset());
        if (json instanceof JSONObject) {
            return Collections.singletonList(JSONConverter.convertRepositoryInfo((JSONObject)((JSONObject)json)));
        }
        if (json instanceof JSONArray) {
            ArrayList<RepositoryInfo> repInfos = new ArrayList<RepositoryInfo>();
            for (Object ri : (JSONArray)json) {
                if (!(ri instanceof JSONObject)) continue;
                repInfos.add(JSONConverter.convertRepositoryInfo((JSONObject)((JSONObject)json)));
            }
            return repInfos;
        }
        throw new CmisConnectionException("Repository Infos could not be read!");
    }

    @Override
    public String loadLink(String repositoryId, String objectId, String rel, String type) {
        return null;
    }

    @Override
    public String loadContentLink(String repositoryId, String documentId) {
        UrlBuilder result = this.geRepositoryUrlCache().getObjectUrl(repositoryId, documentId, "content");
        return result == null ? null : result.toString();
    }
}

