
package org.mule.module.fws.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.fws.config.CreateFulfillmentOrderMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class CreateFulfillmentOrderDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public CreateFulfillmentOrderDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(CreateFulfillmentOrderMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        if ((element.getAttribute("orderId")!= null)&&(!StringUtils.isBlank(element.getAttribute("orderId")))) {
            builder.addPropertyValue("orderId", element.getAttribute("orderId"));
        }
        if ((element.getAttribute("displayableOrderId")!= null)&&(!StringUtils.isBlank(element.getAttribute("displayableOrderId")))) {
            builder.addPropertyValue("displayableOrderId", element.getAttribute("displayableOrderId"));
        }
        if ((element.getAttribute("destinationAddress-ref")!= null)&&(!StringUtils.isBlank(element.getAttribute("destinationAddress-ref")))) {
            if (element.getAttribute("destinationAddress-ref").startsWith("#")) {
                builder.addPropertyValue("destinationAddress", element.getAttribute("destinationAddress-ref"));
            } else {
                builder.addPropertyValue("destinationAddress", (("#[registry:"+ element.getAttribute("destinationAddress-ref"))+"]"));
            }
        }
        if ((element.getAttribute("fulfillmentPolicy")!= null)&&(!StringUtils.isBlank(element.getAttribute("fulfillmentPolicy")))) {
            builder.addPropertyValue("fulfillmentPolicy", element.getAttribute("fulfillmentPolicy"));
        }
        if ((element.getAttribute("fulfillmentMethod")!= null)&&(!StringUtils.isBlank(element.getAttribute("fulfillmentMethod")))) {
            builder.addPropertyValue("fulfillmentMethod", element.getAttribute("fulfillmentMethod"));
        }
        if ((element.getAttribute("shippingSpeedCategory")!= null)&&(!StringUtils.isBlank(element.getAttribute("shippingSpeedCategory")))) {
            builder.addPropertyValue("shippingSpeedCategory", element.getAttribute("shippingSpeedCategory"));
        }
        if ((element.getAttribute("displayableOrderComment")!= null)&&(!StringUtils.isBlank(element.getAttribute("displayableOrderComment")))) {
            builder.addPropertyValue("displayableOrderComment", element.getAttribute("displayableOrderComment"));
        }
        if ((element.getAttribute("displayableOrderDate")!= null)&&(!StringUtils.isBlank(element.getAttribute("displayableOrderDate")))) {
            builder.addPropertyValue("displayableOrderDate", element.getAttribute("displayableOrderDate"));
        }
        Element emailsListElement = null;
        emailsListElement = DomUtils.getChildElementByTagName(element, "emails");
        List<Element> emailsListChilds = null;
        if (emailsListElement!= null) {
            String emailsRef = emailsListElement.getAttribute("ref");
            if ((emailsRef!= null)&&(!StringUtils.isBlank(emailsRef))) {
                if ((!emailsRef.startsWith(patternInfo.getPrefix()))&&(!emailsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("emails", new RuntimeBeanReference(emailsRef));
                } else {
                    builder.addPropertyValue("emails", emailsRef);
                }
            } else {
                ManagedList emails = new ManagedList();
                emailsListChilds = DomUtils.getChildElementsByTagName(emailsListElement, "email");
                if (emailsListChilds!= null) {
                    for (Element emailsChild: emailsListChilds) {
                        String valueRef = emailsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            emails.add(new RuntimeBeanReference(valueRef));
                        } else {
                            emails.add(emailsChild.getTextContent());
                        }
                    }
                }
                builder.addPropertyValue("emails", emails);
            }
        }
        Element itemsListElement = null;
        itemsListElement = DomUtils.getChildElementByTagName(element, "items");
        List<Element> itemsListChilds = null;
        if (itemsListElement!= null) {
            String itemsRef = itemsListElement.getAttribute("ref");
            if ((itemsRef!= null)&&(!StringUtils.isBlank(itemsRef))) {
                if ((!itemsRef.startsWith(patternInfo.getPrefix()))&&(!itemsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("items", new RuntimeBeanReference(itemsRef));
                } else {
                    builder.addPropertyValue("items", itemsRef);
                }
            } else {
                ManagedList items = new ManagedList();
                itemsListChilds = DomUtils.getChildElementsByTagName(itemsListElement, "item");
                if (itemsListChilds!= null) {
                    for (Element itemsChild: itemsListChilds) {
                        String valueRef = itemsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            items.add(new RuntimeBeanReference(valueRef));
                        } else {
                            items.add(itemsChild.getTextContent());
                        }
                    }
                }
                builder.addPropertyValue("items", items);
            }
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
            if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                propertyValues.addPropertyValue("messageProcessors", new ManagedList());
            }
            List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
            listMessageProcessors.add(definition);
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
