
package org.mule.module.fws.config.spring;

import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/fws</code>.
 * 
 */
public class FWSCloudConnectorNamespaceHandler
    extends NamespaceHandlerSupport
{


    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        registerBeanDefinitionParser("config", new FWSCloudConnectorConfigDefinitionParser());
        registerBeanDefinitionParser("delete-inbound-shipment-items", new DeleteInboundShipmentItemsDefinitionParser());
        registerBeanDefinitionParser("get-fulfillment-identifier", new GetFulfillmentIdentifierDefinitionParser());
        registerBeanDefinitionParser("get-fulfillment-identifier-for-msku", new GetFulfillmentIdentifierForMskuDefinitionParser());
        registerBeanDefinitionParser("get-fulfillment-item-by-fnsku", new GetFulfillmentItemByFnskuDefinitionParser());
        registerBeanDefinitionParser("get-fulfillment-item-by-msku", new GetFulfillmentItemByMskuDefinitionParser());
        registerBeanDefinitionParser("get-inbound-shipment", new GetInboundShipmentDefinitionParser());
        registerBeanDefinitionParser("get-inbound-shipment-preview", new GetInboundShipmentPreviewDefinitionParser());
        registerBeanDefinitionParser("get-inbound-service-status", new GetInboundServiceStatusDefinitionParser());
        registerBeanDefinitionParser("list-fulfillment-items", new ListFulfillmentItemsDefinitionParser());
        registerBeanDefinitionParser("list-inbound-shipment-items", new ListInboundShipmentItemsDefinitionParser());
        registerBeanDefinitionParser("list-inbound-shipments", new ListInboundShipmentsDefinitionParser());
        registerBeanDefinitionParser("put-inbound-shipment-data", new PutInboundShipmentDataDefinitionParser());
        registerBeanDefinitionParser("put-inbound-shipment", new PutInboundShipmentDefinitionParser());
        registerBeanDefinitionParser("put-inbound-shipment-items", new PutInboundShipmentItemsDefinitionParser());
        registerBeanDefinitionParser("set-inbound-shipment-status", new SetInboundShipmentStatusDefinitionParser());
        registerBeanDefinitionParser("cancel-fulfillment-order", new CancelFulfillmentOrderDefinitionParser());
        registerBeanDefinitionParser("create-fulfillment-order", new CreateFulfillmentOrderDefinitionParser());
        registerBeanDefinitionParser("get-fulfillment-order", new GetFulfillmentOrderDefinitionParser());
        registerBeanDefinitionParser("get-fulfillment-preview", new GetFulfillmentPreviewDefinitionParser());
        registerBeanDefinitionParser("get-outbound-service-status", new GetOutboundServiceStatusDefinitionParser());
        registerBeanDefinitionParser("list-fulfillment-orders", new ListFulfillmentOrdersDefinitionParser());
        registerBeanDefinitionParser("get-inventory-supply", new GetInventorySupplyDefinitionParser());
        registerBeanDefinitionParser("get-inventory-service-status", new GetInventoryServiceStatusDefinitionParser());
        registerBeanDefinitionParser("list-updated-inventory-supply", new ListUpdatedInventorySupplyDefinitionParser());
    }

}
