
package org.mule.module.fws.config.spring;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.config.spring.util.SpringXMLUtils;
import org.mule.module.fws.config.GetFulfillmentPreviewMessageProcessor;
import org.mule.util.TemplateParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GetFulfillmentPreviewDefinitionParser
    implements BeanDefinitionParser
{

    /**
     * Mule Pattern Info
     * 
     */
    private TemplateParser.PatternInfo patternInfo;

    public GetFulfillmentPreviewDefinitionParser() {
        patternInfo = TemplateParser.createMuleStyleParser().getStyle();
    }

    public BeanDefinition parse(Element element, ParserContext parserContent) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(GetFulfillmentPreviewMessageProcessor.class.getName());
        String configRef = element.getAttribute("config-ref");
        if ((configRef!= null)&&(!StringUtils.isBlank(configRef))) {
            builder.addPropertyValue("moduleObject", configRef);
        }
        Element addressListElement = null;
        addressListElement = DomUtils.getChildElementByTagName(element, "address");
        List<Element> addressListChilds = null;
        if (addressListElement!= null) {
            String addressRef = addressListElement.getAttribute("ref");
            if ((addressRef!= null)&&(!StringUtils.isBlank(addressRef))) {
                if ((!addressRef.startsWith(patternInfo.getPrefix()))&&(!addressRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("address", new RuntimeBeanReference(addressRef));
                } else {
                    builder.addPropertyValue("address", addressRef);
                }
            } else {
                ManagedMap address = new ManagedMap();
                addressListChilds = DomUtils.getChildElementsByTagName(addressListElement, "addres");
                if (addressListChilds!= null) {
                    if (addressListChilds.size() == 0) {
                        addressListChilds = DomUtils.getChildElements(addressListElement);
                    }
                    for (Element addressChild: addressListChilds) {
                        String addressValueRef = addressChild.getAttribute("value-ref");
                        String addressKeyRef = addressChild.getAttribute("key-ref");
                        Object valueObject = null;
                        Object keyObject = null;
                        if ((addressValueRef!= null)&&(!StringUtils.isBlank(addressValueRef))) {
                            valueObject = new RuntimeBeanReference(addressValueRef);
                        } else {
                            valueObject = addressChild.getTextContent();
                        }
                        if ((addressKeyRef!= null)&&(!StringUtils.isBlank(addressKeyRef))) {
                            keyObject = new RuntimeBeanReference(addressKeyRef);
                        } else {
                            keyObject = addressChild.getAttribute("key");
                        }
                        if ((keyObject == null)||((keyObject instanceof String)&&StringUtils.isBlank(((String) keyObject)))) {
                            keyObject = addressChild.getTagName();
                        }
                        address.put(keyObject, valueObject);
                    }
                }
                builder.addPropertyValue("address", address);
            }
        }
        Element itemsListElement = null;
        itemsListElement = DomUtils.getChildElementByTagName(element, "items");
        List<Element> itemsListChilds = null;
        if (itemsListElement!= null) {
            String itemsRef = itemsListElement.getAttribute("ref");
            if ((itemsRef!= null)&&(!StringUtils.isBlank(itemsRef))) {
                if ((!itemsRef.startsWith(patternInfo.getPrefix()))&&(!itemsRef.endsWith(patternInfo.getSuffix()))) {
                    builder.addPropertyValue("items", new RuntimeBeanReference(itemsRef));
                } else {
                    builder.addPropertyValue("items", itemsRef);
                }
            } else {
                ManagedList items = new ManagedList();
                itemsListChilds = DomUtils.getChildElementsByTagName(itemsListElement, "item");
                if (itemsListChilds!= null) {
                    for (Element itemsChild: itemsListChilds) {
                        String valueRef = itemsChild.getAttribute("value-ref");
                        if ((valueRef!= null)&&(!StringUtils.isBlank(valueRef))) {
                            items.add(new RuntimeBeanReference(valueRef));
                        } else {
                            items.add(itemsChild.getTextContent());
                        }
                    }
                }
                builder.addPropertyValue("items", items);
            }
        }
        if ((element.getAttribute("shippingSpeedCategories")!= null)&&(!StringUtils.isBlank(element.getAttribute("shippingSpeedCategories")))) {
            builder.addPropertyValue("shippingSpeedCategories", element.getAttribute("shippingSpeedCategories"));
        }
        if ((element.getAttribute("orderItemId")!= null)&&(!StringUtils.isBlank(element.getAttribute("orderItemId")))) {
            builder.addPropertyValue("orderItemId", element.getAttribute("orderItemId"));
        }
        BeanDefinition definition = builder.getBeanDefinition();
        definition.setAttribute(MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE, Boolean.TRUE);
        MutablePropertyValues propertyValues = parserContent.getContainingBeanDefinition().getPropertyValues();
        if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.config.spring.factories.PollingMessageSourceFactoryBean")) {
            propertyValues.addPropertyValue("messageProcessor", definition);
        } else {
            if (parserContent.getContainingBeanDefinition().getBeanClassName().equals("org.mule.enricher.MessageEnricher")) {
                propertyValues.addPropertyValue("enrichmentMessageProcessor", definition);
            } else {
                PropertyValue messageProcessors = propertyValues.getPropertyValue("messageProcessors");
                if ((messageProcessors == null)||(messageProcessors.getValue() == null)) {
                    propertyValues.addPropertyValue("messageProcessors", new ManagedList());
                }
                List listMessageProcessors = ((List) propertyValues.getPropertyValue("messageProcessors").getValue());
                listMessageProcessors.add(definition);
            }
        }
        return definition;
    }

    protected String getAttributeValue(Element element, String attributeName) {
        if (!StringUtils.isEmpty(element.getAttribute(attributeName))) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String generateChildBeanName(Element element) {
        String id = SpringXMLUtils.getNameOrId(element);
        if (StringUtils.isBlank(id)) {
            String parentId = SpringXMLUtils.getNameOrId(((Element) element.getParentNode()));
            return ((("."+ parentId)+":")+ element.getLocalName());
        } else {
            return id;
        }
    }

}
